/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.integration.lazy.loading.artifacts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.appserver.integration.common.clients.WebAppAdminClient;
import org.wso2.appserver.integration.common.utils.WebAppDeploymentUtil;
import org.wso2.appserver.integration.lazy.loading.LazyLoadingBaseTest;
import org.wso2.appserver.integration.lazy.loading.util.LazyLoadingTestException;
import org.wso2.appserver.integration.lazy.loading.util.WebAppStatusBean;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.automation.test.utils.http.client.HttpURLConnectionClient;

public class WebApplicationGhostDeploymentTestCase
extends LazyLoadingBaseTest {
    private static final Log log = LogFactory.getLog(WebApplicationGhostDeploymentTestCase.class);
    private static final String WEB_APP_FILE_NAME1 = "appServer-valied-deploymant-1.0.0.war";
    private static final String WEB_APP_NAME1 = "appServer-valied-deploymant-1.0.0";
    private static final String WEB_APP_FILE_NAME2 = "helloworld.war";
    private static final String WEB_APP_NAME2 = "helloworld";
    private static final String WEB_APP1_RESPONSE = "<status>success</status>";
    private static final String WEB_APP2_RESPONSE = "<h2>Hello, World.</h2>";
    private String webApp1Location;
    private String webApp2Location;
    private String tenant1WebApp1URL;
    private String tenant1WebApp2URL;
    private volatile List<String> responseDataList = new ArrayList<String>();
    private volatile List<String> responseDetailedInfoList = new ArrayList<String>();

    @Override
    @BeforeClass(alwaysRun=true)
    public void init() throws Exception {
        super.init();
        this.webApp1Location = this.artifactsLocation + WEB_APP_FILE_NAME1;
        this.webApp2Location = this.artifactsLocation + WEB_APP_FILE_NAME2;
        this.tenant1WebApp1URL = this.webAppURL + "/t/" + this.tenantDomain1 + "/webapps/" + WEB_APP_NAME1 + "/";
        this.tenant1WebApp2URL = this.webAppURL + "/t/" + this.tenantDomain1 + "/webapps/" + WEB_APP_NAME2 + "/hi.jsp";
    }

    @Test(groups={"wso2.as.lazy.loading"}, description="Deploying web application in Ghost Deployment enable environment. Each Web application should fully loaded (non Ghost format) soon after the deployment", alwaysRun=true)
    public void testDeployWebApplicationInGhostDeployment() throws Exception {
        log.info((Object)"deployment of  web application started");
        this.init("tenant1", "admin");
        this.webAppAdminClient = new WebAppAdminClient(this.backendURL, this.sessionCookie);
        this.webAppAdminClient.uploadWarFile(this.webApp1Location);
        Assert.assertTrue((boolean)WebAppDeploymentUtil.isWebApplicationDeployed((String)this.backendURL, (String)this.sessionCookie, (String)WEB_APP_NAME1), (String)("Web Application deployment failed: appServer-valied-deploymant-1.0.0on " + this.tenantDomain1));
        WebAppStatusBean webAppStatusTenant1WebApp1 = this.getWebAppStatus(this.tenantDomain1, WEB_APP_FILE_NAME1);
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.getTenantStatus().isTenantContextLoaded(), (String)(" Tenant Context is not loaded. Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.isWebAppStarted(), (String)("Web-App: appServer-valied-deploymant-1.0.0.war is not started after deployment in Tenant:" + this.tenantDomain1));
        Assert.assertFalse((boolean)webAppStatusTenant1WebApp1.isWebAppGhost(), (String)("Web-App: appServer-valied-deploymant-1.0.0.war is in ghost mode after deployment in Tenant:" + this.tenantDomain1));
        this.webAppAdminClient.uploadWarFile(this.webApp2Location);
        Assert.assertTrue((boolean)WebAppDeploymentUtil.isWebApplicationDeployed((String)this.backendURL, (String)this.sessionCookie, (String)WEB_APP_NAME2), (String)("Web Application deployment failed: helloworldon " + this.tenantDomain1));
        WebAppStatusBean webAppStatusTenant1WebApp2 = this.getWebAppStatus(this.tenantDomain1, WEB_APP_FILE_NAME2);
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp2.getTenantStatus().isTenantContextLoaded(), (String)(" Tenant Context is not loaded. Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp2.isWebAppStarted(), (String)("Web-App: helloworld.war is not started after deployment in Tenant:" + this.tenantDomain1));
        Assert.assertFalse((boolean)webAppStatusTenant1WebApp2.isWebAppGhost(), (String)("Web-App: helloworld.war is in ghost mode after deployment in Tenant:" + this.tenantDomain1));
        this.init("tenant2", "admin");
        this.webAppAdminClient = new WebAppAdminClient(this.backendURL, this.sessionCookie);
        this.webAppAdminClient.uploadWarFile(this.webApp1Location);
        Assert.assertTrue((boolean)WebAppDeploymentUtil.isWebApplicationDeployed((String)this.backendURL, (String)this.sessionCookie, (String)WEB_APP_NAME1), (String)("Web Application deployment failed: appServer-valied-deploymant-1.0.0on " + this.tenantDomain2));
        WebAppStatusBean webAppStatusTenant2WebApp1 = this.getWebAppStatus(this.tenantDomain2, WEB_APP_FILE_NAME1);
        Assert.assertTrue((boolean)webAppStatusTenant2WebApp1.getTenantStatus().isTenantContextLoaded(), (String)(" Tenant Context is not loaded. Tenant:" + this.tenantDomain2));
        Assert.assertTrue((boolean)webAppStatusTenant2WebApp1.isWebAppStarted(), (String)("Web-App: appServer-valied-deploymant-1.0.0.war is not started after deployment in Tenant:" + this.tenantDomain2));
        Assert.assertFalse((boolean)webAppStatusTenant2WebApp1.isWebAppGhost(), (String)("Web-App: appServer-valied-deploymant-1.0.0.war is in ghost mode after deployment in Tenant:" + this.tenantDomain2));
        this.webAppAdminClient.uploadWarFile(this.webApp2Location);
        Assert.assertTrue((boolean)WebAppDeploymentUtil.isWebApplicationDeployed((String)this.backendURL, (String)this.sessionCookie, (String)WEB_APP_NAME2), (String)("Web Application deployment failed: helloworldon " + this.tenantDomain2));
        WebAppStatusBean webAppStatusTenant2WebApp2 = this.getWebAppStatus(this.tenantDomain2, WEB_APP_FILE_NAME2);
        Assert.assertTrue((boolean)webAppStatusTenant2WebApp2.getTenantStatus().isTenantContextLoaded(), (String)(" Tenant Context is not loaded. Tenant:" + this.tenantDomain2));
        Assert.assertTrue((boolean)webAppStatusTenant2WebApp2.isWebAppStarted(), (String)("Web-App: helloworld.war is not started after deployment in Tenant:" + this.tenantDomain2));
        Assert.assertFalse((boolean)webAppStatusTenant2WebApp2.isWebAppGhost(), (String)("Web-App: helloworld.war is in ghost mode after deployment in Tenant:" + this.tenantDomain2));
        log.info((Object)"deployment of web application finished");
    }

    @Test(groups={"wso2.as.lazy.loading"}, description="Invoke web application in Ghost Deployment enable environment.First test will restart the server gracefully.After the restart all tenant context should not be loaded.Then, it invokes the first web app on first tenant. After the invoke, only that web app should loaded fully.", dependsOnMethods={"testDeployWebApplicationInGhostDeployment"})
    public void testInvokeWebAppInGhostDeployment() throws Exception {
        this.serverManager.restartGracefully();
        Assert.assertFalse((boolean)this.getTenantStatus(this.tenantDomain1).isTenantContextLoaded(), (String)("Tenant Name:" + this.tenantDomain1 + " loaded before access."));
        Assert.assertFalse((boolean)this.getTenantStatus(this.tenantDomain2).isTenantContextLoaded(), (String)("Tenant Name:" + this.tenantDomain2 + " loaded before access."));
        HttpResponse httpResponse = HttpURLConnectionClient.sendGetRequest((String)this.tenant1WebApp1URL, null);
        Assert.assertEquals((String)httpResponse.getData(), (String)WEB_APP1_RESPONSE, (String)("Web app invocation fail. web app URL:" + this.tenant1WebApp1URL));
        WebAppStatusBean webAppStatusTenant1WebApp1 = this.getWebAppStatus(this.tenantDomain1, WEB_APP_FILE_NAME1);
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.getTenantStatus().isTenantContextLoaded(), (String)(" Tenant Context is not loaded. Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.isWebAppStarted(), (String)("Web-App: appServer-valied-deploymant-1.0.0.war is not started in Tenant:" + this.tenantDomain1));
        Assert.assertFalse((boolean)webAppStatusTenant1WebApp1.isWebAppGhost(), (String)("Web-App: appServer-valied-deploymant-1.0.0.war is in ghost mode after invoking in Tenant:" + this.tenantDomain1));
        WebAppStatusBean webAppStatusTenant1WebApp2 = this.getWebAppStatus(this.tenantDomain1, WEB_APP_FILE_NAME2);
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp2.getTenantStatus().isTenantContextLoaded(), (String)(" Tenant Context is not loaded. Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp2.isWebAppStarted(), (String)("Web-App: helloworld.war is not started  in Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp2.isWebAppGhost(), (String)("Web-App: helloworld.war is loaded before access and after access other web app in same Tenant:" + this.tenantDomain1));
        Assert.assertFalse((boolean)this.getTenantStatus(this.tenantDomain2).isTenantContextLoaded(), (String)("Tenant Name:" + this.tenantDomain2 + " loaded before access."));
    }

    @Test(groups={"wso2.as.lazy.loading"}, description="Send a Get request after a web app is auto unload and reload in to Ghost form. After access web app, it should be in fully load form  the Ghost form", dependsOnMethods={"testInvokeWebAppInGhostDeployment"})
    public void testWebAppAutoUnLoadAndInvokeInGhostDeployment() throws LazyLoadingTestException {
        HttpResponse httpResponse;
        Assert.assertTrue((boolean)this.checkWebAppAutoUnloadingToGhostState(this.tenantDomain1, WEB_APP_FILE_NAME1), (String)("Web-app is not un-loaded ane re-deployed in Ghost form after idle time pass. Tenant Name:" + this.tenantDomain1 + " Web_app Name: " + WEB_APP_FILE_NAME1));
        try {
            httpResponse = HttpURLConnectionClient.sendGetRequest((String)this.tenant1WebApp1URL, null);
        }
        catch (IOException ioException) {
            String customErrorMessage = "IOException Exception when  send a GET request to" + this.tenant1WebApp1URL + "\n" + ioException.getMessage();
            log.error((Object)customErrorMessage);
            throw new LazyLoadingTestException(customErrorMessage, ioException);
        }
        Assert.assertEquals((String)httpResponse.getData(), (String)WEB_APP1_RESPONSE, (String)"Web app invocation fail");
        WebAppStatusBean webAppStatusTenant1WebApp1 = this.getWebAppStatus(this.tenantDomain1, WEB_APP_FILE_NAME1);
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.getTenantStatus().isTenantContextLoaded(), (String)(" Tenant Context is not loaded. Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.isWebAppStarted(), (String)("Web-App: appServer-valied-deploymant-1.0.0.war is not started in Tenant:" + this.tenantDomain1));
        Assert.assertFalse((boolean)webAppStatusTenant1WebApp1.isWebAppGhost(), (String)("Web-App: appServer-valied-deploymant-1.0.0.war is in ghost mode after invoking in Tenant:" + this.tenantDomain1));
    }

    @Test(groups={"wso2.as.lazy.loading"}, description="Test web application auto unload  and reload in Ghost form. After access web app, it should be in fully load form  but after configured web app idle time pass it should get auto unload ne reload in Ghost form.", dependsOnMethods={"testWebAppAutoUnLoadAndInvokeInGhostDeployment"})
    public void testWebAppAutoUnLoadAndReloadToGhostFormInGhostDeployment() throws Exception {
        this.serverManager.restartGracefully();
        HttpResponse httpResponse = HttpURLConnectionClient.sendGetRequest((String)this.tenant1WebApp1URL, null);
        Assert.assertEquals((String)httpResponse.getData(), (String)WEB_APP1_RESPONSE, (String)"Web app invocation fail");
        WebAppStatusBean webAppStatusTenant1WebApp1 = this.getWebAppStatus(this.tenantDomain1, WEB_APP_FILE_NAME1);
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.getTenantStatus().isTenantContextLoaded(), (String)(" Tenant Context is not loaded. Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.isWebAppStarted(), (String)("Web-App: appServer-valied-deploymant-1.0.0.war is not started in Tenant:" + this.tenantDomain1));
        Assert.assertFalse((boolean)webAppStatusTenant1WebApp1.isWebAppGhost(), (String)("Web-App: appServer-valied-deploymant-1.0.0.war is in ghost mode after invoking in Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)this.checkWebAppAutoUnloadingToGhostState(this.tenantDomain1, WEB_APP_FILE_NAME1), (String)("Web-app is not un-loaded ane re-deployed in Ghost form after idle time pass. Tenant Name:" + this.tenantDomain1 + " Web_app Name: " + WEB_APP_FILE_NAME1));
    }

    @Test(groups={"wso2.as.lazy.loading"}, description="Test Unload of tenant configuration context  after tenant idle time pass without any action with that tenant", dependsOnMethods={"testWebAppAutoUnLoadAndReloadToGhostFormInGhostDeployment"})
    public void testTenantUnloadInIdleTimeAfterWebAPPUsageInGhostDeployment() throws Exception {
        this.serverManager.restartGracefully();
        Assert.assertFalse((boolean)this.getTenantStatus(this.tenantDomain1).isTenantContextLoaded(), (String)("Tenant context is  loaded before access. Tenant name: " + this.tenantDomain1));
        HttpResponse httpResponse = HttpURLConnectionClient.sendGetRequest((String)this.tenant1WebApp1URL, null);
        Assert.assertEquals((String)httpResponse.getData(), (String)WEB_APP1_RESPONSE, (String)"Web app invocation fail");
        Assert.assertTrue((boolean)this.getTenantStatus(this.tenantDomain1).isTenantContextLoaded(), (String)("Tenant context is  not loaded after access. Tenant name: " + this.tenantDomain1));
        Assert.assertTrue((boolean)this.checkTenantAutoUnloading(this.tenantDomain1), (String)("Tenant context is  not unloaded after idle time. Tenant name: " + this.tenantDomain1));
    }

    @Test(groups={"wso2.as.lazy.loading"}, description="Send concurrent requests  when tenant context is not loaded.All request should  get expected output", dependsOnMethods={"testTenantUnloadInIdleTimeAfterWebAPPUsageInGhostDeployment"}, enabled=false)
    public void testConcurrentWebAPPInvocationsWhenTenantContextNotLoadedInGhostDeployment() throws Exception {
        this.serverManager.restartGracefully();
        Assert.assertFalse((boolean)this.getTenantStatus(this.tenantDomain1).isTenantContextLoaded(), (String)("Tenant context is  loaded before access. Tenant name: " + this.tenantDomain1));
        ExecutorService executorService = Executors.newFixedThreadPool(40);
        log.info((Object)"Concurrent invocation Start");
        log.info((Object)"Expected Response Data:<status>success</status>");
        int i = 0;
        while (i < 40) {
            final int requestId = i++;
            executorService.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HttpResponse httpResponse = null;
                    try {
                        httpResponse = HttpURLConnectionClient.sendGetRequest((String)WebApplicationGhostDeploymentTestCase.this.tenant1WebApp1URL, null);
                    }
                    catch (IOException e) {
                        log.error((Object)("Error  when sending a  get request  for :" + WebApplicationGhostDeploymentTestCase.this.tenant1WebApp1URL), (Throwable)e);
                    }
                    1 var2_3 = this;
                    synchronized (var2_3) {
                        String responseData;
                        String responseDetailedInfo;
                        if (httpResponse != null) {
                            responseDetailedInfo = "Request ID " + requestId + "Response Data :" + httpResponse.getData() + "\tResponse Code:" + httpResponse.getResponseCode();
                            responseData = httpResponse.getData();
                        } else {
                            responseDetailedInfo = "Request ID " + requestId + "Response Data : NULL Object return from " + "HttpURLConnectionClient";
                            responseData = "NULL Object return";
                        }
                        WebApplicationGhostDeploymentTestCase.this.responseDataList.add(responseData);
                        log.info((Object)responseDetailedInfo);
                        WebApplicationGhostDeploymentTestCase.this.responseDetailedInfoList.add(responseDetailedInfo);
                    }
                }
            });
        }
        executorService.shutdown();
        executorService.awaitTermination(5L, TimeUnit.MINUTES);
        log.info((Object)"Concurrent invocation End");
        int correctResponseCount = 0;
        for (String responseData : this.responseDataList) {
            if (!WEB_APP1_RESPONSE.equals(responseData)) continue;
            ++correctResponseCount;
        }
        StringBuilder allDetailResponseStringBuffer = new StringBuilder();
        allDetailResponseStringBuffer.append("\n");
        for (String responseInfo : this.responseDetailedInfoList) {
            allDetailResponseStringBuffer.append(responseInfo);
            allDetailResponseStringBuffer.append("\n");
        }
        String allDetailResponse = allDetailResponseStringBuffer.toString();
        WebAppStatusBean webAppStatusTenant1WebApp1 = this.getWebAppStatus(this.tenantDomain1, WEB_APP_FILE_NAME1);
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.getTenantStatus().isTenantContextLoaded(), (String)(" Tenant Context is not loaded. Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.isWebAppStarted(), (String)("Web-App: appServer-valied-deploymant-1.0.0.war is not started in Tenant:" + this.tenantDomain1));
        Assert.assertFalse((boolean)webAppStatusTenant1WebApp1.isWebAppGhost(), (String)("Web-App: appServer-valied-deploymant-1.0.0.war is in ghost mode after invoking in Tenant:" + this.tenantDomain1));
        Assert.assertEquals((int)correctResponseCount, (int)40, (String)(allDetailResponse + "All the concurrent requests " + "not get correct response."));
    }

    @Test(groups={"wso2.as.lazy.loading"}, description="Send concurrent requests  when tenant context is loaded. But Web-App is in Ghost form. All request should  get expected output", dependsOnMethods={"testConcurrentWebAPPInvocationsWhenTenantContextNotLoadedInGhostDeployment"}, enabled=false)
    public void testConcurrentWebAPPInvocationsWhenTenantContextLoadedInGhostDeployment() throws Exception {
        this.serverManager.restartGracefully();
        this.responseDataList.clear();
        this.responseDetailedInfoList.clear();
        Assert.assertFalse((boolean)this.getTenantStatus(this.tenantDomain1).isTenantContextLoaded(), (String)("Tenant context is  loaded before access. Tenant name: " + this.tenantDomain1));
        HttpResponse httpResponseApp2 = HttpURLConnectionClient.sendGetRequest((String)this.tenant1WebApp2URL, null);
        Assert.assertTrue((boolean)httpResponseApp2.getData().contains(WEB_APP2_RESPONSE), (String)("Invocation of Web-App fail :" + this.tenant1WebApp2URL));
        Assert.assertTrue((boolean)this.getTenantStatus(this.tenantDomain1).isTenantContextLoaded(), (String)("Tenant context is  not loaded after access. Tenant name: " + this.tenantDomain1));
        WebAppStatusBean webAppStatusTenant1WebApp2 = this.getWebAppStatus(this.tenantDomain1, WEB_APP_FILE_NAME2);
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp2.isWebAppStarted(), (String)("Web-App: helloworld.war is not started in Tenant:" + this.tenantDomain1));
        Assert.assertFalse((boolean)webAppStatusTenant1WebApp2.isWebAppGhost(), (String)("Web-App: helloworld.war is in ghost mode after invoking in Tenant:" + this.tenantDomain1));
        WebAppStatusBean webAppStatusTenant1WebApp1 = this.getWebAppStatus(this.tenantDomain1, WEB_APP_FILE_NAME1);
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.isWebAppStarted(), (String)("Web-App: appServer-valied-deploymant-1.0.0.war is not started in Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.isWebAppGhost(), (String)("Web-App: appServer-valied-deploymant-1.0.0.war is in not ghost mode before invoking in Tenant:" + this.tenantDomain1));
        ExecutorService executorService = Executors.newFixedThreadPool(40);
        log.info((Object)"Concurrent invocation Start");
        log.info((Object)"Expected Response Data:<status>success</status>");
        int i = 0;
        while (i < 40) {
            final int requestId = i++;
            executorService.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HttpResponse httpResponse = null;
                    try {
                        httpResponse = HttpURLConnectionClient.sendGetRequest((String)WebApplicationGhostDeploymentTestCase.this.tenant1WebApp1URL, null);
                    }
                    catch (IOException e) {
                        log.error((Object)("Error  when sending a  get request  for :" + WebApplicationGhostDeploymentTestCase.this.tenant1WebApp1URL), (Throwable)e);
                    }
                    2 var2_3 = this;
                    synchronized (var2_3) {
                        String responseData;
                        String responseDetailedInfo;
                        if (httpResponse != null) {
                            responseDetailedInfo = "Request ID " + requestId + "Response Data :" + httpResponse.getData() + "\tResponse Code:" + httpResponse.getResponseCode();
                            responseData = httpResponse.getData();
                        } else {
                            responseDetailedInfo = "Request ID " + requestId + "Response Data : NULL Object return from " + "HttpURLConnectionClient";
                            responseData = "NULL Object return";
                        }
                        WebApplicationGhostDeploymentTestCase.this.responseDataList.add(responseData);
                        log.info((Object)responseDetailedInfo);
                        WebApplicationGhostDeploymentTestCase.this.responseDetailedInfoList.add(responseDetailedInfo);
                    }
                }
            });
        }
        executorService.shutdown();
        executorService.awaitTermination(5L, TimeUnit.MINUTES);
        log.info((Object)"Concurrent invocation End");
        int correctResponseCount = 0;
        for (String responseData : this.responseDataList) {
            if (!WEB_APP1_RESPONSE.equals(responseData)) continue;
            ++correctResponseCount;
        }
        StringBuilder allDetailResponseStringBuffer = new StringBuilder();
        allDetailResponseStringBuffer.append("\n");
        for (String responseInfo : this.responseDetailedInfoList) {
            allDetailResponseStringBuffer.append(responseInfo);
            allDetailResponseStringBuffer.append("\n");
        }
        String allDetailResponse = allDetailResponseStringBuffer.toString();
        webAppStatusTenant1WebApp1 = this.getWebAppStatus(this.tenantDomain1, WEB_APP_FILE_NAME1);
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.getTenantStatus().isTenantContextLoaded(), (String)(" Tenant Context is not loaded. Tenant:" + this.tenantDomain1));
        Assert.assertTrue((boolean)webAppStatusTenant1WebApp1.isWebAppStarted(), (String)("Web-App: appServer-valied-deploymant-1.0.0.war is not started in Tenant:" + this.tenantDomain1));
        Assert.assertFalse((boolean)webAppStatusTenant1WebApp1.isWebAppGhost(), (String)("Web-App: appServer-valied-deploymant-1.0.0.war is in ghost mode after invoking in Tenant:" + this.tenantDomain1));
        Assert.assertEquals((int)correctResponseCount, (int)40, (String)(allDetailResponse + "All the concurrent" + " requests not get correct response."));
    }

    @AfterClass(alwaysRun=true)
    public void cleanWebApplications() throws Exception {
        this.init("tenant1", "admin");
        this.webAppAdminClient = new WebAppAdminClient(this.backendURL, this.sessionCookie);
        this.webAppAdminClient.deleteWebAppFile(WEB_APP_FILE_NAME1, this.hostURL);
        Assert.assertTrue((boolean)WebAppDeploymentUtil.isWebApplicationUnDeployed((String)this.backendURL, (String)this.sessionCookie, (String)WEB_APP_NAME1), (String)("Web Application un-deployment failed : Web app :appServer-valied-deploymant-1.0.0 on " + this.tenantDomain1));
        this.webAppAdminClient.deleteWebAppFile(WEB_APP_FILE_NAME2, this.hostURL);
        Assert.assertTrue((boolean)WebAppDeploymentUtil.isWebApplicationUnDeployed((String)this.backendURL, (String)this.sessionCookie, (String)WEB_APP_NAME2), (String)("Web Application un-deployment failed: Web app :helloworld on " + this.tenantDomain1));
        this.init("tenant2", "admin");
        this.webAppAdminClient = new WebAppAdminClient(this.backendURL, this.sessionCookie);
        this.webAppAdminClient.deleteWebAppFile(WEB_APP_FILE_NAME1, this.hostURL);
        Assert.assertTrue((boolean)WebAppDeploymentUtil.isWebApplicationUnDeployed((String)this.backendURL, (String)this.sessionCookie, (String)WEB_APP_NAME1), (String)("Web Application un-deployment failed : Web app :appServer-valied-deploymant-1.0.0 on " + this.tenantDomain2));
        this.webAppAdminClient.deleteWebAppFile(WEB_APP_FILE_NAME2, this.hostURL);
        Assert.assertTrue((boolean)WebAppDeploymentUtil.isWebApplicationUnDeployed((String)this.backendURL, (String)this.sessionCookie, (String)WEB_APP_NAME2), (String)("Web Application un-deployment failed: Web app :helloworld on " + this.tenantDomain2));
    }
}

