/*
 * Decompiled with CFR 0.152.
 */
package demo.jaxrs.server;

import demo.jaxrs.server.SecurityCheckResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.log4j.Logger;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.DBUtils;
import org.wso2.carbon.utils.NetworkUtils;
import org.wso2.carbon.utils.Utils;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/")
public class SecurityCheckService {
    private static final Logger logger = Logger.getLogger(SecurityCheckService.class);

    public SecurityCheckService() {
        this.init();
    }

    @GET
    @Path(value="systemProperty/{id}")
    @Produces(value={"application/json"})
    public SecurityCheckResponse getSystemProperty(@PathParam(value="id") String id) {
        String output = "";
        try {
            output = "SYSTEM PROPERTY > " + System.getProperty(id);
        }
        catch (Exception e) {
            output = "Error occurred while reading system property. Reason: " + e.getMessage();
            logger.error((Object)output, (Throwable)e);
        }
        SecurityCheckResponse c = new SecurityCheckResponse();
        c.setResponseMessage(output);
        return c;
    }

    final void init() {
    }

    @POST
    @Path(value="/file")
    @Produces(value={"application/json"})
    public SecurityCheckResponse fileCreate(@QueryParam(value="fileName") String name) {
        String serverHomeDir = CarbonUtils.getCarbonHome();
        String output = "";
        try {
            File curr = new File(serverHomeDir + "/" + name);
            if (curr.createNewFile()) {
                output = "File Created Successfully";
            }
        }
        catch (Exception e) {
            output = "Error occurred while creating file. Reason: " + e.getMessage();
            logger.error((Object)output, (Throwable)e);
        }
        SecurityCheckResponse c = new SecurityCheckResponse();
        c.setResponseMessage(output);
        return c;
    }

    @POST
    @Path(value="/directFile")
    @Produces(value={"application/json"})
    public SecurityCheckResponse fileDirectCreate(@QueryParam(value="fileName") String name) {
        String serverHomeDir = CarbonUtils.getCarbonHome();
        String output = "";
        try {
            File curr = new File(serverHomeDir + "/" + name);
            if (curr.createNewFile()) {
                output = "File Created Successfully";
            }
        }
        catch (Exception e) {
            output = "Error occurred while creating file. Reason: " + e.getMessage();
            logger.error((Object)output, (Throwable)e);
        }
        SecurityCheckResponse c = new SecurityCheckResponse();
        c.setResponseMessage(output);
        return c;
    }

    @DELETE
    @Path(value="/file")
    @Produces(value={"application/json"})
    public SecurityCheckResponse fileDelete(@QueryParam(value="fileName") String name) {
        String serverHomeDir = CarbonUtils.getCarbonHome();
        String output = "";
        try {
            File curr = new File(serverHomeDir + "/" + name);
            if (curr.delete()) {
                output = "File Deleted Successfully";
            }
        }
        catch (Exception e) {
            output = "Error occurred while deleting file. Reason: " + e.getMessage();
            logger.error((Object)output, (Throwable)e);
        }
        SecurityCheckResponse c = new SecurityCheckResponse();
        c.setResponseMessage(output);
        return c;
    }

    @DELETE
    @Path(value="/directFile")
    @Produces(value={"application/json"})
    public SecurityCheckResponse fileDirectDelete(@QueryParam(value="fileName") String name) {
        String output = "";
        try {
            File curr = new File(name);
            if (curr.delete()) {
                output = "File Deleted Successfully";
            }
        }
        catch (Exception e) {
            output = "Error occurred while deleting file. Reason: " + e.getMessage();
            logger.error((Object)output, (Throwable)e);
        }
        SecurityCheckResponse c = new SecurityCheckResponse();
        c.setResponseMessage(output);
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/directFile")
    @Produces(value={"application/json"})
    public SecurityCheckResponse fileDirectRead(@QueryParam(value="fileName") String name) {
        String output = "";
        try {
            BufferedReader br = new BufferedReader(new FileReader(name));
            try {
                StringBuilder sb = new StringBuilder();
                String line = br.readLine();
                while (line != null) {
                    sb.append(line);
                    sb.append("\n");
                    line = br.readLine();
                }
                output = sb.toString();
            }
            finally {
                br.close();
            }
        }
        catch (Exception e) {
            output = "Error occurred while reading file. Reason: " + e.getMessage();
            logger.error((Object)output, (Throwable)e);
        }
        SecurityCheckResponse c = new SecurityCheckResponse();
        c.setResponseMessage(output);
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/file")
    @Produces(value={"application/json"})
    public SecurityCheckResponse fileRead(@QueryParam(value="fileName") String name) {
        String axis2FilePath = CarbonUtils.getAxis2Xml();
        String confDir = axis2FilePath.substring(0, axis2FilePath.lastIndexOf("/"));
        confDir = confDir.substring(0, confDir.lastIndexOf("/"));
        String repositoryDir = confDir.substring(0, confDir.lastIndexOf("/"));
        String serverHomeDir = repositoryDir.substring(0, repositoryDir.lastIndexOf("/"));
        String output = "";
        try {
            BufferedReader br = new BufferedReader(new FileReader(serverHomeDir + "/" + name));
            try {
                StringBuilder sb = new StringBuilder();
                String line = br.readLine();
                while (line != null) {
                    sb.append(line);
                    sb.append("\n");
                    line = br.readLine();
                }
                output = sb.toString();
            }
            finally {
                br.close();
            }
        }
        catch (Exception e) {
            output = "Error occurred while reading file. Reason: " + e.getMessage();
            logger.error((Object)output, (Throwable)e);
        }
        SecurityCheckResponse c = new SecurityCheckResponse();
        c.setResponseMessage(output);
        return c;
    }

    @GET
    @Path(value="/axis2FilePath")
    @Produces(value={"application/json"})
    public SecurityCheckResponse filePath() {
        String output = "";
        try {
            output = CarbonUtils.getAxis2Xml();
        }
        catch (Exception e) {
            output = "Error occurred while reading axis2 file path. Reason: " + e.getMessage();
            logger.error((Object)output, (Throwable)e);
        }
        SecurityCheckResponse c = new SecurityCheckResponse();
        c.setResponseMessage(output);
        return c;
    }

    @POST
    @Path(value="/fileCopy")
    @Produces(value={"application/json"})
    public SecurityCheckResponse fileCopy(@QueryParam(value="source") String source, @QueryParam(value="destination") String destination) {
        String output = "";
        try {
            Utils.copyDirectory((File)new File(source), (File)new File(destination));
            output = "File copied successfully";
        }
        catch (Exception e) {
            output = "Error occurred while copying file. Reason: " + e.getMessage();
            logger.error((Object)output, (Throwable)e);
        }
        SecurityCheckResponse r = new SecurityCheckResponse();
        r.setResponseMessage(output);
        return r;
    }

    @POST
    @Path(value="/fileDelete")
    @Produces(value={"application/json"})
    public SecurityCheckResponse fileDeleteCarbon(@QueryParam(value="path") String path) {
        String output = "";
        try {
            if (Utils.deleteDir((File)new File(path))) {
                output = "File Deleted successfully";
            }
        }
        catch (Exception e) {
            output = "Error occurred when deleting file. Reason: " + e.getMessage();
            logger.error((Object)output, (Throwable)e);
        }
        SecurityCheckResponse r = new SecurityCheckResponse();
        r.setResponseMessage(output);
        return r;
    }

    @GET
    @Path(value="/registryDBConfig")
    @Produces(value={"application/json"})
    public SecurityCheckResponse getRegistryDBConfig(@QueryParam(value="path") String path) {
        String output = "";
        try {
            output = DBUtils.getRegistryDBConfig();
        }
        catch (Exception e) {
            output = "Error occurred when reading registry DB config. Reason: " + e.getMessage();
            logger.error((Object)output, (Throwable)e);
        }
        SecurityCheckResponse r = new SecurityCheckResponse();
        r.setResponseMessage(output);
        return r;
    }

    @GET
    @Path(value="/userManagerDBConfig")
    @Produces(value={"application/json"})
    public SecurityCheckResponse getUserManagerDBConfig(@QueryParam(value="path") String path) {
        String output = "";
        try {
            output = DBUtils.getUserManagerDBConfig();
        }
        catch (Exception e) {
            output = "Error occurred when reading user manager DB config. Reason: " + e.getMessage();
            logger.error((Object)output, (Throwable)e);
        }
        SecurityCheckResponse r = new SecurityCheckResponse();
        r.setResponseMessage(output);
        return r;
    }

    @GET
    @Path(value="/networkConfigs")
    @Produces(value={"application/json"})
    public SecurityCheckResponse getNetworkConfigs() {
        String output = "";
        try {
            output = "Local Host Name:" + NetworkUtils.getLocalHostname() + " , Mgt Host Name" + NetworkUtils.getMgtHostName();
        }
        catch (Exception e) {
            output = "Error occurred when reading network config. Reason: " + e.getMessage();
            logger.error((Object)output, (Throwable)e);
        }
        SecurityCheckResponse r = new SecurityCheckResponse();
        r.setResponseMessage(output);
        return r;
    }

    @POST
    @Path(value="/networkConfigs")
    @Produces(value={"application/json"})
    public SecurityCheckResponse initNetwork(@QueryParam(value="hostName") String hostName, @QueryParam(value="mgtHostName") String mgtHostName) {
        String output = "";
        try {
            NetworkUtils.init((String)hostName, (String)mgtHostName);
            output = "Initialized network successfully";
        }
        catch (IOException e) {
            output = "Error occurred when initializing network config. Reason: " + e.getMessage();
            logger.error((Object)output, (Throwable)e);
        }
        SecurityCheckResponse r = new SecurityCheckResponse();
        r.setResponseMessage(output);
        return r;
    }

    @POST
    @Path(value="/memory")
    @Produces(value={"application/json"})
    public SecurityCheckResponse checkMemory(@QueryParam(value="operation") String operation) {
        if (operation != null && operation.equalsIgnoreCase("oom")) {
            try {
                SecurityCheckService.generateOOM();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (operation != null && operation.equalsIgnoreCase("kill")) {
            System.exit(0);
        }
        if (operation != null && operation.equalsIgnoreCase("cpu")) {
            this.generateLoad();
        }
        SecurityCheckResponse r = new SecurityCheckResponse();
        r.setResponseMessage("done");
        return r;
    }

    public static void generateOOM() throws Exception {
        int iteratorValue = 20;
        System.out.println("\n=================> OOM test started..\n");
        for (int outerIterator = 1; outerIterator < 20; ++outerIterator) {
            System.out.println("Iteration " + outerIterator + " Free Mem: " + Runtime.getRuntime().freeMemory());
            int loop1 = 2;
            int[] memoryFillIntVar = new int[iteratorValue];
            do {
                memoryFillIntVar[loop1] = 0;
            } while (--loop1 > 0);
            System.out.println("\nRequired Memory for next loop: " + (iteratorValue *= 5));
            Thread.sleep(1000L);
        }
    }

    public void generateLoad() {
        for (int i = 0; i < 100; ++i) {
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        }
    }

    @GET
    @Path(value="/serverConfiguration")
    @Produces(value={"application/json"})
    public SecurityCheckResponse getServerConfiguration() {
        String output = "";
        try {
            ServerConfiguration.getInstance();
            output = "ServerConfiguration.getInstance() can be called";
        }
        catch (Exception e) {
            output = "Error occurred while calling ServerConfiguration.getInstance(). Reason: " + e.toString();
            logger.error((Object)output, (Throwable)e);
        }
        SecurityCheckResponse c = new SecurityCheckResponse();
        c.setResponseMessage(output);
        return c;
    }
}

