/*
 * Decompiled with CFR 0.152.
 */
package demo.wssec.client;

import java.io.File;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.util.HashMap;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.hello_world_soap_http.Greeter;
import org.apache.cxf.hello_world_soap_http.GreeterService;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;

public final class Client {
    private static final String USER_NAME = System.getProperty("user.name");
    private static final String WSU_NS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";

    private Client() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        try {
            SpringBusFactory bf = new SpringBusFactory();
            URL busFile = Client.class.getResource("wssec.xml");
            Bus bus = bf.createBus(busFile.toString());
            BusFactory.setDefaultBus((Bus)bus);
            HashMap<String, String> outProps = new HashMap<String, String>();
            outProps.put("action", "UsernameToken Timestamp Signature Encrypt");
            outProps.put("passwordType", "PasswordDigest");
            outProps.put("user", "clientx509v1");
            outProps.put("passwordCallbackClass", "demo.wssec.client.UTPasswordCallback");
            outProps.put("encryptionUser", "serverx509v1");
            outProps.put("encryptionPropFile", "etc/Client_Encrypt.properties");
            outProps.put("encryptionKeyIdentifier", "IssuerSerial");
            outProps.put("encryptionParts", "{Element}{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp;{Content}{http://schemas.xmlsoap.org/soap/envelope/}Body");
            outProps.put("signaturePropFile", "etc/Client_Sign.properties");
            outProps.put("signatureKeyIdentifier", "DirectReference");
            outProps.put("signatureParts", "{Element}{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp;{Element}{http://schemas.xmlsoap.org/soap/envelope/}Body");
            bus.getOutInterceptors().add(new WSS4JOutInterceptor(outProps));
            HashMap<String, String> inProps = new HashMap<String, String>();
            inProps.put("action", "UsernameToken Timestamp Signature Encrypt");
            inProps.put("passwordType", "PasswordText");
            inProps.put("passwordCallbackClass", "demo.wssec.client.UTPasswordCallback");
            inProps.put("decryptionPropFile", "etc/Client_Sign.properties");
            inProps.put("encryptionKeyIdentifier", "IssuerSerial");
            inProps.put("signaturePropFile", "etc/Client_Encrypt.properties");
            inProps.put("signatureKeyIdentifier", "DirectReference");
            bus.getInInterceptors().add(new WSS4JInInterceptor(inProps));
            GreeterService service = null;
            if (args.length != 0 && args[0].length() != 0) {
                File wsdlFile = new File(args[0]);
                URL wsdlURL = wsdlFile.exists() ? wsdlFile.toURL() : new URL(args[0]);
                service = new GreeterService(wsdlURL);
            } else {
                service = new GreeterService();
            }
            Greeter port = service.getGreeterPort();
            String[] names = new String[]{"Anne", "Bill", "Chris", "Sachin Tendulkar"};
            for (int i = 0; i < 4; ++i) {
                System.out.println("Invoking greetMe...");
                String response = port.greetMe(names[i]);
                System.out.println("response: " + response + "\n");
            }
            Thread.sleep(30000L);
            bus.shutdown(true);
        }
        catch (UndeclaredThrowableException ex) {
            ex.getUndeclaredThrowable().printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            System.exit(0);
        }
    }
}

