/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.integration.common.artifacts.spring3.restful.webapp.classloading.controller;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.wso2.appserver.integration.common.artifacts.spring3.restful.webapp.classloading.model.Status;
import org.wso2.appserver.integration.common.artifacts.spring3.restful.webapp.classloading.model.Student;

@Controller
@RequestMapping(value={"/student"})
public class StudentController {
    private static final Log log = LogFactory.getLog(StudentController.class);
    private static final long deployedTime = System.currentTimeMillis();
    @Autowired
    @Qualifier(value="dbStudent")
    private DataSource dataSource;

    @RequestMapping(method={RequestMethod.GET}, value={"/deployedtime"})
    @ResponseBody
    public String getDeployedtime() {
        return "{\"deployedTime\":\"" + Objects.toString(deployedTime, "") + "\"}";
    }

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public List<Student> getallStudent() {
        log.info((Object)"Retrieve all Student info");
        ArrayList<Student> students = new ArrayList<Student>();
        String query = "SELECT id, first_name, last_name, age from student";
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        List studentRows = jdbcTemplate.queryForList(query);
        for (Map studentRow : studentRows) {
            Student student = new Student();
            student.setId(Integer.parseInt(String.valueOf(studentRow.get("id"))));
            student.setFirstName(String.valueOf(studentRow.get("first_name")));
            student.setLastName(String.valueOf(studentRow.get("last_name")));
            student.setAge(Integer.parseInt(String.valueOf(studentRow.get("age"))));
            students.add(student);
        }
        return students;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    @ResponseBody
    public Student getStudent(@PathVariable(value="id") int id) {
        log.info((Object)"Retrieve Student Info");
        Student student = new Student();
        String query = "SELECT id, first_name, last_name, age FROM student WHERE id = ?";
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.prepareStatement(query);
            statement.setInt(1, id);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                student.setId(resultSet.getInt("id"));
                student.setFirstName(resultSet.getString("first_name"));
                student.setLastName(resultSet.getString("last_name"));
                student.setAge(resultSet.getInt("age"));
            }
        }
        catch (SQLException e) {
            log.error((Object)"Error retrieving Student Info");
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"Closing Connection");
            }
        }
        return student;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.PUT})
    @ResponseBody
    public Status insertStudent(@RequestBody Student student) {
        log.info((Object)"Insert Student Info");
        Status status = new Status();
        String query = "INSERT INTO student (id, first_name, last_name, age) VALUES (?, ?, ?, ?)";
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.prepareStatement(query);
            statement.setInt(1, student.getId());
            statement.setString(2, student.getFirstName());
            statement.setString(3, student.getLastName());
            statement.setInt(4, student.getAge());
            statement.execute();
            status.setStatus(true);
        }
        catch (SQLException e) {
            log.error((Object)"Error in inserting Student Info");
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"Closing Connection");
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public Status updateStudent(@RequestBody Student student) {
        log.info((Object)"Update Student Info");
        Status status = new Status();
        String query = "UPDATE student SET first_name = ?, last_name = ?, age = ? WHERE id = ?";
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.prepareStatement(query);
            statement.setString(1, student.getFirstName());
            statement.setString(2, student.getLastName());
            statement.setInt(3, student.getAge());
            statement.setInt(4, student.getId());
            statement.executeUpdate();
            status.setStatus(true);
        }
        catch (SQLException e) {
            log.error((Object)"Error in updating Student Info");
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"Closing Connection");
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    @ResponseBody
    public Status deleteStudent(@PathVariable(value="id") int id) {
        log.info((Object)"Deleting Student Info");
        Status status = new Status();
        String query = "DELETE FROM student WHERE id = ?";
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.prepareStatement(query);
            statement.setInt(1, id);
            statement.executeUpdate();
            status.setStatus(true);
        }
        catch (SQLException e) {
            log.error((Object)"Error in deleting student");
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"Closing Connection");
            }
        }
        return status;
    }
}

