/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.integration.common.ui.page.main;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.wso2.appserver.integration.common.ui.page.util.UIElementMapper;

public class WebAppUploadingPage {
    private static final Log log = LogFactory.getLog(WebAppUploadingPage.class);
    private WebDriver driver;

    public WebAppUploadingPage(WebDriver driver) throws IOException {
        this.driver = driver;
        UIElementMapper uiElementMapper = UIElementMapper.getInstance();
        driver.findElement(By.xpath((String)uiElementMapper.getElement("webapp.add.xpath"))).click();
        if (!driver.findElement(By.id((String)uiElementMapper.getElement("webapp.list.page.middle"))).getText().contains("Upload Web Applications")) {
            throw new IllegalStateException("This is not the upload web application page Page");
        }
    }

    public boolean uploadWebApp(String filePath) {
        this.driver.findElement(By.xpath((String)"//*[@id=\"webappTbl\"]/tbody/tr/td[2]/input[1]")).sendKeys(new CharSequence[]{filePath});
        this.driver.findElement(By.xpath((String)"//*[@id=\"workArea\"]/form/table[2]/tbody/tr/td/input[1]")).click();
        String responseMessage = this.driver.findElement(By.id((String)"dialog")).getText();
        log.info((Object)responseMessage);
        this.driver.findElement(By.xpath((String)"/html/body/div[3]/div[2]/button")).click();
        return "Web application has been uploaded successfully. Please refresh this page in a while to see the status of the running webapps.".equalsIgnoreCase(responseMessage);
    }
}

