/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.configuration.listeners;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.wso2.appserver.exceptions.ApplicationServerConfigurationException;
import org.xml.sax.SAXException;

public class Utils {
    public static Unmarshaller getXMLUnmarshaller(Path schemaPath, Class ... classes) throws ApplicationServerConfigurationException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])classes);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            if (!Files.exists(schemaPath, new LinkOption[0])) {
                throw new ApplicationServerConfigurationException("Configuration schema not found in the file path: " + schemaPath.toString());
            }
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema xmlSchema = schemaFactory.newSchema(schemaPath.toFile());
            unmarshaller.setSchema(xmlSchema);
            return unmarshaller;
        }
        catch (JAXBException | SAXException e) {
            throw new ApplicationServerConfigurationException("Error when creating the XML unmarshaller", e);
        }
    }

    public static <T> T getUnmarshalledObject(Path source, Path schema, Class<T> bindingClass) throws ApplicationServerConfigurationException {
        try {
            Unmarshaller unmarshaller = Utils.getXMLUnmarshaller(schema, bindingClass);
            Object unmarshalled = unmarshaller.unmarshal(source.toFile());
            return bindingClass.cast(unmarshalled);
        }
        catch (JAXBException e) {
            throw new ApplicationServerConfigurationException("Error when unmarshalling the XML configuration", e);
        }
    }
}

