/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.monitoring.utils;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpSession;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.commons.lang3.StringUtils;
import org.wso2.appserver.monitoring.exceptions.StatPublisherException;
import org.wso2.carbon.databridge.commons.Event;

public class EventBuilder {
    private static Map<String, String> arbitraryData;

    public static Event buildEvent(String streamId, Request request, Response response, long startTime, long responseTime) throws StatPublisherException {
        List<Object> payload = EventBuilder.buildPayloadData(request, response, startTime, responseTime);
        return new Event(streamId, startTime, new ArrayList<String>(Arrays.asList(request.getServerName(), request.getLocalName())).toArray(), null, payload.toArray(), EventBuilder.getArbitraryData());
    }

    private static Map<String, String> getArbitraryData() {
        if (arbitraryData == null) {
            EventBuilder.readArbitraryData("WSO2_");
        }
        return arbitraryData;
    }

    private static void readArbitraryData(String prefix) {
        arbitraryData = System.getenv().entrySet().stream().filter(varName -> ((String)varName.getKey()).startsWith(prefix)).collect(Collectors.toMap(varName -> (String)varName.getKey(), varName -> (String)varName.getValue()));
    }

    private static List<Object> buildPayloadData(Request request, Response response, long startTime, long responseTime) {
        ArrayList<Object> payload = new ArrayList<Object>();
        String forwardSlash = "/";
        Optional.ofNullable(request.getRequestURI()).map(String::trim).ifPresent(requestedURI -> {
            String[] requestedUriParts = requestedURI.split("/");
            if (!"/".equals(requestedURI)) {
                payload.add(requestedUriParts[1]);
            } else {
                payload.add("/");
            }
        });
        String webappServletVersion = request.getContext().getEffectiveMajorVersion() + "." + request.getContext().getEffectiveMinorVersion();
        payload.add(webappServletVersion);
        payload.add(EventBuilder.extractUsername(request));
        payload.add(request.getRequestURI());
        payload.add(startTime);
        payload.add(request.getPathInfo());
        payload.add("webapp");
        payload.add(request.getContext().getDisplayName());
        payload.add(EventBuilder.extractSessionId(request));
        payload.add(request.getMethod());
        payload.add(request.getContentType());
        payload.add(response.getContentType());
        payload.add(Long.valueOf(response.getStatus()));
        payload.add(EventBuilder.getClientIpAddress(request));
        payload.add(request.getHeader("Referer"));
        payload.add(request.getHeader("User-Agent"));
        payload.add(request.getHeader("Host"));
        payload.add(request.getRemoteUser());
        payload.add(request.getAuthType());
        payload.add(responseTime);
        payload.add(Long.valueOf(request.getContentLength()));
        payload.add(Long.valueOf(response.getContentLength()));
        payload.add(EventBuilder.getRequestHeaders(request));
        payload.add(EventBuilder.getResponseHeaders(response));
        payload.add(request.getLocale().getLanguage());
        return payload;
    }

    private static String getRequestHeaders(Request request) {
        ArrayList requestHeaders = new ArrayList();
        Collections.list(request.getHeaderNames()).forEach(header -> {
            ArrayList<String> values = new ArrayList<String>();
            values.add(request.getHeader(header));
            String tmpString = "(" + StringUtils.join(values, ",") + ")";
            requestHeaders.add(header + ":" + tmpString);
        });
        return StringUtils.join(requestHeaders, ";");
    }

    private static String getResponseHeaders(Response response) {
        ArrayList responseHeaders = new ArrayList();
        response.getHeaderNames().forEach(header -> {
            ArrayList<String> values = new ArrayList<String>();
            values.add(response.getHeader(header));
            String tmpString = "(" + StringUtils.join(values, ",") + ")";
            responseHeaders.add(header + ":" + tmpString);
        });
        return StringUtils.join(responseHeaders, ",");
    }

    private static String extractSessionId(Request request) {
        HttpSession session = request.getSession(false);
        return session != null && session.getId() != null ? session.getId() : "-";
    }

    private static String extractUsername(Request request) {
        Principal principal = request.getUserPrincipal();
        String consumerName = principal != null ? principal.getName() : "anonymous.user";
        return consumerName;
    }

    private static String getClientIpAddress(Request request) {
        List<String> headers = Arrays.asList("X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR");
        Iterator<String> iterator = headers.iterator();
        if (iterator.hasNext()) {
            String header = iterator.next();
            String ip = request.getHeader(header);
            if (ip != null && ip.length() != 0 && !"unknown".equalsIgnoreCase(ip)) {
                return ip;
            }
            return request.getRemoteAddr();
        }
        return request.getRemoteAddr();
    }
}

