/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.configuration.listeners;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.wso2.appserver.configuration.context.AppServerWebAppConfiguration;
import org.wso2.appserver.configuration.listeners.Utils;
import org.wso2.appserver.exceptions.ApplicationServerException;
import org.wso2.appserver.exceptions.ApplicationServerRuntimeException;
import org.wso2.appserver.utils.PathUtils;

public class ContextConfigurationLoader
implements LifecycleListener {
    private static final Map<Context, AppServerWebAppConfiguration> contextToConfigurationMap = new ConcurrentHashMap<Context, AppServerWebAppConfiguration>();

    public static Optional<AppServerWebAppConfiguration> getContextConfiguration(Context context) {
        AppServerWebAppConfiguration configuration = contextToConfigurationMap.get(context);
        return Optional.ofNullable(configuration);
    }

    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        Object source;
        if ("before_start".equals(lifecycleEvent.getType())) {
            Object source2 = lifecycleEvent.getSource();
            if (source2 instanceof Context) {
                Context context = (Context)source2;
                AppServerWebAppConfiguration effectiveConfiguration = ContextConfigurationLoader.getEffectiveConfiguration(context);
                contextToConfigurationMap.put(context, effectiveConfiguration);
            }
        } else if ("after_stop".equals(lifecycleEvent.getType()) && (source = lifecycleEvent.getSource()) instanceof Context) {
            Context context = (Context)source;
            contextToConfigurationMap.remove(context);
        }
    }

    private static AppServerWebAppConfiguration getEffectiveConfiguration(Context context) {
        if (context != null) {
            AppServerWebAppConfiguration effective;
            Path schemaPath = Paths.get(PathUtils.getAppServerConfigurationBase().toString(), "wso2as-web.xsd");
            Path defaultWebAppDescriptor = Paths.get(PathUtils.getAppServerConfigurationBase().toString(), "wso2as-web.xml");
            try {
                Path localWebAppDescriptor = Paths.get(PathUtils.getWebAppPath(context).toString(), "WEB-INF", "wso2as-web.xml");
                if (!Files.exists(defaultWebAppDescriptor, new LinkOption[0])) {
                    throw new ApplicationServerRuntimeException("The " + defaultWebAppDescriptor.toString() + " does not exist");
                }
                effective = Utils.getUnmarshalledObject(defaultWebAppDescriptor, schemaPath, AppServerWebAppConfiguration.class);
                if (Files.exists(localWebAppDescriptor, new LinkOption[0])) {
                    AppServerWebAppConfiguration local = Utils.getUnmarshalledObject(localWebAppDescriptor, schemaPath, AppServerWebAppConfiguration.class);
                    effective.merge(local);
                }
            }
            catch (ApplicationServerException e) {
                throw new ApplicationServerRuntimeException("Error when loading the context level configuration", e);
            }
            return effective;
        }
        throw new ApplicationServerRuntimeException("Context cannot be null");
    }
}

