/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.configuration.server;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.wso2.appserver.configuration.server.ClassLoaderEnvironments;
import org.wso2.appserver.configuration.server.SSOConfiguration;
import org.wso2.appserver.configuration.server.SecurityConfiguration;
import org.wso2.appserver.configuration.server.StatsPublisherConfiguration;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="AppServer")
public class AppServerConfiguration {
    @XmlElement(name="ClassLoader")
    private ClassLoaderEnvironments classLoaderEnvironments;
    @XmlElement(name="SAML2SingleSignOn")
    private SSOConfiguration singleSignOnConfiguration;
    @XmlElement(name="StatisticsPublisher")
    private StatsPublisherConfiguration statsPublisherConfiguration;
    @XmlElement(name="Security")
    private SecurityConfiguration securityConfiguration;

    public ClassLoaderEnvironments getClassLoaderEnvironments() {
        return this.classLoaderEnvironments;
    }

    public void setClassLoaderEnvironments(ClassLoaderEnvironments classLoaderEnvironments) {
        this.classLoaderEnvironments = classLoaderEnvironments;
    }

    public SSOConfiguration getSingleSignOnConfiguration() {
        return this.singleSignOnConfiguration;
    }

    public void setSingleSignOnConfiguration(SSOConfiguration singleSignOnConfiguration) {
        this.singleSignOnConfiguration = singleSignOnConfiguration;
    }

    public StatsPublisherConfiguration getStatsPublisherConfiguration() {
        return this.statsPublisherConfiguration;
    }

    public void setStatsPublisherConfiguration(StatsPublisherConfiguration statsPublisherConfiguration) {
        this.statsPublisherConfiguration = statsPublisherConfiguration;
    }

    public SecurityConfiguration getSecurityConfiguration() {
        return this.securityConfiguration;
    }

    public void setSecurityConfiguration(SecurityConfiguration securityConfiguration) {
        this.securityConfiguration = securityConfiguration;
    }

    public void resolveVariables() {
        this.resolveEnvVariables();
        this.resolveSystemProperties();
    }

    private void resolveEnvVariables() {
        StrSubstitutor strSubstitutor = new StrSubstitutor(System.getenv());
        this.classLoaderEnvironments.getEnvironments().getEnvironments().forEach(environment -> environment.setClasspath(strSubstitutor.replace(environment.getClasspath())));
        this.securityConfiguration.getKeystore().setLocation(strSubstitutor.replace(this.securityConfiguration.getKeystore().getLocation()));
        this.securityConfiguration.getTruststore().setLocation(strSubstitutor.replace(this.securityConfiguration.getTruststore().getLocation()));
    }

    private void resolveSystemProperties() {
        this.classLoaderEnvironments.getEnvironments().getEnvironments().forEach(environment -> environment.setClasspath(StrSubstitutor.replaceSystemProperties((Object)environment.getClasspath())));
        this.securityConfiguration.getKeystore().setLocation(StrSubstitutor.replaceSystemProperties((Object)this.securityConfiguration.getKeystore().getLocation()));
        this.securityConfiguration.getTruststore().setLocation(StrSubstitutor.replaceSystemProperties((Object)this.securityConfiguration.getTruststore().getLocation()));
    }
}

