/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.commons;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.utils.IndexDefinitionConverterUtils;

public class IndexDefinition {
    private static final String STREAM_VERSION_KEY = "Version";
    private static final String STREAM_TIMESTAMP_KEY = "Timestamp";
    private List<Attribute> secondaryIndexData;
    private List<Attribute> customIndexData;
    private List<Attribute> fixedSearchData;
    private List<Attribute> arbitraryIndexData;
    private Map<String, Attribute> metaCustomIndex;
    private Map<String, Attribute> payloadCustomIndex;
    private Map<String, Attribute> correlationCustomIndex;
    private Map<String, Attribute> generalCustomIndex;
    private Map<String, Attribute> fixedPropertiesMap;
    private Map<String, Attribute> arbitraryIndex;
    private Set<String> metaFixProps;
    private Set<String> payloadFixProps;
    private Set<String> correlationFixProps;
    private Set<String> generalFixProps;
    private boolean isIndexTimestamp;
    private boolean isIncrementalIndex;

    public void setIndexData(String indexDefnStr, StreamDefinition streamDefinition) {
        if (indexDefnStr == null) {
            return;
        }
        String secondaryIndex = IndexDefinitionConverterUtils.getSecondaryIndexString(indexDefnStr);
        String customIndex = IndexDefinitionConverterUtils.getCustomIndexString(indexDefnStr);
        String fixedIndex = IndexDefinitionConverterUtils.getFixedIndexString(indexDefnStr);
        String increIndex = IndexDefinitionConverterUtils.getIncrementalIndexString(indexDefnStr);
        String arbitraryIndex = IndexDefinitionConverterUtils.getArbitraryIndexString(indexDefnStr);
        HashSet<String> secIndexSet = new HashSet<String>();
        HashSet<String> custIndexSet = new HashSet<String>();
        HashSet<String> fixedPropertiesList = new HashSet<String>();
        HashSet<String> arbitraryIndexList = new HashSet<String>();
        this.isIncrementalIndex = false;
        if (secondaryIndex != null && !secondaryIndex.trim().isEmpty()) {
            secIndexSet.addAll(Arrays.asList(secondaryIndex.split(",")));
        }
        if (customIndex != null && !customIndex.trim().isEmpty()) {
            custIndexSet.addAll(Arrays.asList(customIndex.split(",")));
        }
        if (fixedIndex != null && !fixedIndex.trim().isEmpty()) {
            fixedPropertiesList.addAll(Arrays.asList(fixedIndex.split(",")));
        }
        if (increIndex != null && !increIndex.trim().isEmpty()) {
            this.isIncrementalIndex = Boolean.parseBoolean(increIndex);
        }
        if (arbitraryIndex != null && !arbitraryIndex.isEmpty()) {
            arbitraryIndexList.addAll(Arrays.asList(arbitraryIndex.split(",")));
        }
        HashMap<String, Attribute> tempFixProperties = null;
        if (secIndexSet.size() > 0) {
            this.secondaryIndexData = new ArrayList<Attribute>(secIndexSet.size());
        }
        if (custIndexSet.size() > 0) {
            this.customIndexData = new ArrayList<Attribute>(custIndexSet.size());
        }
        if (fixedPropertiesList.size() > 0) {
            this.fixedSearchData = new ArrayList<Attribute>(fixedPropertiesList.size());
            tempFixProperties = new HashMap<String, Attribute>(fixedPropertiesList.size());
        }
        if (streamDefinition.getMetaData() != null) {
            for (Attribute attribute : streamDefinition.getMetaData()) {
                if (secIndexSet.contains(attribute.getName())) {
                    this.secondaryIndexData.add(new Attribute("meta_" + attribute.getName(), attribute.getType()));
                }
                if (custIndexSet.contains(attribute.getName())) {
                    this.customIndexData.add(new Attribute("meta_" + attribute.getName(), attribute.getType()));
                    custIndexSet.remove(attribute.getName());
                }
                if (!fixedPropertiesList.contains(attribute.getName())) continue;
                tempFixProperties.put(attribute.getName(), new Attribute("meta_" + attribute.getName(), attribute.getType()));
            }
        }
        if (streamDefinition.getCorrelationData() != null) {
            for (Attribute attribute : streamDefinition.getCorrelationData()) {
                if (secIndexSet.contains(attribute.getName())) {
                    this.secondaryIndexData.add(new Attribute("correlation_" + attribute.getName(), attribute.getType()));
                }
                if (custIndexSet.contains(attribute.getName())) {
                    this.customIndexData.add(new Attribute("correlation_" + attribute.getName(), attribute.getType()));
                    custIndexSet.remove(attribute.getName());
                }
                if (!fixedPropertiesList.contains(attribute.getName())) continue;
                tempFixProperties.put(attribute.getName(), new Attribute("correlation_" + attribute.getName(), attribute.getType()));
            }
        }
        if (streamDefinition.getPayloadData() != null) {
            for (Attribute attribute : streamDefinition.getPayloadData()) {
                if (secIndexSet.contains(attribute.getName())) {
                    this.secondaryIndexData.add(new Attribute("payload_" + attribute.getName(), attribute.getType()));
                }
                if (custIndexSet.contains(attribute.getName())) {
                    this.customIndexData.add(new Attribute("payload_" + attribute.getName(), attribute.getType()));
                    custIndexSet.remove(attribute.getName());
                }
                if (!fixedPropertiesList.contains(attribute.getName())) continue;
                tempFixProperties.put(attribute.getName(), new Attribute("payload_" + attribute.getName(), attribute.getType()));
            }
        }
        if (custIndexSet.contains(STREAM_TIMESTAMP_KEY)) {
            this.customIndexData.add(new Attribute(STREAM_TIMESTAMP_KEY, AttributeType.LONG));
            custIndexSet.remove(STREAM_TIMESTAMP_KEY);
        }
        for (String generalIndex : custIndexSet) {
            if (generalIndex.trim().equals("")) continue;
            this.customIndexData.add(new Attribute(generalIndex, AttributeType.STRING));
        }
        if (arbitraryIndexList != null) {
            this.arbitraryIndexData = new ArrayList<Attribute>(arbitraryIndexList.size());
            for (String arbitraryIndexField : arbitraryIndexList) {
                String[] data = arbitraryIndexField.split(":");
                AttributeType attributeType = null;
                try {
                    attributeType = AttributeType.valueOf(data[1].trim());
                }
                catch (Exception e) {
                    attributeType = AttributeType.STRING;
                }
                this.arbitraryIndexData.add(new Attribute(data[0], attributeType));
            }
        }
        for (String property : fixedPropertiesList) {
            if (!property.equalsIgnoreCase(STREAM_VERSION_KEY)) {
                if (tempFixProperties.get(property) == null) continue;
                this.fixedSearchData.add((Attribute)tempFixProperties.get(property));
                continue;
            }
            this.fixedSearchData.add(new Attribute(STREAM_VERSION_KEY, AttributeType.STRING));
        }
    }

    public void setIndexDataFromStore(String indexDefnStr) {
        Attribute attribute;
        AttributeType attributeType;
        String name;
        String[] custIndexData;
        if (indexDefnStr == null) {
            return;
        }
        List<Object> secIndexList = new ArrayList();
        List<Object> custIndexList = new ArrayList();
        List<Object> fixedSearchProps = new ArrayList();
        List<Object> arbitraryIndexList = new ArrayList();
        String secondaryIndex = IndexDefinitionConverterUtils.getSecondaryIndexString(indexDefnStr);
        String customIndex = IndexDefinitionConverterUtils.getCustomIndexString(indexDefnStr);
        String fixedIndex = IndexDefinitionConverterUtils.getFixedIndexString(indexDefnStr);
        String increIndex = IndexDefinitionConverterUtils.getIncrementalIndexString(indexDefnStr);
        String arbitraryIndexStr = IndexDefinitionConverterUtils.getArbitraryIndexString(indexDefnStr);
        if (secondaryIndex != null && !secondaryIndex.trim().isEmpty()) {
            secIndexList = Arrays.asList(secondaryIndex.split(","));
        }
        if (customIndex != null && !customIndex.trim().isEmpty()) {
            custIndexList = Arrays.asList(customIndex.split(","));
        }
        if (fixedIndex != null && !fixedIndex.trim().isEmpty()) {
            fixedSearchProps = Arrays.asList(fixedIndex.split(","));
        }
        if (increIndex != null && !increIndex.trim().isEmpty()) {
            this.isIncrementalIndex = Boolean.parseBoolean(increIndex);
        }
        if (arbitraryIndexStr != null && !arbitraryIndexStr.isEmpty()) {
            arbitraryIndexList = Arrays.asList(arbitraryIndexStr.split(","));
        }
        if (secIndexList != null) {
            this.secondaryIndexData = new ArrayList<Attribute>(secIndexList.size());
            for (String string : secIndexList) {
                String[] secIndexData = string.split(":");
                this.secondaryIndexData.add(new Attribute(secIndexData[0], AttributeType.valueOf(secIndexData[1].trim())));
            }
        }
        if (custIndexList != null) {
            this.customIndexData = new ArrayList<Attribute>(custIndexList.size());
            for (String string : custIndexList) {
                custIndexData = string.split(":");
                name = custIndexData[0];
                attributeType = AttributeType.valueOf(custIndexData[1].trim());
                this.customIndexData.add(new Attribute(name, attributeType));
                String attributeName = name.substring(name.indexOf("_") + 1);
                if (name.startsWith("meta_")) {
                    if (this.metaCustomIndex == null) {
                        this.metaCustomIndex = new HashMap<String, Attribute>();
                    }
                    this.metaCustomIndex.put(attributeName, new Attribute(attributeName, attributeType));
                    continue;
                }
                if (name.startsWith("correlation_")) {
                    if (this.correlationCustomIndex == null) {
                        this.correlationCustomIndex = new HashMap<String, Attribute>();
                    }
                    this.correlationCustomIndex.put(attributeName, new Attribute(attributeName, attributeType));
                    continue;
                }
                if (name.startsWith("payload_")) {
                    if (this.payloadCustomIndex == null) {
                        this.payloadCustomIndex = new HashMap<String, Attribute>();
                    }
                    this.payloadCustomIndex.put(attributeName, new Attribute(attributeName, attributeType));
                    continue;
                }
                if (this.generalCustomIndex == null) {
                    this.generalCustomIndex = new HashMap<String, Attribute>();
                }
                this.generalCustomIndex.put(name, new Attribute(name, attributeType));
                if (!attributeName.equals(STREAM_TIMESTAMP_KEY)) continue;
                this.isIndexTimestamp = true;
            }
        }
        if (custIndexList != null) {
            this.fixedSearchData = new ArrayList<Attribute>(fixedSearchProps.size());
            this.fixedPropertiesMap = new LinkedHashMap<String, Attribute>();
            for (String string : fixedSearchProps) {
                if (string.isEmpty()) continue;
                String[] fixedPropertyData = string.split(":");
                name = fixedPropertyData[0];
                attributeType = AttributeType.valueOf(fixedPropertyData[1].trim());
                attribute = new Attribute(name, attributeType);
                this.fixedSearchData.add(attribute);
                String attributeName = name.substring(name.indexOf("_") + 1);
                this.fixedPropertiesMap.put(attributeName, attribute);
                if (name.startsWith("meta_")) {
                    if (this.metaFixProps == null) {
                        this.metaFixProps = new LinkedHashSet<String>();
                    }
                    this.metaFixProps.add(attributeName);
                    continue;
                }
                if (name.startsWith("correlation_")) {
                    if (this.correlationFixProps == null) {
                        this.correlationFixProps = new LinkedHashSet<String>();
                    }
                    this.correlationFixProps.add(attributeName);
                    continue;
                }
                if (name.startsWith("payload_")) {
                    if (this.payloadFixProps == null) {
                        this.payloadFixProps = new LinkedHashSet<String>();
                    }
                    this.payloadFixProps.add(attributeName);
                    continue;
                }
                if (this.generalFixProps == null) {
                    this.generalFixProps = new LinkedHashSet<String>();
                }
                this.generalFixProps.add(name);
            }
        }
        if (arbitraryIndexList != null) {
            this.arbitraryIndexData = new ArrayList<Attribute>(arbitraryIndexList.size());
            for (String string : arbitraryIndexList) {
                custIndexData = arbitraryIndexStr.split(":");
                name = custIndexData[0];
                attributeType = AttributeType.valueOf(custIndexData[1].trim().split(",")[0]);
                attribute = new Attribute(name, attributeType);
                this.arbitraryIndexData.add(attribute);
                if (this.arbitraryIndex == null) {
                    this.arbitraryIndex = new HashMap<String, Attribute>();
                }
                this.arbitraryIndex.put(name, attribute);
            }
        }
    }

    public List<Attribute> getSecondaryIndexData() {
        return this.secondaryIndexData;
    }

    public List<Attribute> getCustomIndexData() {
        return this.customIndexData;
    }

    public List<Attribute> getArbitraryIndexData() {
        return this.arbitraryIndexData;
    }

    public String getSecondaryIndexDefn() {
        return this.indexDefnString(this.secondaryIndexData);
    }

    public String getCustomIndexDefn() {
        return this.indexDefnString(this.customIndexData);
    }

    public String getFixedSearchDefn() {
        return this.indexDefnString(this.fixedSearchData);
    }

    public String getArbitraryIndexDefn() {
        return this.indexDefnString(this.arbitraryIndexData);
    }

    public String indexDefnString(List<Attribute> dataList) {
        if (dataList == null || dataList.size() == 0) {
            return null;
        }
        StringBuilder indexStringBuilder = new StringBuilder();
        boolean isRecordAdded = false;
        for (Attribute attribute : dataList) {
            if (isRecordAdded) {
                indexStringBuilder.append(",");
            }
            indexStringBuilder.append(attribute.getName()).append(":").append((Object)attribute.getType());
            isRecordAdded = true;
        }
        return indexStringBuilder.toString();
    }

    public boolean isIncrementalIndex() {
        return this.isIncrementalIndex;
    }

    public AttributeType getAttributeTypeforProperty(String property) {
        if (this.payloadCustomIndex != null && this.payloadCustomIndex.containsKey(property)) {
            return this.payloadCustomIndex.get(property).getType();
        }
        if (this.correlationCustomIndex != null && this.correlationCustomIndex.containsKey(property)) {
            return this.correlationCustomIndex.get(property).getType();
        }
        if (this.metaCustomIndex != null && this.metaCustomIndex.containsKey(property)) {
            return this.metaCustomIndex.get(property).getType();
        }
        if (this.generalCustomIndex != null && this.generalCustomIndex.containsKey(property)) {
            return this.generalCustomIndex.get(property).getType();
        }
        if (this.arbitraryIndex != null && this.arbitraryIndex.containsKey(property)) {
            return this.arbitraryIndex.get(property).getType();
        }
        return null;
    }

    public String getAttributeNameforProperty(String property) {
        if (this.payloadCustomIndex != null && this.payloadCustomIndex.containsKey(property)) {
            return "payload_" + property;
        }
        if (this.correlationCustomIndex != null && this.correlationCustomIndex.containsKey(property)) {
            return "correlation_" + property;
        }
        if (this.metaCustomIndex != null && this.metaCustomIndex.containsKey(property)) {
            return "meta_" + property;
        }
        if (this.generalCustomIndex != null && this.generalCustomIndex.containsKey(property)) {
            return property;
        }
        if (this.arbitraryIndex != null && this.arbitraryIndex.containsKey(property)) {
            return property;
        }
        return null;
    }

    public AttributeType getAttributeTypeforFixedProperty(String property) {
        if (this.fixedPropertiesMap == null) {
            return null;
        }
        return this.fixedPropertiesMap.get(property).getType();
    }

    public void clearIndexInformation() {
        if (this.secondaryIndexData != null) {
            this.secondaryIndexData.clear();
            this.secondaryIndexData = null;
        }
        if (this.customIndexData != null) {
            this.customIndexData.clear();
            this.customIndexData = null;
        }
    }

    public Map<String, Attribute> getMetaCustomIndex() {
        return this.metaCustomIndex;
    }

    public Map<String, Attribute> getPayloadCustomIndex() {
        return this.payloadCustomIndex;
    }

    public Map<String, Attribute> getCorrelationCustomIndex() {
        return this.correlationCustomIndex;
    }

    public Map<String, Attribute> getFixedPropertiesMap() {
        return this.fixedPropertiesMap;
    }

    public List<Attribute> getFixedSearchData() {
        return this.fixedSearchData;
    }

    public void setFixedSearchData(List<Attribute> fixedSearchData) {
        this.fixedSearchData = fixedSearchData;
    }

    public Map<String, Attribute> getGeneralCustomIndex() {
        return this.generalCustomIndex;
    }

    public Map<String, Attribute> getArbitraryIndex() {
        return this.arbitraryIndex;
    }

    public boolean isIndexTimestamp() {
        return this.isIndexTimestamp;
    }

    public void setIndexTimestamp(boolean indexTimestamp) {
        this.isIndexTimestamp = indexTimestamp;
    }

    public Set<String> getMetaFixProps() {
        return this.metaFixProps;
    }

    public Set<String> getPayloadFixProps() {
        return this.payloadFixProps;
    }

    public Set<String> getCorrelationFixProps() {
        return this.correlationFixProps;
    }

    public Set<String> getGeneralFixProps() {
        return this.generalFixProps;
    }
}

