/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.commons.utils;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Set;
import org.wso2.carbon.databridge.commons.Event;

public class DataBridgeCommonsUtils {
    public static final String STREAM_NAME_VERSION_SPLITTER = ":";
    private static final String JVM_BIT_ARCH_SYSTEM_PROPERTY = "sun.arch.data.model";
    private static int referenceSize;

    public static String generateStreamId(String streamName, String streamVersion) {
        return streamName + STREAM_NAME_VERSION_SPLITTER + streamVersion;
    }

    public static String getStreamNameFromStreamId(String streamId) {
        if (streamId == null) {
            return null;
        }
        return streamId.split(STREAM_NAME_VERSION_SPLITTER)[0];
    }

    public static String getStreamVersionFromStreamId(String streamId) {
        if (streamId == null) {
            return null;
        }
        return streamId.split(STREAM_NAME_VERSION_SPLITTER)[1];
    }

    public static int getSize(Event event) {
        int size = event.getStreamId().getBytes().length;
        size += 8;
        if (event.getPayloadData() != null) {
            size += DataBridgeCommonsUtils.getSize(event.getPayloadData());
        }
        if (event.getMetaData() != null) {
            size += DataBridgeCommonsUtils.getSize(event.getMetaData());
        }
        if (event.getCorrelationData() != null) {
            size += DataBridgeCommonsUtils.getSize(event.getCorrelationData());
        }
        if (event.getArbitraryDataMap() != null) {
            size += DataBridgeCommonsUtils.getSize(event.getArbitraryDataMap());
        }
        return size;
    }

    public static int getSize(Map<String, String> arbitraryData) {
        int totalSize = 0;
        Set<Map.Entry<String, String>> entrySet = arbitraryData.entrySet();
        for (Map.Entry<String, String> anEntry : entrySet) {
            totalSize += DataBridgeCommonsUtils.getSize(anEntry.getKey());
            totalSize += DataBridgeCommonsUtils.getSize(anEntry.getValue());
        }
        return totalSize += referenceSize * arbitraryData.size() * 2;
    }

    private static int getSize(Object[] objects) {
        int size = 0;
        for (Object object : objects) {
            if (object == null) continue;
            if (object instanceof Integer) {
                size += 4;
                continue;
            }
            if (object instanceof Long) {
                size += 8;
                continue;
            }
            if (object instanceof Boolean) {
                ++size;
                continue;
            }
            if (object instanceof Double) {
                size += 8;
                continue;
            }
            if (object instanceof Float) {
                size += 4;
                continue;
            }
            if (!(object instanceof String)) continue;
            size += DataBridgeCommonsUtils.getSize(object.toString());
        }
        return size += referenceSize * objects.length;
    }

    public static int getSize(String value) {
        int size = 0;
        if (value != null) {
            try {
                size = value.getBytes("UTF8").length;
            }
            catch (UnsupportedEncodingException e) {
                size = value.getBytes().length;
            }
        }
        return size;
    }

    public static int getReferenceSize() {
        return referenceSize;
    }

    static {
        String arch = System.getProperty(JVM_BIT_ARCH_SYSTEM_PROPERTY);
        referenceSize = arch.equals("32") ? 4 : 8;
    }
}

