/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.internal;

import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.AccessedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.spi.CachingProvider;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;

public class CachingCommandProvider
implements CommandProvider {
    private Duration cacheExpiry = new Duration(TimeUnit.MINUTES, 15L);

    public String getHelp() {
        return "---Carbon Caching (JSR107)---\n\tcachePut <cache-name> <key> <value> - Put a string into the cache.\n\tcacheGet <cache-name> <key> - Get the value of <key>\n\tcacheDelete <cache-name> <key> - Delete the cache entry corresponding to <key>\n\tcacheList - List all the cache names\n\tcacheClear <cache-name> - Clear the cache\n\tcachePrint <cache-name> - Print all the key-value pairs in the cache";
    }

    public void _cacheSetExpiry(CommandInterpreter ci) {
    }

    public void _cachePut(CommandInterpreter ci) {
        String cacheName = ci.nextArgument();
        String key = ci.nextArgument();
        String value = ci.nextArgument();
        if (cacheName != null && key != null && value != null) {
            this.getCache(cacheName).put(key, value);
            System.out.println("OK");
        } else {
            System.out.println("Usage: cachePut <cache-name> <key> <value>");
        }
    }

    public void _cacheGet(CommandInterpreter ci) {
        String cacheName = ci.nextArgument();
        String key = ci.nextArgument();
        if (cacheName != null && key != null) {
            System.out.println(this.getCache(cacheName).get(key));
        } else {
            System.out.println("Usage: cacheGet <cache-name> <key>");
        }
    }

    public void _cacheDelete(CommandInterpreter ci) {
        String cacheName = ci.nextArgument();
        String key = ci.nextArgument();
        if (cacheName != null && key != null) {
            this.getCache(cacheName).remove(key);
            System.out.println("OK");
        } else {
            System.out.println("Usage: cacheDelete <cache-name> <key>");
        }
    }

    public void _cachePrint(CommandInterpreter ci) {
        String cacheName = ci.nextArgument();
        if (cacheName != null) {
            Cache<String, String> cache = this.getCache(cacheName);
            for (Cache.Entry<String, String> entry : cache) {
                System.out.println(entry.getKey() + "=" + entry.getValue());
            }
        } else {
            System.out.println("Usage: cachePrint <cache-name>");
        }
    }

    public void _cacheClear(CommandInterpreter ci) {
        String cacheName = ci.nextArgument();
        CachingProvider provider = Caching.getCachingProvider();
        CacheManager cacheManager = provider.getCacheManager();
        if (cacheName != null) {
            cacheManager.destroyCache(cacheName);
            System.out.println("OK");
        } else {
            System.out.println("Usage: cacheClear <cache-name>");
        }
    }

    public void _cacheList(CommandInterpreter ci) {
        CachingProvider provider = Caching.getCachingProvider();
        CacheManager cacheManager = provider.getCacheManager();
        System.out.println(cacheManager.getCacheNames());
    }

    private Cache<String, String> getCache(String cacheName) {
        CachingProvider provider = Caching.getCachingProvider();
        CacheManager cacheManager = provider.getCacheManager();
        Cache<String, String> cache = cacheManager.getCache(cacheName, String.class, String.class);
        if (cache == null) {
            cache = this.initCache(cacheName, cacheManager);
        }
        return cache;
    }

    private Cache<String, String> initCache(String name, CacheManager cacheManager) {
        MutableConfiguration config = new MutableConfiguration();
        config.setStoreByValue(true).setTypes(String.class, String.class).setExpiryPolicyFactory(AccessedExpiryPolicy.factoryOf(this.cacheExpiry)).setStatisticsEnabled(true).setManagementEnabled(true);
        return cacheManager.createCache(name, config);
    }
}

