/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.internal;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriter;
import javax.cache.integration.CacheWriterException;
import javax.cache.integration.CompletionListener;
import javax.cache.management.CacheMXBean;
import javax.cache.management.CacheStatisticsMXBean;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.caching.internal.CarbonCacheEntry;
import org.wso2.carbon.caching.internal.CarbonCacheManager;
import org.wso2.carbon.caching.internal.CarbonCachedValue;
import org.wso2.carbon.caching.internal.InternalConverter;
import org.wso2.carbon.caching.internal.InternalMap;
import org.wso2.carbon.caching.internal.LockManager;
import org.wso2.carbon.caching.internal.ReferenceInternalConverter;
import org.wso2.carbon.caching.internal.SerializingInternalConverter;
import org.wso2.carbon.caching.internal.SimpleInternalMap;
import org.wso2.carbon.caching.internal.event.CarbonCacheEntryEvent;
import org.wso2.carbon.caching.internal.event.CarbonCacheEntryListenerRegistration;
import org.wso2.carbon.caching.internal.event.CarbonCacheEventDispatcher;
import org.wso2.carbon.caching.internal.management.CarbonCacheMXBean;
import org.wso2.carbon.caching.internal.management.CarbonCacheStatisticsMXBean;
import org.wso2.carbon.caching.internal.management.MBeanServerRegistrationUtility;
import org.wso2.carbon.caching.internal.processor.CarbonEntryProcessorResult;
import org.wso2.carbon.caching.internal.processor.EntryProcessorEntry;
import org.wso2.carbon.caching.internal.processor.MutableEntryOperation;

public final class CarbonCache<K, V>
implements Cache<K, V> {
    private static final Logger log = LoggerFactory.getLogger(CarbonCache.class);
    private final String cacheName;
    private final CarbonCacheManager cacheManager;
    private final MutableConfiguration<K, V> configuration;
    private final InternalConverter<K> keyConverter;
    private final InternalConverter<V> valueConverter;
    private final InternalMap<Object, CarbonCachedValue> entries;
    private final ExpiryPolicy expiryPolicy;
    private final CopyOnWriteArrayList<CarbonCacheEntryListenerRegistration<K, V>> listenerRegistrations;
    private final CarbonCacheMXBean<K, V> cacheMXBean;
    private final CarbonCacheStatisticsMXBean statistics;
    private final LockManager<K> lockManager = new LockManager();
    private final ExecutorService executorService = Executors.newFixedThreadPool(1);
    private CacheLoader<K, V> cacheLoader;
    private CacheWriter<K, V> cacheWriter;
    private volatile boolean isClosed;
    private ArrayList<CacheEntryListenerConfiguration<K, V>> dynamicListenerConfigurations;

    CarbonCache(CarbonCacheManager cacheManager, String cacheName, ClassLoader classLoader, Configuration<K, V> configuration) {
        this.cacheManager = cacheManager;
        this.cacheName = cacheName;
        if (configuration instanceof CompleteConfiguration) {
            this.configuration = new MutableConfiguration((MutableConfiguration)configuration);
        } else {
            MutableConfiguration<K, V> mutableConfiguration = new MutableConfiguration<K, V>();
            mutableConfiguration.setStoreByValue(configuration.isStoreByValue());
            mutableConfiguration.setTypes(configuration.getKeyType(), configuration.getValueType());
            this.configuration = new MutableConfiguration(mutableConfiguration);
        }
        if (this.configuration.getCacheLoaderFactory() != null) {
            this.cacheLoader = this.configuration.getCacheLoaderFactory().create();
        }
        if (this.configuration.getCacheWriterFactory() != null) {
            this.cacheWriter = this.configuration.getCacheWriterFactory().create();
        }
        this.keyConverter = this.configuration.isStoreByValue() ? new SerializingInternalConverter(classLoader) : new ReferenceInternalConverter();
        this.valueConverter = this.configuration.isStoreByValue() ? new SerializingInternalConverter(classLoader) : new ReferenceInternalConverter();
        this.expiryPolicy = this.configuration.getExpiryPolicyFactory().create();
        this.entries = new SimpleInternalMap<Object, CarbonCachedValue>();
        this.listenerRegistrations = new CopyOnWriteArrayList();
        for (CacheEntryListenerConfiguration<K, V> listenerConfiguration : this.configuration.getCacheEntryListenerConfigurations()) {
            this.createAndAddListener(listenerConfiguration);
        }
        this.cacheMXBean = new CarbonCacheMXBean(this);
        this.statistics = new CarbonCacheStatisticsMXBean(this);
        this.isClosed = false;
        if (this.configuration.isManagementEnabled()) {
            this.setManagementEnabled(true);
        }
        if (this.configuration.isStatisticsEnabled()) {
            this.setStatisticsEnabled(true);
        }
    }

    private void createAndAddListener(CacheEntryListenerConfiguration<K, V> listenerConfiguration) {
        CarbonCacheEntryListenerRegistration<K, V> registration = new CarbonCacheEntryListenerRegistration<K, V>(listenerConfiguration);
        this.listenerRegistrations.add(registration);
    }

    private void removeListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        if (cacheEntryListenerConfiguration == null) {
            throw new NullPointerException("CacheEntryListenerConfiguration can't be null");
        }
        for (CarbonCacheEntryListenerRegistration<K, V> listenerRegistration : this.listenerRegistrations) {
            if (!cacheEntryListenerConfiguration.equals(listenerRegistration.getConfiguration())) continue;
            this.listenerRegistrations.remove(listenerRegistration);
            this.configuration.removeCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
        }
    }

    protected Future submit(Runnable task) {
        return this.executorService.submit(task);
    }

    protected Duration getDefaultDuration() {
        return Duration.ETERNAL;
    }

    @Override
    public String getName() {
        return this.cacheName;
    }

    @Override
    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public synchronized void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            this.cacheManager.releaseCache(this.cacheName);
            this.setStatisticsEnabled(false);
            this.setManagementEnabled(false);
            if (this.cacheLoader instanceof Closeable) {
                try {
                    ((Closeable)((Object)this.cacheLoader)).close();
                }
                catch (IOException e) {
                    log.warn("Problem closing CacheLoader " + this.cacheLoader.getClass(), (Throwable)e);
                }
            }
            if (this.cacheWriter instanceof Closeable) {
                try {
                    ((Closeable)((Object)this.cacheWriter)).close();
                }
                catch (IOException e) {
                    log.warn("Problem closing CacheWriter " + this.cacheWriter.getClass(), (Throwable)e);
                }
            }
            if (this.expiryPolicy instanceof Closeable) {
                try {
                    ((Closeable)((Object)this.expiryPolicy)).close();
                }
                catch (IOException e) {
                    log.warn("Problem closing ExpiryPolicy " + this.cacheLoader.getClass(), (Throwable)e);
                }
            }
            for (CarbonCacheEntryListenerRegistration<K, V> registration : this.listenerRegistrations) {
                if (!(registration.getCacheEntryListener() instanceof Closeable)) continue;
                try {
                    ((Closeable)((Object)registration.getCacheEntryListener())).close();
                }
                catch (IOException e) {
                    log.warn("Problem closing listener " + this.cacheLoader.getClass(), (Throwable)e);
                }
            }
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new CacheException(e);
            }
            this.entries.clear();
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        if (clazz.isInstance(this.configuration)) {
            return (C)((Configuration)clazz.cast(this.configuration));
        }
        throw new IllegalArgumentException("The configuration class " + clazz + " is not supported by this implementation");
    }

    @Override
    public V get(K key) {
        this.ensureOpen();
        if (key == null) {
            throw new NullPointerException();
        }
        CarbonCacheEventDispatcher<K, V> dispatcher = new CarbonCacheEventDispatcher<K, V>();
        Object value = this.getValue(key, dispatcher);
        dispatcher.dispatch(this.listenerRegistrations);
        return value;
    }

    @Override
    public Map<K, V> getAll(Set<? extends K> keys) {
        this.ensureOpen();
        if (keys.contains(null)) {
            throw new NullPointerException("key");
        }
        HashMap map = new HashMap(keys.size());
        CarbonCacheEventDispatcher<K, V> dispatcher = new CarbonCacheEventDispatcher<K, V>();
        for (K key : keys) {
            Object value = this.getValue(key, dispatcher);
            if (value == null) continue;
            map.put(key, value);
        }
        dispatcher.dispatch(this.listenerRegistrations);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(K key) {
        this.ensureOpen();
        if (key == null) {
            throw new NullPointerException();
        }
        long now = System.currentTimeMillis();
        this.lockManager.lock(key);
        try {
            Object internalKey = this.keyConverter.toInternal(key);
            CarbonCachedValue cachedValue = this.entries.get(internalKey);
            boolean bl = cachedValue != null && !cachedValue.isExpiredAt(now);
            return bl;
        }
        finally {
            this.lockManager.unLock(key);
        }
    }

    @Override
    public void loadAll(final Set<? extends K> keys, final boolean replaceExistingValues, final CompletionListener completionListener) {
        this.ensureOpen();
        if (keys == null) {
            throw new NullPointerException("keys");
        }
        if (this.cacheLoader == null) {
            if (completionListener != null) {
                completionListener.onCompletion();
            }
        } else {
            for (K key : keys) {
                if (key != null) continue;
                throw new NullPointerException("keys contains a null");
            }
            this.submit(new Runnable(){

                @Override
                public void run() {
                    block8: {
                        try {
                            Map loaded;
                            ArrayList keysToLoad = new ArrayList();
                            for (Object key : keys) {
                                if (!replaceExistingValues && CarbonCache.this.containsKey(key)) continue;
                                keysToLoad.add(key);
                            }
                            try {
                                loaded = CarbonCache.this.cacheLoader.loadAll(keysToLoad);
                            }
                            catch (Exception e) {
                                if (!(e instanceof CacheLoaderException)) {
                                    throw new CacheLoaderException("Exception in CacheLoader", e);
                                }
                                throw e;
                            }
                            for (Object key : keysToLoad) {
                                if (loaded.get(key) != null) continue;
                                loaded.remove(key);
                            }
                            CarbonCache.this.putAll(loaded, replaceExistingValues, false);
                            if (completionListener != null) {
                                completionListener.onCompletion();
                            }
                        }
                        catch (Exception e) {
                            if (completionListener == null) break block8;
                            completionListener.onException(e);
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V value) {
        long start = this.statisticsEnabled() ? System.nanoTime() : 0L;
        int putCount = 0;
        this.ensureOpen();
        if (key == null) {
            throw new NullPointerException("null value specified for key");
        }
        if (value == null) {
            throw new NullPointerException("null value specified for key " + key);
        }
        this.checkTypesAgainstConfiguredTypes(key, value);
        this.lockManager.lock(key);
        try {
            boolean isOldEntryExpired;
            CarbonCacheEventDispatcher<K, V> dispatcher = new CarbonCacheEventDispatcher<K, V>();
            long now = System.currentTimeMillis();
            Object internalKey = this.keyConverter.toInternal(key);
            Object internalValue = this.valueConverter.toInternal(value);
            CarbonCachedValue cachedValue = this.entries.get(internalKey);
            boolean bl = isOldEntryExpired = cachedValue != null && cachedValue.isExpiredAt(now);
            if (isOldEntryExpired) {
                V expiredValue = this.valueConverter.fromInternal(cachedValue.get());
                this.processExpiries(key, dispatcher, expiredValue);
            }
            if (cachedValue == null || isOldEntryExpired) {
                Duration duration;
                CarbonCacheEntry<K, V> entry = new CarbonCacheEntry<K, V>(key, value);
                try {
                    duration = this.expiryPolicy.getExpiryForCreation();
                }
                catch (Throwable t) {
                    duration = this.getDefaultDuration();
                }
                long expiryTime = duration.getAdjustedTime(now);
                cachedValue = new CarbonCachedValue(internalValue, now, expiryTime);
                this.writeCacheEntry(entry);
                if (cachedValue.isExpiredAt(now)) {
                    this.processExpiries(key, dispatcher, this.valueConverter.fromInternal(cachedValue.get()));
                } else {
                    this.entries.put(internalKey, cachedValue);
                    ++putCount;
                    dispatcher.addEvent(CacheEntryCreatedListener.class, new CarbonCacheEntryEvent<K, V>(this, key, value, EventType.CREATED));
                }
            } else {
                V oldValue = this.valueConverter.fromInternal(cachedValue.get());
                CarbonCacheEntry<K, V> entry = new CarbonCacheEntry<K, V>(key, value, oldValue);
                this.writeCacheEntry(entry);
                try {
                    Duration duration = this.expiryPolicy.getExpiryForUpdate();
                    if (duration != null) {
                        long expiryTime = duration.getAdjustedTime(now);
                        cachedValue.setExpiryTime(expiryTime);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                cachedValue.setInternalValue(internalValue, now);
                ++putCount;
                dispatcher.addEvent(CacheEntryUpdatedListener.class, new CarbonCacheEntryEvent<K, V>(this, key, value, oldValue, EventType.UPDATED));
            }
            dispatcher.dispatch(this.listenerRegistrations);
        }
        finally {
            this.lockManager.unLock(key);
        }
        if (this.statisticsEnabled() && putCount > 0) {
            this.statistics.increaseCachePuts(putCount);
            this.statistics.addPutTimeNano(System.nanoTime() - start);
        }
    }

    private void checkTypesAgainstConfiguredTypes(K key, V value) throws ClassCastException {
        Class<K> keyType = this.configuration.getKeyType();
        Class<V> valueType = this.configuration.getValueType();
        if (Object.class != keyType && !keyType.isAssignableFrom(key.getClass())) {
            throw new ClassCastException("Key " + key + "is not assignable to " + keyType);
        }
        if (Object.class != valueType && !valueType.isAssignableFrom(value.getClass())) {
            throw new ClassCastException("Value " + value + "is not assignable to " + valueType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getAndPut(K key, V value) {
        V result;
        this.ensureOpen();
        if (value == null) {
            throw new NullPointerException("null value specified for key " + key);
        }
        long start = this.statisticsEnabled() ? System.nanoTime() : 0L;
        long now = System.currentTimeMillis();
        int putCount = 0;
        this.lockManager.lock(key);
        try {
            boolean isExpired;
            CarbonCacheEventDispatcher<K, V> dispatcher = new CarbonCacheEventDispatcher<K, V>();
            Object internalKey = this.keyConverter.toInternal(key);
            Object internalValue = this.valueConverter.toInternal(value);
            CarbonCachedValue cachedValue = this.entries.get(internalKey);
            boolean bl = isExpired = cachedValue != null && cachedValue.isExpiredAt(now);
            if (cachedValue == null || isExpired) {
                Duration duration;
                result = null;
                CarbonCacheEntry<K, V> entry = new CarbonCacheEntry<K, V>(key, value);
                this.writeCacheEntry(entry);
                if (isExpired) {
                    V expiredValue = this.valueConverter.fromInternal(cachedValue.get());
                    this.processExpiries(key, dispatcher, expiredValue);
                }
                try {
                    duration = this.expiryPolicy.getExpiryForCreation();
                }
                catch (Throwable t) {
                    duration = this.getDefaultDuration();
                }
                long expiryTime = duration.getAdjustedTime(now);
                cachedValue = new CarbonCachedValue(internalValue, now, expiryTime);
                if (cachedValue.isExpiredAt(now)) {
                    this.processExpiries(key, dispatcher, value);
                } else {
                    this.entries.put(internalKey, cachedValue);
                    ++putCount;
                    dispatcher.addEvent(CacheEntryCreatedListener.class, new CarbonCacheEntryEvent<K, V>(this, key, value, EventType.CREATED));
                }
            } else {
                V oldValue = this.valueConverter.fromInternal(cachedValue.getInternalValue(now));
                CarbonCacheEntry<K, V> entry = new CarbonCacheEntry<K, V>(key, value, oldValue);
                this.writeCacheEntry(entry);
                try {
                    Duration duration = this.expiryPolicy.getExpiryForUpdate();
                    if (duration != null) {
                        long expiryTime = duration.getAdjustedTime(now);
                        cachedValue.setExpiryTime(expiryTime);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                cachedValue.setInternalValue(internalValue, now);
                ++putCount;
                result = oldValue;
                dispatcher.addEvent(CacheEntryUpdatedListener.class, new CarbonCacheEntryEvent<K, V>(this, key, value, oldValue, EventType.UPDATED));
            }
            dispatcher.dispatch(this.listenerRegistrations);
        }
        finally {
            this.lockManager.unLock(key);
        }
        if (this.statisticsEnabled()) {
            if (result == null) {
                this.statistics.increaseCacheMisses(1L);
            } else {
                this.statistics.increaseCacheHits(1L);
            }
            this.statistics.addGetTimeNano(System.nanoTime() - start);
            if (putCount > 0) {
                this.statistics.increaseCachePuts(putCount);
                this.statistics.addPutTimeNano(System.nanoTime() - start);
            }
        }
        return result;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.putAll(map, true);
    }

    public void putAll(Map<? extends K, ? extends V> map, boolean replaceExistingValues) {
        this.putAll(map, replaceExistingValues, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map<? extends K, ? extends V> map, boolean replaceExistingValues, boolean useWriteThrough) {
        this.ensureOpen();
        long start = this.statisticsEnabled() ? System.nanoTime() : 0L;
        long now = System.currentTimeMillis();
        int putCount = 0;
        if (map.containsKey(null)) {
            throw new NullPointerException("key");
        }
        CacheWriterException exception = null;
        CarbonCacheEventDispatcher<Object, V> dispatcher = new CarbonCacheEventDispatcher<Object, V>();
        try {
            boolean isWriteThrough = this.configuration.isWriteThrough() && this.cacheWriter != null && useWriteThrough;
            ArrayList entriesToWrite = new ArrayList();
            HashSet<K> keysToPut = new HashSet<K>();
            for (Map.Entry<K, V> entry : map.entrySet()) {
                K key = entry.getKey();
                V value = entry.getValue();
                if (value == null) {
                    throw new NullPointerException("key " + key + " has a null value");
                }
                this.lockManager.lock(key);
                keysToPut.add(key);
                if (!isWriteThrough) continue;
                entriesToWrite.add(new CarbonCacheEntry<K, V>(key, value));
            }
            if (isWriteThrough) {
                block23: {
                    try {
                        this.cacheWriter.writeAll(entriesToWrite);
                    }
                    catch (Exception e) {
                        if (e instanceof CacheWriterException) break block23;
                        exception = new CacheWriterException("Exception during write", e);
                    }
                }
                for (Cache.Entry entry : entriesToWrite) {
                    keysToPut.remove(entry.getKey());
                }
            }
            for (Object e : keysToPut) {
                boolean isExpired;
                V value = map.get(e);
                Object internalKey = this.keyConverter.toInternal(e);
                Object internalValue = this.valueConverter.toInternal(value);
                CarbonCachedValue cachedValue = this.entries.get(internalKey);
                boolean bl = isExpired = cachedValue != null && cachedValue.isExpiredAt(now);
                if (cachedValue == null || isExpired) {
                    Duration duration;
                    if (isExpired) {
                        V expiredValue = this.valueConverter.fromInternal(cachedValue.get());
                        this.processExpiries(e, dispatcher, expiredValue);
                    }
                    try {
                        duration = this.expiryPolicy.getExpiryForCreation();
                    }
                    catch (Throwable t) {
                        duration = this.getDefaultDuration();
                    }
                    long expiryTime = duration.getAdjustedTime(now);
                    cachedValue = new CarbonCachedValue(internalValue, now, expiryTime);
                    if (cachedValue.isExpiredAt(now)) {
                        this.processExpiries(e, dispatcher, value);
                        continue;
                    }
                    this.entries.put(internalKey, cachedValue);
                    dispatcher.addEvent(CacheEntryCreatedListener.class, new CarbonCacheEntryEvent(this, e, value, EventType.CREATED));
                    if (!useWriteThrough) continue;
                    ++putCount;
                    continue;
                }
                if (!replaceExistingValues) continue;
                V oldValue = this.valueConverter.fromInternal(cachedValue.get());
                try {
                    Duration duration = this.expiryPolicy.getExpiryForUpdate();
                    if (duration != null) {
                        long expiryTime = duration.getAdjustedTime(now);
                        cachedValue.setExpiryTime(expiryTime);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                cachedValue.setInternalValue(internalValue, now);
                if (useWriteThrough) {
                    ++putCount;
                }
                dispatcher.addEvent(CacheEntryUpdatedListener.class, new CarbonCacheEntryEvent(this, e, value, oldValue, EventType.UPDATED));
            }
        }
        finally {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                K key = entry.getKey();
                V value = entry.getValue();
                this.lockManager.unLock(key);
            }
        }
        dispatcher.dispatch(this.listenerRegistrations);
        if (this.statisticsEnabled() && putCount > 0) {
            this.statistics.increaseCachePuts(putCount);
            this.statistics.addPutTimeNano(System.nanoTime() - start);
        }
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putIfAbsent(K key, V value) {
        boolean result;
        this.ensureOpen();
        if (value == null) {
            throw new NullPointerException("null value specified for key " + key);
        }
        this.checkTypesAgainstConfiguredTypes(key, value);
        long start = this.statisticsEnabled() ? System.nanoTime() : 0L;
        long now = System.currentTimeMillis();
        this.lockManager.lock(key);
        try {
            boolean isExpired;
            CarbonCacheEventDispatcher<K, V> dispatcher = new CarbonCacheEventDispatcher<K, V>();
            Object internalKey = this.keyConverter.toInternal(key);
            Object internalValue = this.valueConverter.toInternal(value);
            CarbonCachedValue cachedValue = this.entries.get(internalKey);
            boolean bl = isExpired = cachedValue != null && cachedValue.isExpiredAt(now);
            if (cachedValue == null || cachedValue.isExpiredAt(now)) {
                Duration duration;
                CarbonCacheEntry<K, V> entry = new CarbonCacheEntry<K, V>(key, value);
                this.writeCacheEntry(entry);
                if (isExpired) {
                    V expiredValue = this.valueConverter.fromInternal(cachedValue.get());
                    this.processExpiries(key, dispatcher, expiredValue);
                }
                try {
                    duration = this.expiryPolicy.getExpiryForCreation();
                }
                catch (Throwable t) {
                    duration = this.getDefaultDuration();
                }
                long expiryTime = duration.getAdjustedTime(now);
                cachedValue = new CarbonCachedValue(internalValue, now, expiryTime);
                if (cachedValue.isExpiredAt(now)) {
                    this.processExpiries(key, dispatcher, value);
                    result = false;
                } else {
                    this.entries.put(internalKey, cachedValue);
                    result = true;
                    dispatcher.addEvent(CacheEntryCreatedListener.class, new CarbonCacheEntryEvent<K, V>(this, key, value, EventType.CREATED));
                }
            } else {
                result = false;
            }
            dispatcher.dispatch(this.listenerRegistrations);
        }
        finally {
            this.lockManager.unLock(key);
        }
        if (this.statisticsEnabled()) {
            if (result) {
                this.statistics.increaseCachePuts(1L);
                this.statistics.increaseCacheMisses(1L);
                this.statistics.addPutTimeNano(System.nanoTime() - start);
            } else {
                this.statistics.increaseCacheHits(1L);
            }
        }
        return result;
    }

    private void processExpiries(K key, CarbonCacheEventDispatcher<K, V> dispatcher, V expiredValue) {
        this.entries.remove(key);
        dispatcher.addEvent(CacheEntryExpiredListener.class, new CarbonCacheEntryEvent<K, V>(this, key, expiredValue, EventType.EXPIRED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(K key) {
        boolean result;
        this.ensureOpen();
        long start = this.statisticsEnabled() ? System.nanoTime() : 0L;
        long now = System.currentTimeMillis();
        this.lockManager.lock(key);
        try {
            this.deleteCacheEntry(key);
            Object internalKey = this.keyConverter.toInternal(key);
            CarbonCachedValue cachedValue = this.entries.get(internalKey);
            if (cachedValue == null) {
                boolean bl = false;
                return bl;
            }
            if (cachedValue.isExpiredAt(now)) {
                result = false;
            } else {
                this.entries.remove(internalKey);
                V value = this.valueConverter.fromInternal(cachedValue.get());
                CarbonCacheEventDispatcher<K, V> dispatcher = new CarbonCacheEventDispatcher<K, V>();
                dispatcher.addEvent(CacheEntryRemovedListener.class, new CarbonCacheEntryEvent<K, V>(this, key, value, EventType.REMOVED));
                dispatcher.dispatch(this.listenerRegistrations);
                result = true;
            }
        }
        finally {
            this.lockManager.unLock(key);
        }
        if (result && this.statisticsEnabled()) {
            this.statistics.increaseCacheRemovals(1L);
            this.statistics.addRemoveTimeNano(System.nanoTime() - start);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(K key, V oldValue) {
        boolean result;
        long start;
        long hitCount;
        block13: {
            this.ensureOpen();
            if (oldValue == null) {
                throw new NullPointerException("null oldValue specified for key " + key);
            }
            long now = System.currentTimeMillis();
            hitCount = 0L;
            start = this.statisticsEnabled() ? System.nanoTime() : 0L;
            this.lockManager.lock(key);
            try {
                Object oldInternalValue;
                Object internalKey = this.keyConverter.toInternal(key);
                CarbonCachedValue cachedValue = this.entries.get(internalKey);
                if (cachedValue == null || cachedValue.isExpiredAt(now)) {
                    result = false;
                    break block13;
                }
                ++hitCount;
                Object internalValue = cachedValue.get();
                if (internalValue.equals(oldInternalValue = this.valueConverter.toInternal(oldValue))) {
                    this.deleteCacheEntry(key);
                    this.entries.remove(internalKey);
                    CarbonCacheEventDispatcher<K, V> dispatcher = new CarbonCacheEventDispatcher<K, V>();
                    dispatcher.addEvent(CacheEntryRemovedListener.class, new CarbonCacheEntryEvent<K, V>(this, key, oldValue, EventType.REMOVED));
                    dispatcher.dispatch(this.listenerRegistrations);
                    result = true;
                    break block13;
                }
                try {
                    Duration duration = this.expiryPolicy.getExpiryForAccess();
                    if (duration != null) {
                        long expiryTime = duration.getAdjustedTime(now);
                        cachedValue.setExpiryTime(expiryTime);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                result = false;
            }
            finally {
                this.lockManager.unLock(key);
            }
        }
        if (this.statisticsEnabled()) {
            if (result) {
                this.statistics.increaseCacheRemovals(1L);
                this.statistics.addRemoveTimeNano(System.nanoTime() - start);
            }
            this.statistics.addGetTimeNano(System.nanoTime() - start);
            if (hitCount == 1L) {
                this.statistics.increaseCacheHits(hitCount);
            } else {
                this.statistics.increaseCacheMisses(1L);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getAndRemove(K key) {
        Object result;
        this.ensureOpen();
        long now = System.currentTimeMillis();
        long start = this.statisticsEnabled() ? System.nanoTime() : 0L;
        this.lockManager.lock(key);
        try {
            this.deleteCacheEntry(key);
            Object internalKey = this.keyConverter.toInternal(key);
            CarbonCachedValue cachedValue = this.entries.get(internalKey);
            if (cachedValue == null || cachedValue.isExpiredAt(now)) {
                result = null;
            } else {
                this.entries.remove(internalKey);
                result = this.valueConverter.fromInternal(cachedValue.getInternalValue(now));
                CarbonCacheEventDispatcher<K, V> dispatcher = new CarbonCacheEventDispatcher<K, V>();
                dispatcher.addEvent(CacheEntryRemovedListener.class, new CarbonCacheEntryEvent<K, Object>(this, key, result, EventType.REMOVED));
                dispatcher.dispatch(this.listenerRegistrations);
            }
        }
        finally {
            this.lockManager.unLock(key);
        }
        if (this.statisticsEnabled()) {
            this.statistics.addGetTimeNano(System.nanoTime() - start);
            if (result != null) {
                this.statistics.increaseCacheHits(1L);
                this.statistics.increaseCacheRemovals(1L);
                this.statistics.addRemoveTimeNano(System.nanoTime() - start);
            } else {
                this.statistics.increaseCacheMisses(1L);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        boolean result;
        long hitCount;
        long start;
        block17: {
            this.ensureOpen();
            if (newValue == null) {
                throw new NullPointerException("null newValue specified for key " + key);
            }
            if (oldValue == null) {
                throw new NullPointerException("null oldValue specified for key " + key);
            }
            long now = System.currentTimeMillis();
            start = this.statisticsEnabled() ? System.nanoTime() : 0L;
            hitCount = 0L;
            this.lockManager.lock(key);
            try {
                Object internalKey = this.keyConverter.toInternal(key);
                CarbonCachedValue cachedValue = this.entries.get(internalKey);
                if (cachedValue == null || cachedValue.isExpiredAt(now)) {
                    result = false;
                    break block17;
                }
                ++hitCount;
                Object oldInternalValue = this.valueConverter.toInternal(oldValue);
                if (cachedValue.get().equals(oldInternalValue)) {
                    CarbonCacheEntry<K, V> entry = new CarbonCacheEntry<K, V>(key, newValue, oldValue);
                    this.writeCacheEntry(entry);
                    try {
                        Duration duration = this.expiryPolicy.getExpiryForUpdate();
                        if (duration != null) {
                            long expiryTime = duration.getAdjustedTime(now);
                            cachedValue.setExpiryTime(expiryTime);
                        }
                    }
                    catch (Throwable duration) {
                        // empty catch block
                    }
                    Object newInternalValue = this.valueConverter.toInternal(newValue);
                    cachedValue.setInternalValue(newInternalValue, now);
                    CarbonCacheEventDispatcher<K, V> dispatcher = new CarbonCacheEventDispatcher<K, V>();
                    dispatcher.addEvent(CacheEntryUpdatedListener.class, new CarbonCacheEntryEvent<K, V>(this, key, newValue, oldValue, EventType.UPDATED));
                    dispatcher.dispatch(this.listenerRegistrations);
                    result = true;
                    break block17;
                }
                try {
                    Duration duration = this.expiryPolicy.getExpiryForAccess();
                    if (duration != null) {
                        long expiryTime = duration.getAdjustedTime(now);
                        cachedValue.setExpiryTime(expiryTime);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                result = false;
            }
            finally {
                this.lockManager.unLock(key);
            }
        }
        if (this.statisticsEnabled()) {
            if (result) {
                this.statistics.increaseCachePuts(1L);
                this.statistics.addPutTimeNano(System.nanoTime() - start);
            }
            this.statistics.addGetTimeNano(System.nanoTime() - start);
            if (hitCount == 1L) {
                this.statistics.increaseCacheHits(hitCount);
            } else {
                this.statistics.increaseCacheMisses(1L);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V value) {
        boolean result;
        long start;
        block11: {
            this.ensureOpen();
            if (value == null) {
                throw new NullPointerException("null value specified for key " + key);
            }
            long now = System.currentTimeMillis();
            start = this.statisticsEnabled() ? System.nanoTime() : 0L;
            this.lockManager.lock(key);
            try {
                Object internalKey = this.keyConverter.toInternal(key);
                CarbonCachedValue cachedValue = this.entries.get(internalKey);
                if (cachedValue == null || cachedValue.isExpiredAt(now)) {
                    result = false;
                    break block11;
                }
                V oldValue = this.valueConverter.fromInternal(cachedValue.get());
                CarbonCacheEntry<K, V> entry = new CarbonCacheEntry<K, V>(key, value, oldValue);
                this.writeCacheEntry(entry);
                try {
                    Duration duration = this.expiryPolicy.getExpiryForUpdate();
                    if (duration != null) {
                        long expiryTime = duration.getAdjustedTime(now);
                        cachedValue.setExpiryTime(expiryTime);
                    }
                }
                catch (Throwable duration) {
                    // empty catch block
                }
                Object internalValue = this.valueConverter.toInternal(value);
                cachedValue.setInternalValue(internalValue, now);
                CarbonCacheEventDispatcher<K, V> dispatcher = new CarbonCacheEventDispatcher<K, V>();
                dispatcher.addEvent(CacheEntryUpdatedListener.class, new CarbonCacheEntryEvent<K, V>(this, key, value, oldValue, EventType.UPDATED));
                dispatcher.dispatch(this.listenerRegistrations);
                result = true;
            }
            finally {
                this.lockManager.unLock(key);
            }
        }
        if (this.statisticsEnabled()) {
            this.statistics.addGetTimeNano(System.nanoTime() - start);
            if (result) {
                this.statistics.increaseCachePuts(1L);
                this.statistics.increaseCacheHits(1L);
                this.statistics.addPutTimeNano(System.nanoTime() - start);
            } else {
                this.statistics.increaseCacheMisses(1L);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getAndReplace(K key, V value) {
        V result;
        long start;
        block11: {
            this.ensureOpen();
            if (value == null) {
                throw new NullPointerException("null value specified for key " + key);
            }
            long now = System.currentTimeMillis();
            start = this.statisticsEnabled() ? System.nanoTime() : 0L;
            this.lockManager.lock(key);
            try {
                Object internalKey = this.keyConverter.toInternal(key);
                CarbonCachedValue cachedValue = this.entries.get(internalKey);
                if (cachedValue == null || cachedValue.isExpiredAt(now)) {
                    result = null;
                    break block11;
                }
                V oldValue = this.valueConverter.fromInternal(cachedValue.getInternalValue(now));
                CarbonCacheEntry<K, V> entry = new CarbonCacheEntry<K, V>(key, value, oldValue);
                this.writeCacheEntry(entry);
                try {
                    Duration duration = this.expiryPolicy.getExpiryForUpdate();
                    if (duration != null) {
                        long expiryTime = duration.getAdjustedTime(now);
                        cachedValue.setExpiryTime(expiryTime);
                    }
                }
                catch (Throwable duration) {
                    // empty catch block
                }
                Object internalValue = this.valueConverter.toInternal(value);
                cachedValue.setInternalValue(internalValue, now);
                CarbonCacheEventDispatcher<K, V> dispatcher = new CarbonCacheEventDispatcher<K, V>();
                dispatcher.addEvent(CacheEntryUpdatedListener.class, new CarbonCacheEntryEvent<K, V>(this, key, value, oldValue, EventType.UPDATED));
                dispatcher.dispatch(this.listenerRegistrations);
                result = oldValue;
            }
            finally {
                this.lockManager.unLock(key);
            }
        }
        if (this.statisticsEnabled()) {
            this.statistics.addGetTimeNano(System.nanoTime() - start);
            if (result != null) {
                this.statistics.increaseCacheHits(1L);
                this.statistics.increaseCachePuts(1L);
                this.statistics.addPutTimeNano(System.nanoTime() - start);
            } else {
                this.statistics.increaseCacheMisses(1L);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll(Set<? extends K> keys) {
        this.ensureOpen();
        long now = System.currentTimeMillis();
        CacheWriterException exception = null;
        HashSet<K> lockedKeys = new HashSet<K>();
        HashSet<K> cacheWriterKeys = new HashSet<K>();
        cacheWriterKeys.addAll(keys);
        CarbonCacheEventDispatcher<K, V> dispatcher = new CarbonCacheEventDispatcher<K, V>();
        try {
            V value;
            CarbonCachedValue cachedValue;
            Object internalKey;
            boolean isWriteThrough = this.configuration.isWriteThrough() && this.cacheWriter != null;
            HashSet<K> deletedKeys = new HashSet<K>();
            for (Object key : keys) {
                this.lockManager.lock(key);
                lockedKeys.add(key);
            }
            if (isWriteThrough) {
                block15: {
                    try {
                        this.cacheWriter.deleteAll(cacheWriterKeys);
                    }
                    catch (Exception e) {
                        if (e instanceof CacheWriterException) break block15;
                        exception = new CacheWriterException("Exception during write", e);
                    }
                }
                for (Object key : lockedKeys) {
                    if (cacheWriterKeys.contains(key) || !this.entries.containsKey(internalKey = this.keyConverter.toInternal(key))) continue;
                    cachedValue = this.entries.remove(internalKey);
                    deletedKeys.add(key);
                    value = this.valueConverter.fromInternal(cachedValue.get());
                    if (cachedValue.isExpiredAt(now)) {
                        this.processExpiries(key, dispatcher, value);
                        continue;
                    }
                    dispatcher.addEvent(CacheEntryRemovedListener.class, new CarbonCacheEntryEvent<K, V>(this, key, value, EventType.REMOVED));
                }
            }
            if (!isWriteThrough) {
                for (Object key : lockedKeys) {
                    internalKey = this.keyConverter.toInternal(key);
                    if (!this.entries.containsKey(internalKey)) continue;
                    cachedValue = this.entries.remove(internalKey);
                    deletedKeys.add(key);
                    value = this.valueConverter.fromInternal(cachedValue.get());
                    if (cachedValue.isExpiredAt(now)) {
                        this.processExpiries(key, dispatcher, value);
                        continue;
                    }
                    dispatcher.addEvent(CacheEntryRemovedListener.class, new CarbonCacheEntryEvent<K, V>(this, key, value, EventType.REMOVED));
                }
            }
            if (this.statisticsEnabled()) {
                this.statistics.increaseCacheRemovals(deletedKeys.size());
            }
        }
        finally {
            for (Object key : lockedKeys) {
                this.lockManager.unLock(key);
            }
        }
        dispatcher.dispatch(this.listenerRegistrations);
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() {
        this.ensureOpen();
        int size = 0;
        long now = System.currentTimeMillis();
        CacheWriterException exception = null;
        HashSet<K> lockedKeys = new HashSet<K>();
        CarbonCacheEventDispatcher<Object, V> dispatcher = new CarbonCacheEventDispatcher<Object, V>();
        try {
            Object internalKey;
            HashSet<K> keysToDelete;
            block12: {
                boolean isWriteThrough = this.configuration.isWriteThrough() && this.cacheWriter != null;
                keysToDelete = new HashSet<K>();
                for (Map.Entry entry : this.entries) {
                    internalKey = entry.getKey();
                    K key = this.keyConverter.fromInternal(internalKey);
                    this.lockManager.lock(key);
                    lockedKeys.add(key);
                    if (!isWriteThrough) continue;
                    keysToDelete.add(key);
                }
                if (isWriteThrough && keysToDelete.size() > 0) {
                    try {
                        this.cacheWriter.deleteAll(keysToDelete);
                    }
                    catch (Exception e) {
                        if (e instanceof CacheWriterException) break block12;
                        exception = new CacheWriterException("Exception during write", e);
                    }
                }
            }
            for (Object object : lockedKeys) {
                if (keysToDelete.contains(object)) continue;
                internalKey = this.keyConverter.toInternal(object);
                CarbonCachedValue cachedValue = this.entries.remove(internalKey);
                V value = this.valueConverter.fromInternal(cachedValue.get());
                if (cachedValue.isExpiredAt(now)) {
                    this.processExpiries(object, dispatcher, value);
                    continue;
                }
                dispatcher.addEvent(CacheEntryRemovedListener.class, new CarbonCacheEntryEvent<Object, V>(this, object, value, EventType.REMOVED));
                ++size;
            }
        }
        finally {
            for (Object key : lockedKeys) {
                this.lockManager.unLock(key);
            }
        }
        dispatcher.dispatch(this.listenerRegistrations);
        if (this.statisticsEnabled()) {
            this.statistics.increaseCacheRemovals(size);
        }
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.ensureOpen();
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object internalKey = entry.getKey();
            K key = this.keyConverter.fromInternal(internalKey);
            this.lockManager.lock(key);
            try {
                iterator.remove();
            }
            finally {
                this.lockManager.unLock(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        this.ensureOpen();
        if (key == null) {
            throw new NullPointerException();
        }
        if (entryProcessor == null) {
            throw new NullPointerException();
        }
        long start = this.statisticsEnabled() ? System.nanoTime() : 0L;
        T result = null;
        this.lockManager.lock(key);
        try {
            boolean isExpired;
            long now = System.currentTimeMillis();
            CarbonCacheEventDispatcher<K, V> dispatcher = new CarbonCacheEventDispatcher<K, V>();
            Object internalKey = this.keyConverter.toInternal(key);
            CarbonCachedValue cachedValue = this.entries.get(internalKey);
            boolean bl = isExpired = cachedValue != null && cachedValue.isExpiredAt(now);
            if (isExpired) {
                V expiredValue = this.valueConverter.fromInternal(cachedValue.get());
                this.processExpiries(key, dispatcher, expiredValue);
            }
            if (this.statisticsEnabled()) {
                if (cachedValue == null || isExpired) {
                    this.statistics.increaseCacheMisses(1L);
                } else {
                    this.statistics.increaseCacheHits(1L);
                }
            }
            if (this.statisticsEnabled()) {
                this.statistics.addGetTimeNano(System.nanoTime() - start);
            }
            start = this.statisticsEnabled() ? System.nanoTime() : 0L;
            EntryProcessorEntry<K, V> entry = new EntryProcessorEntry<K, V>(this.valueConverter, key, cachedValue, now, this.configuration.isReadThrough() ? this.cacheLoader : null);
            try {
                result = entryProcessor.process(entry, arguments);
            }
            catch (CacheException e) {
                throw e;
            }
            catch (Exception e) {
                throw new EntryProcessorException(e);
            }
            switch (entry.getOperation()) {
                case NONE: {
                    break;
                }
                case ACCESS: {
                    try {
                        Duration duration = this.expiryPolicy.getExpiryForAccess();
                        if (duration == null) break;
                        long expiryTime1 = duration.getAdjustedTime(now);
                        cachedValue.setExpiryTime(expiryTime1);
                    }
                    catch (Throwable expiryTime1) {}
                    break;
                }
                case CREATE: 
                case LOAD: {
                    Duration duration;
                    CarbonCacheEntry<K, V> e = new CarbonCacheEntry<K, V>(key, entry.getValue());
                    if (entry.getOperation() == MutableEntryOperation.CREATE) {
                        this.writeCacheEntry(e);
                    }
                    try {
                        duration = this.expiryPolicy.getExpiryForCreation();
                    }
                    catch (Throwable t) {
                        duration = this.getDefaultDuration();
                    }
                    long expiryTime = duration.getAdjustedTime(now);
                    cachedValue = new CarbonCachedValue(this.valueConverter.toInternal(entry.getValue()), now, expiryTime);
                    if (cachedValue.isExpiredAt(now)) {
                        V previousValue = this.valueConverter.fromInternal(cachedValue.get());
                        this.processExpiries(key, dispatcher, previousValue);
                        break;
                    }
                    this.entries.put(internalKey, cachedValue);
                    dispatcher.addEvent(CacheEntryCreatedListener.class, new CarbonCacheEntryEvent<K, V>(this, key, entry.getValue(), EventType.CREATED));
                    if (!this.statisticsEnabled() || entry.getOperation() != MutableEntryOperation.CREATE) break;
                    this.statistics.increaseCachePuts(1L);
                    this.statistics.addPutTimeNano(System.nanoTime() - start);
                    break;
                }
                case UPDATE: {
                    V oldValue = this.valueConverter.fromInternal(cachedValue.get());
                    CarbonCacheEntry<K, V> e = new CarbonCacheEntry<K, V>(key, entry.getValue(), oldValue);
                    this.writeCacheEntry(e);
                    try {
                        Duration duration = this.expiryPolicy.getExpiryForUpdate();
                        if (duration != null) {
                            long expiryTime = duration.getAdjustedTime(now);
                            cachedValue.setExpiryTime(expiryTime);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    cachedValue.setInternalValue(this.valueConverter.toInternal(entry.getValue()), now);
                    dispatcher.addEvent(CacheEntryUpdatedListener.class, new CarbonCacheEntryEvent<K, V>(this, key, entry.getValue(), oldValue, EventType.UPDATED));
                    if (!this.statisticsEnabled()) break;
                    this.statistics.increaseCachePuts(1L);
                    this.statistics.addPutTimeNano(System.nanoTime() - start);
                    break;
                }
                case REMOVE: {
                    this.deleteCacheEntry(key);
                    Object oldValue = cachedValue == null ? null : (Object)this.valueConverter.fromInternal(cachedValue.get());
                    this.entries.remove(internalKey);
                    dispatcher.addEvent(CacheEntryRemovedListener.class, new CarbonCacheEntryEvent<K, Object>(this, key, oldValue, EventType.REMOVED));
                    if (!this.statisticsEnabled()) break;
                    this.statistics.increaseCacheRemovals(1L);
                    this.statistics.addRemoveTimeNano(System.nanoTime() - start);
                    break;
                }
            }
            dispatcher.dispatch(this.listenerRegistrations);
        }
        finally {
            this.lockManager.unLock(key);
        }
        return result;
    }

    @Override
    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        this.ensureOpen();
        if (keys == null) {
            throw new NullPointerException();
        }
        if (entryProcessor == null) {
            throw new NullPointerException();
        }
        HashMap<K, CarbonEntryProcessorResult<T>> map = new HashMap<K, CarbonEntryProcessorResult<T>>();
        for (K key : keys) {
            CarbonEntryProcessorResult<T> result = null;
            try {
                T t = this.invoke(key, entryProcessor, arguments);
                result = t == null ? null : new CarbonEntryProcessorResult<T>(t);
            }
            catch (Exception e) {
                result = new CarbonEntryProcessorResult<T>(e);
            }
            if (result == null) continue;
            map.put(key, result);
        }
        return map;
    }

    @Override
    public Iterator<Cache.Entry<K, V>> iterator() {
        this.ensureOpen();
        long now = System.currentTimeMillis();
        return new RIEntryIterator(this.entries.iterator(), now);
    }

    public CacheMXBean getCacheMXBean() {
        return this.cacheMXBean;
    }

    public CacheStatisticsMXBean getCacheStatisticsMXBean() {
        return this.statistics;
    }

    public void setStatisticsEnabled(boolean enabled) {
        if (enabled) {
            MBeanServerRegistrationUtility.registerCacheObject(this, MBeanServerRegistrationUtility.ObjectNameType.Statistics);
        } else {
            MBeanServerRegistrationUtility.unregisterCacheObject(this, MBeanServerRegistrationUtility.ObjectNameType.Statistics);
        }
        this.configuration.setStatisticsEnabled(enabled);
    }

    public void setManagementEnabled(boolean enabled) {
        if (enabled) {
            MBeanServerRegistrationUtility.registerCacheObject(this, MBeanServerRegistrationUtility.ObjectNameType.Configuration);
        } else {
            MBeanServerRegistrationUtility.unregisterCacheObject(this, MBeanServerRegistrationUtility.ObjectNameType.Configuration);
        }
        this.configuration.setManagementEnabled(enabled);
    }

    private void ensureOpen() {
        if (this.isClosed()) {
            throw new IllegalStateException("Cache operations can not be performed. The cache closed");
        }
    }

    @Override
    public <T> T unwrap(Class<T> cls) {
        if (cls.isAssignableFrom(this.getClass())) {
            return cls.cast(this);
        }
        throw new IllegalArgumentException("Unwrapping to " + cls + " is not " + "supported by this implementation");
    }

    @Override
    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.configuration.addCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
        this.createAndAddListener(cacheEntryListenerConfiguration);
    }

    @Override
    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.removeListener(cacheEntryListenerConfiguration);
    }

    private boolean statisticsEnabled() {
        return this.getConfiguration(CompleteConfiguration.class).isStatisticsEnabled();
    }

    private void writeCacheEntry(CarbonCacheEntry<K, V> entry) {
        if (this.configuration.isWriteThrough()) {
            try {
                this.cacheWriter.write(entry);
            }
            catch (Exception e) {
                if (!(e instanceof CacheWriterException)) {
                    throw new CacheWriterException("Exception in CacheWriter", e);
                }
                throw e;
            }
        }
    }

    private void deleteCacheEntry(K key) {
        if (this.configuration.isWriteThrough()) {
            try {
                this.cacheWriter.delete(key);
            }
            catch (Exception e) {
                if (!(e instanceof CacheWriterException)) {
                    throw new CacheWriterException("Exception in CacheWriter", e);
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V getValue(K key, CarbonCacheEventDispatcher<K, V> dispatcher) {
        Object value;
        block21: {
            long now = System.currentTimeMillis();
            long start = this.statisticsEnabled() ? System.nanoTime() : 0L;
            Object internalKey = this.keyConverter.toInternal(key);
            CarbonCachedValue cachedValue = null;
            value = null;
            this.lockManager.lock(key);
            try {
                boolean isExpired;
                cachedValue = this.entries.get(internalKey);
                boolean bl = isExpired = cachedValue != null && cachedValue.isExpiredAt(now);
                if (cachedValue == null || isExpired) {
                    Duration duration;
                    V expiredValue;
                    V v = expiredValue = isExpired ? (V)this.valueConverter.fromInternal(cachedValue.get()) : null;
                    if (isExpired) {
                        this.processExpiries(key, dispatcher, expiredValue);
                    }
                    if (this.statisticsEnabled()) {
                        this.statistics.increaseCacheMisses(1L);
                    }
                    if (this.configuration.isReadThrough() && this.cacheLoader != null) {
                        try {
                            value = this.cacheLoader.load(key);
                        }
                        catch (Exception e) {
                            if (!(e instanceof CacheLoaderException)) {
                                throw new CacheLoaderException("Exception in CacheLoader", e);
                            }
                            throw e;
                        }
                    }
                    if (value == null) {
                        V e = null;
                        return e;
                    }
                    try {
                        duration = this.expiryPolicy.getExpiryForCreation();
                    }
                    catch (Throwable t) {
                        duration = this.getDefaultDuration();
                    }
                    long expiryTime = duration.getAdjustedTime(now);
                    Object internalValue = this.valueConverter.toInternal(value);
                    cachedValue = new CarbonCachedValue(internalValue, now, expiryTime);
                    if (cachedValue.isExpiredAt(now)) {
                        V v2 = null;
                        return v2;
                    }
                    this.entries.put(internalKey, cachedValue);
                    dispatcher.addEvent(CacheEntryCreatedListener.class, new CarbonCacheEntryEvent<K, Object>(this, key, value, EventType.CREATED));
                    break block21;
                }
                value = this.valueConverter.fromInternal(cachedValue.getInternalValue(now));
                try {
                    Duration duration = this.expiryPolicy.getExpiryForAccess();
                    if (duration != null) {
                        long expiryTime = duration.getAdjustedTime(now);
                        cachedValue.setExpiryTime(expiryTime);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (this.statisticsEnabled()) {
                    this.statistics.increaseCacheHits(1L);
                }
            }
            finally {
                this.lockManager.unLock(key);
                if (this.statisticsEnabled()) {
                    this.statistics.addGetTimeNano(System.nanoTime() - start);
                }
            }
        }
        return value;
    }

    public long getSize() {
        return this.entries.size();
    }

    private final class RIEntryIterator
    implements Iterator<Cache.Entry<K, V>> {
        private final Iterator<Map.Entry<Object, CarbonCachedValue>> iterator;
        private CarbonCacheEntry<K, V> nextEntry;
        private CarbonCacheEntry<K, V> lastEntry;
        private long now;

        private RIEntryIterator(Iterator<Map.Entry<Object, CarbonCachedValue>> iterator, long now) {
            this.iterator = iterator;
            this.nextEntry = null;
            this.lastEntry = null;
            this.now = now;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fetch() {
            long start;
            long l = start = CarbonCache.this.statisticsEnabled() ? System.nanoTime() : 0L;
            while (this.nextEntry == null && this.iterator.hasNext()) {
                Map.Entry<Object, CarbonCachedValue> entry = this.iterator.next();
                CarbonCachedValue cachedValue = entry.getValue();
                Object key = CarbonCache.this.keyConverter.fromInternal(entry.getKey());
                CarbonCache.this.lockManager.lock(key);
                try {
                    if (cachedValue.isExpiredAt(this.now)) continue;
                    Object value = CarbonCache.this.valueConverter.fromInternal(cachedValue.getInternalValue(this.now));
                    this.nextEntry = new CarbonCacheEntry(key, value);
                    try {
                        Duration duration = CarbonCache.this.expiryPolicy.getExpiryForAccess();
                        if (duration == null) continue;
                        long expiryTime = duration.getAdjustedTime(this.now);
                        cachedValue.setExpiryTime(expiryTime);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                finally {
                    CarbonCache.this.lockManager.unLock(key);
                    if (!CarbonCache.this.statisticsEnabled() || this.nextEntry == null) continue;
                    CarbonCache.this.statistics.increaseCacheHits(1L);
                    CarbonCache.this.statistics.addGetTimeNano(System.nanoTime() - start);
                }
            }
        }

        @Override
        public boolean hasNext() {
            if (this.nextEntry == null) {
                this.fetch();
            }
            return this.nextEntry != null;
        }

        @Override
        public Cache.Entry<K, V> next() {
            if (this.hasNext()) {
                this.lastEntry = this.nextEntry;
                this.nextEntry = null;
                return this.lastEntry;
            }
            throw new NoSuchElementException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            int cacheRemovals = 0;
            if (this.lastEntry == null) {
                throw new IllegalStateException("Must progress to the next entry to remove");
            }
            long start = CarbonCache.this.statisticsEnabled() ? System.nanoTime() : 0L;
            CarbonCache.this.lockManager.lock(this.lastEntry.getKey());
            try {
                CarbonCache.this.deleteCacheEntry(this.lastEntry.getKey());
                this.iterator.remove();
                ++cacheRemovals;
                CarbonCacheEventDispatcher dispatcher = new CarbonCacheEventDispatcher();
                dispatcher.addEvent(CacheEntryRemovedListener.class, new CarbonCacheEntryEvent(CarbonCache.this, this.lastEntry.getKey(), this.lastEntry.getValue(), EventType.REMOVED));
                dispatcher.dispatch(CarbonCache.this.listenerRegistrations);
            }
            finally {
                CarbonCache.this.lockManager.unLock(this.lastEntry.getKey());
                this.lastEntry = null;
                if (CarbonCache.this.statisticsEnabled() && cacheRemovals > 0) {
                    CarbonCache.this.statistics.increaseCacheRemovals(cacheRemovals);
                    CarbonCache.this.statistics.addRemoveTimeNano(System.nanoTime() - start);
                }
            }
        }
    }
}

