/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.internal;

import javax.cache.Cache;

public class CarbonCacheEntry<K, V>
implements Cache.Entry<K, V> {
    private final K key;
    private final V value;
    private final V oldValue;

    public CarbonCacheEntry(K key, V value) {
        this.key = key;
        this.value = value;
        this.oldValue = null;
    }

    public CarbonCacheEntry(K key, V value, V oldValue) {
        this.key = key;
        this.value = value;
        this.oldValue = oldValue;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    public V getOldValue() {
        return this.oldValue;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz != null && clazz.isInstance(this)) {
            return (T)this;
        }
        throw new IllegalArgumentException("Class " + clazz + " is unknown to this implementation");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CarbonCacheEntry e2 = (CarbonCacheEntry)o;
        return this.getKey().equals(e2.getKey()) && this.getValue().equals(e2.getValue()) && (this.oldValue == null && e2.oldValue == null || this.getOldValue().equals(e2.getOldValue()));
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }
}

