/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.internal;

import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.spi.CachingProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.caching.internal.CarbonCache;
import org.wso2.carbon.caching.spi.CarbonCachingProvider;

public class CarbonCacheManager
implements CacheManager {
    private static final Logger log = LoggerFactory.getLogger((String)"javax.cache");
    private final HashMap<String, CarbonCache<?, ?>> caches = new HashMap();
    private final CarbonCachingProvider cachingProvider;
    private final URI uri;
    private final WeakReference<ClassLoader> classLoaderReference;
    private final Properties properties;
    private volatile boolean isClosed;

    public CarbonCacheManager(CarbonCachingProvider cachingProvider, URI uri, ClassLoader classLoader, Properties properties) {
        this.cachingProvider = cachingProvider;
        if (uri == null) {
            throw new NullPointerException("No CacheManager URI specified");
        }
        this.uri = uri;
        if (classLoader == null) {
            throw new NullPointerException("No ClassLoader specified");
        }
        this.classLoaderReference = new WeakReference<ClassLoader>(classLoader);
        this.properties = properties == null ? new Properties() : new Properties(properties);
        this.isClosed = false;
    }

    @Override
    public CachingProvider getCachingProvider() {
        return this.cachingProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        if (!this.isClosed()) {
            ArrayList cacheList;
            this.cachingProvider.releaseCacheManager(this.getURI(), this.getClassLoader());
            this.isClosed = true;
            HashMap<String, CarbonCache<?, ?>> hashMap = this.caches;
            synchronized (hashMap) {
                cacheList = new ArrayList(this.caches.values());
                this.caches.clear();
            }
            for (Cache cache : cacheList) {
                try {
                    cache.close();
                }
                catch (Exception e) {
                    log.warn("Error stopping cache: " + cache, (Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public ClassLoader getClassLoader() {
        return (ClassLoader)this.classLoaderReference.get();
    }

    @Override
    public <K, V, C extends Configuration<K, V>> Cache<K, V> createCache(String cacheName, C configuration) {
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
        if (cacheName == null) {
            throw new NullPointerException("cacheName must not be null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration must not be null");
        }
        HashMap<String, CarbonCache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            CarbonCache<Object, Object> cache = this.caches.get(cacheName);
            if (cache == null) {
                cache = new CarbonCache(this, cacheName, this.getClassLoader(), configuration);
                this.caches.put(cache.getName(), cache);
                return cache;
            }
            throw new CacheException("A cache named " + cacheName + " already exists.");
        }
    }

    @Override
    public <K, V> Cache<K, V> getCache(String cacheName, Class<K> keyType, Class<V> valueType) {
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
        if (keyType == null) {
            throw new NullPointerException("keyType can not be null");
        }
        if (valueType == null) {
            throw new NullPointerException("valueType can not be null");
        }
        HashMap<String, CarbonCache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            CarbonCache<?, ?> cache = this.caches.get(cacheName);
            if (cache == null) {
                return null;
            }
            CompleteConfiguration configuration = cache.getConfiguration(CompleteConfiguration.class);
            if (configuration.getKeyType() != null && configuration.getKeyType().equals(keyType)) {
                if (configuration.getValueType() != null && configuration.getValueType().equals(valueType)) {
                    return cache;
                }
                throw new ClassCastException("Incompatible cache value types specified, expected " + configuration.getValueType() + " but " + valueType + " was specified");
            }
            throw new ClassCastException("Incompatible cache key types specified, expected " + configuration.getKeyType() + " but " + keyType + " was specified");
        }
    }

    public Cache getCache(String cacheName) {
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
        HashMap<String, CarbonCache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            CarbonCache<?, ?> cache = this.caches.get(cacheName);
            if (cache == null) {
                return null;
            }
            CompleteConfiguration configuration = cache.getConfiguration(CompleteConfiguration.class);
            if (configuration.getKeyType().equals(Object.class) && configuration.getValueType().equals(Object.class)) {
                return cache;
            }
            throw new IllegalArgumentException("Cache " + cacheName + " was " + "defined with specific types Cache<" + configuration.getKeyType() + ", " + configuration.getValueType() + "> " + "in which case CacheManager.getCache(String, Class, Class) must be used");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<String> getCacheNames() {
        HashMap<String, CarbonCache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            HashSet<String> set = new HashSet<String>();
            for (Cache cache : this.caches.values()) {
                set.add(cache.getName());
            }
            return Collections.unmodifiableSet(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyCache(String cacheName) {
        Cache cache;
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
        if (cacheName == null) {
            throw new NullPointerException();
        }
        HashMap<String, CarbonCache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            cache = this.caches.get(cacheName);
        }
        if (cache != null) {
            cache.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseCache(String cacheName) {
        if (cacheName == null) {
            throw new NullPointerException();
        }
        HashMap<String, CarbonCache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            this.caches.remove(cacheName);
        }
    }

    @Override
    public void enableStatistics(String cacheName, boolean enabled) {
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
        if (cacheName == null) {
            throw new NullPointerException();
        }
        this.caches.get(cacheName).setStatisticsEnabled(enabled);
    }

    @Override
    public void enableManagement(String cacheName, boolean enabled) {
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
        if (cacheName == null) {
            throw new NullPointerException();
        }
        this.caches.get(cacheName).setManagementEnabled(enabled);
    }

    @Override
    public <T> T unwrap(Class<T> cls) {
        if (cls.isAssignableFrom(this.getClass())) {
            return cls.cast(this);
        }
        throw new IllegalArgumentException("Unwapping to " + cls + " is not a supported by this implementation");
    }
}

