/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.internal.event;

import javax.cache.Cache;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.EventType;

public class CarbonCacheEntryEvent<K, V>
extends CacheEntryEvent<K, V> {
    private static final long serialVersionUID = -3129026929246835839L;
    private K key;
    private V value;
    private V oldValue;
    private boolean oldValueAvailable;

    public CarbonCacheEntryEvent(Cache<K, V> source, K key, V value, EventType eventType) {
        super(source, eventType);
        this.key = key;
        this.value = value;
        this.oldValue = null;
        this.oldValueAvailable = false;
    }

    public CarbonCacheEntryEvent(Cache<K, V> source, K key, V value, V oldValue, EventType eventType) {
        super(source, eventType);
        this.key = key;
        this.value = value;
        this.oldValue = oldValue;
        this.oldValueAvailable = true;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public V getOldValue() throws UnsupportedOperationException {
        if (this.isOldValueAvailable()) {
            return this.oldValue;
        }
        throw new UnsupportedOperationException("Old value is not available for key");
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz != null && clazz.isInstance(this)) {
            return (T)this;
        }
        throw new IllegalArgumentException("The class " + clazz + " is unknown to this implementation");
    }

    @Override
    public boolean isOldValueAvailable() {
        return this.oldValueAvailable;
    }
}

