/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.internal.event;

import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryListener;

public class CarbonCacheEntryListenerRegistration<K, V> {
    private final CacheEntryListenerConfiguration<K, V> configuration;
    private CacheEntryListener<? super K, ? super V> listener;
    private CacheEntryEventFilter<? super K, ? super V> filter;
    private boolean isOldValueRequired;
    private boolean isSynchronous;

    public CarbonCacheEntryListenerRegistration(CacheEntryListenerConfiguration<K, V> configuration) {
        this.configuration = configuration;
        this.listener = configuration.getCacheEntryListenerFactory().create();
        this.filter = configuration.getCacheEntryEventFilterFactory() == null ? null : configuration.getCacheEntryEventFilterFactory().create();
        this.isOldValueRequired = configuration.isOldValueRequired();
        this.isSynchronous = configuration.isSynchronous();
    }

    public CacheEntryListener<? super K, ? super V> getCacheEntryListener() {
        return this.listener;
    }

    public CacheEntryEventFilter<? super K, ? super V> getCacheEntryFilter() {
        return this.filter;
    }

    public boolean isOldValueRequired() {
        return this.isOldValueRequired;
    }

    public boolean isSynchronous() {
        return this.isSynchronous;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filter == null ? 0 : this.filter.hashCode());
        result = 31 * result + (this.isOldValueRequired ? 1231 : 1237);
        result = 31 * result + (this.isSynchronous ? 1231 : 1237);
        result = 31 * result + (this.listener == null ? 0 : this.listener.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof CarbonCacheEntryListenerRegistration)) {
            return false;
        }
        CarbonCacheEntryListenerRegistration other = (CarbonCacheEntryListenerRegistration)object;
        if (this.filter == null ? other.filter != null : !this.filter.equals(other.filter)) {
            return false;
        }
        if (this.isOldValueRequired != other.isOldValueRequired) {
            return false;
        }
        if (this.isSynchronous != other.isSynchronous) {
            return false;
        }
        return !(this.listener == null ? other.listener != null : !this.listener.equals(other.listener));
    }

    public CacheEntryListenerConfiguration<K, V> getConfiguration() {
        return this.configuration;
    }
}

