/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.internal.event;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import org.wso2.carbon.caching.internal.event.CarbonCacheEntryEventFilteringIterable;
import org.wso2.carbon.caching.internal.event.CarbonCacheEntryListenerRegistration;

public class CarbonCacheEventDispatcher<K, V> {
    private ConcurrentHashMap<Class<? extends CacheEntryListener>, ArrayList<CacheEntryEvent<K, V>>> eventMap = new ConcurrentHashMap();

    public void addEvent(Class<? extends CacheEntryListener> listenerClass, CacheEntryEvent<K, V> event) {
        if (listenerClass == null) {
            throw new NullPointerException("listenerClass can't be null");
        }
        if (event == null) {
            throw new NullPointerException("event can't be null");
        }
        if (!listenerClass.isInterface() || !CacheEntryListener.class.isAssignableFrom(listenerClass)) {
            throw new IllegalArgumentException("listenerClass must be an CacheEntryListener interface");
        }
        this.eventMap.putIfAbsent(listenerClass, new ArrayList());
        this.eventMap.get(listenerClass).add(event);
    }

    public void dispatch(Iterable<CarbonCacheEntryListenerRegistration<K, V>> registrations) {
        CacheEntryListener<K, V> listener;
        Iterable iterable;
        CacheEntryEventFilter<K, V> filter;
        Iterable events = this.eventMap.get(CacheEntryExpiredListener.class);
        if (events != null) {
            for (CarbonCacheEntryListenerRegistration<K, V> registration : registrations) {
                filter = registration.getCacheEntryFilter();
                Iterable iterable2 = iterable = filter == null ? events : new CarbonCacheEntryEventFilteringIterable<K, V>(events, filter);
                listener = registration.getCacheEntryListener();
                if (!(listener instanceof CacheEntryExpiredListener)) continue;
                ((CacheEntryExpiredListener)listener).onExpired(iterable);
            }
        }
        if ((events = (Iterable)this.eventMap.get(CacheEntryCreatedListener.class)) != null) {
            for (CarbonCacheEntryListenerRegistration<K, V> registration : registrations) {
                filter = registration.getCacheEntryFilter();
                Iterable iterable3 = iterable = filter == null ? events : new CarbonCacheEntryEventFilteringIterable<K, V>(events, filter);
                listener = registration.getCacheEntryListener();
                if (!(listener instanceof CacheEntryCreatedListener)) continue;
                ((CacheEntryCreatedListener)listener).onCreated(iterable);
            }
        }
        if ((events = (Iterable)this.eventMap.get(CacheEntryUpdatedListener.class)) != null) {
            for (CarbonCacheEntryListenerRegistration<K, V> registration : registrations) {
                filter = registration.getCacheEntryFilter();
                Iterable iterable4 = iterable = filter == null ? events : new CarbonCacheEntryEventFilteringIterable<K, V>(events, filter);
                listener = registration.getCacheEntryListener();
                if (!(listener instanceof CacheEntryUpdatedListener)) continue;
                ((CacheEntryUpdatedListener)listener).onUpdated(iterable);
            }
        }
        if ((events = (Iterable)this.eventMap.get(CacheEntryRemovedListener.class)) != null) {
            for (CarbonCacheEntryListenerRegistration<K, V> registration : registrations) {
                filter = registration.getCacheEntryFilter();
                Iterable iterable5 = iterable = filter == null ? events : new CarbonCacheEntryEventFilteringIterable<K, V>(events, filter);
                listener = registration.getCacheEntryListener();
                if (!(listener instanceof CacheEntryRemovedListener)) continue;
                ((CacheEntryRemovedListener)listener).onRemoved(iterable);
            }
        }
    }
}

