/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.internal.processor;

import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import javax.cache.processor.MutableEntry;
import org.wso2.carbon.caching.internal.CarbonCachedValue;
import org.wso2.carbon.caching.internal.InternalConverter;
import org.wso2.carbon.caching.internal.processor.MutableEntryOperation;

public class EntryProcessorEntry<K, V>
implements MutableEntry<K, V> {
    private final K key;
    private final CarbonCachedValue cachedValue;
    private final InternalConverter<V> converter;
    private V value;
    private MutableEntryOperation operation;
    private long now;
    private CacheLoader<K, V> cacheLoader;

    public EntryProcessorEntry(InternalConverter<V> converter, K key, CarbonCachedValue cachedValue, long now, CacheLoader<K, V> cacheLoader) {
        this.converter = converter;
        this.key = key;
        this.cachedValue = cachedValue;
        this.operation = MutableEntryOperation.NONE;
        this.value = null;
        this.now = now;
        this.cacheLoader = cacheLoader;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        if (this.operation == MutableEntryOperation.NONE) {
            if (this.cachedValue == null || this.cachedValue.isExpiredAt(this.now)) {
                this.value = null;
            } else if (this.value == null) {
                Object internalValue = this.cachedValue.getInternalValue(this.now);
                this.value = internalValue == null ? null : this.converter.fromInternal(internalValue);
                Object v0 = this.value;
            }
        }
        if (this.value != null) {
            if (this.operation == MutableEntryOperation.NONE) {
                this.operation = MutableEntryOperation.ACCESS;
            }
        } else if (this.cacheLoader != null) {
            try {
                this.value = this.cacheLoader.load(this.key);
                if (this.value != null) {
                    this.operation = MutableEntryOperation.LOAD;
                }
            }
            catch (Exception e) {
                if (!(e instanceof CacheLoaderException)) {
                    throw new CacheLoaderException("Exception in CacheLoader", e);
                }
                throw e;
            }
        }
        return this.value;
    }

    @Override
    public void setValue(V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.operation = this.cachedValue == null || this.cachedValue.isExpiredAt(this.now) ? MutableEntryOperation.CREATE : MutableEntryOperation.UPDATE;
        this.value = value;
    }

    @Override
    public boolean exists() {
        return this.operation == MutableEntryOperation.NONE && this.cachedValue != null && !this.cachedValue.isExpiredAt(this.now) || this.value != null;
    }

    @Override
    public void remove() {
        this.operation = this.operation == MutableEntryOperation.CREATE || this.operation == MutableEntryOperation.LOAD ? MutableEntryOperation.NONE : MutableEntryOperation.REMOVE;
        this.value = null;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        throw new IllegalArgumentException("Can't unwrap an EntryProcessor Entry");
    }

    public MutableEntryOperation getOperation() {
        return this.operation;
    }
}

