/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.spi;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.OptionalFeature;
import javax.cache.spi.CachingProvider;
import org.wso2.carbon.caching.internal.CarbonCacheManager;

public class CarbonCachingProvider
implements CachingProvider {
    private WeakHashMap<ClassLoader, HashMap<URI, CacheManager>> cacheManagersByClassLoader = new WeakHashMap();

    @Override
    public synchronized CacheManager getCacheManager(URI uri, ClassLoader classLoader, Properties properties) {
        CacheManager cacheManager;
        URI managerURI = uri == null ? this.getDefaultURI() : uri;
        ClassLoader managerClassLoader = classLoader == null ? this.getDefaultClassLoader() : classLoader;
        Properties managerProperties = properties == null ? new Properties() : properties;
        HashMap<URI, CacheManager> cacheManagersByURI = this.cacheManagersByClassLoader.get(managerClassLoader);
        if (cacheManagersByURI == null) {
            cacheManagersByURI = new HashMap();
        }
        if ((cacheManager = cacheManagersByURI.get(managerURI)) == null) {
            cacheManager = new CarbonCacheManager(this, managerURI, managerClassLoader, managerProperties);
            cacheManagersByURI.put(managerURI, cacheManager);
        }
        if (!this.cacheManagersByClassLoader.containsKey(managerClassLoader)) {
            this.cacheManagersByClassLoader.put(managerClassLoader, cacheManagersByURI);
        }
        return cacheManager;
    }

    @Override
    public CacheManager getCacheManager(URI uri, ClassLoader classLoader) {
        return this.getCacheManager(uri, classLoader, this.getDefaultProperties());
    }

    @Override
    public CacheManager getCacheManager() {
        return this.getCacheManager(this.getDefaultURI(), this.getDefaultClassLoader(), null);
    }

    @Override
    public ClassLoader getDefaultClassLoader() {
        return this.getClass().getClassLoader();
    }

    @Override
    public URI getDefaultURI() {
        try {
            return new URI(this.getClass().getName());
        }
        catch (URISyntaxException e) {
            throw new CacheException("Failed to create the default URI for the javax.cache Reference Implementation", e);
        }
    }

    @Override
    public Properties getDefaultProperties() {
        return null;
    }

    @Override
    public synchronized void close() {
        WeakHashMap<ClassLoader, HashMap<URI, CacheManager>> managersByClassLoader = this.cacheManagersByClassLoader;
        this.cacheManagersByClassLoader = new WeakHashMap();
        for (Map.Entry<ClassLoader, HashMap<URI, CacheManager>> entry : managersByClassLoader.entrySet()) {
            entry.getValue().values().forEach(CacheManager::close);
        }
    }

    @Override
    public synchronized void close(ClassLoader classLoader) {
        ClassLoader managerClassLoader = classLoader == null ? this.getDefaultClassLoader() : classLoader;
        HashMap<URI, CacheManager> cacheManagersByURI = this.cacheManagersByClassLoader.remove(managerClassLoader);
        if (cacheManagersByURI != null) {
            cacheManagersByURI.values().forEach(CacheManager::close);
        }
    }

    @Override
    public synchronized void close(URI uri, ClassLoader classLoader) {
        URI managerURI = uri == null ? this.getDefaultURI() : uri;
        ClassLoader managerClassLoader = classLoader == null ? this.getDefaultClassLoader() : classLoader;
        HashMap<URI, CacheManager> cacheManagersByURI = this.cacheManagersByClassLoader.get(managerClassLoader);
        if (cacheManagersByURI != null) {
            CacheManager cacheManager = cacheManagersByURI.remove(managerURI);
            if (cacheManager != null) {
                cacheManager.close();
            }
            if (cacheManagersByURI.size() == 0) {
                this.cacheManagersByClassLoader.remove(managerClassLoader);
            }
        }
    }

    public synchronized void releaseCacheManager(URI uri, ClassLoader classLoader) {
        URI managerURI = uri == null ? this.getDefaultURI() : uri;
        ClassLoader managerClassLoader = classLoader == null ? this.getDefaultClassLoader() : classLoader;
        HashMap<URI, CacheManager> cacheManagersByURI = this.cacheManagersByClassLoader.get(managerClassLoader);
        if (cacheManagersByURI != null) {
            cacheManagersByURI.remove(managerURI);
            if (cacheManagersByURI.size() == 0) {
                this.cacheManagersByClassLoader.remove(managerClassLoader);
            }
        }
    }

    @Override
    public boolean isSupported(OptionalFeature optionalFeature) {
        switch (optionalFeature) {
            case STORE_BY_REFERENCE: {
                return true;
            }
        }
        return false;
    }
}

