/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.builder.admin.internal;

import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.event.builder.admin.exception.EventBuilderAdminServiceException;
import org.wso2.carbon.event.builder.admin.internal.EventBuilderConfigurationDto;
import org.wso2.carbon.event.builder.admin.internal.EventBuilderConfigurationFileDto;
import org.wso2.carbon.event.builder.admin.internal.EventBuilderConfigurationInfoDto;
import org.wso2.carbon.event.builder.admin.internal.EventBuilderMessagePropertyDto;
import org.wso2.carbon.event.builder.admin.internal.EventInputPropertyConfigurationDto;
import org.wso2.carbon.event.builder.admin.internal.PropertyDto;
import org.wso2.carbon.event.builder.admin.internal.ds.EventBuilderAdminServiceValueHolder;
import org.wso2.carbon.event.builder.admin.internal.util.DtoConverter;
import org.wso2.carbon.event.builder.admin.internal.util.DtoConverterFactory;
import org.wso2.carbon.event.builder.admin.internal.util.dto.converter.JsonDtoConverter;
import org.wso2.carbon.event.builder.admin.internal.util.dto.converter.MapDtoConverter;
import org.wso2.carbon.event.builder.admin.internal.util.dto.converter.TextDtoConverter;
import org.wso2.carbon.event.builder.admin.internal.util.dto.converter.Wso2EventDtoConverter;
import org.wso2.carbon.event.builder.admin.internal.util.dto.converter.XmlDtoConverter;
import org.wso2.carbon.event.builder.core.EventBuilderService;
import org.wso2.carbon.event.builder.core.config.EventBuilderConfiguration;
import org.wso2.carbon.event.builder.core.exception.EventBuilderConfigurationException;
import org.wso2.carbon.event.builder.core.internal.config.EventBuilderConfigurationFile;
import org.wso2.carbon.event.input.adaptor.core.InputEventAdaptorService;
import org.wso2.carbon.event.input.adaptor.core.config.InputEventAdaptorConfiguration;
import org.wso2.carbon.event.input.adaptor.core.message.MessageDto;
import org.wso2.carbon.event.input.adaptor.manager.core.InputEventAdaptorManagerService;
import org.wso2.carbon.event.input.adaptor.manager.core.exception.InputEventAdaptorManagerConfigurationException;

public class EventBuilderAdminService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(EventBuilderAdminService.class);
    private DtoConverterFactory dtoConverterFactory = new DtoConverterFactory();

    public EventBuilderConfigurationInfoDto[] getAllActiveEventBuilderConfigurations() throws AxisFault {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        EventBuilderService eventBuilderService = EventBuilderAdminServiceValueHolder.getEventBuilderService();
        List eventBuilderConfigurationList = eventBuilderService.getAllActiveEventBuilderConfigurations(tenantId);
        if (eventBuilderConfigurationList != null && !eventBuilderConfigurationList.isEmpty()) {
            EventBuilderConfigurationInfoDto[] eventBuilderConfigurationInfoDtos = new EventBuilderConfigurationInfoDto[eventBuilderConfigurationList.size()];
            for (int i = 0; i < eventBuilderConfigurationList.size(); ++i) {
                EventBuilderConfigurationInfoDto eventBuilderConfigurationDto;
                EventBuilderConfiguration eventBuilderConfiguration = (EventBuilderConfiguration)eventBuilderConfigurationList.get(i);
                DtoConverter dtoConverter = this.dtoConverterFactory.getDtoConverter(eventBuilderConfiguration.getInputMapping().getMappingType());
                try {
                    eventBuilderConfigurationDto = dtoConverter.getEventBuilderConfigurationInfoDto(eventBuilderConfiguration);
                }
                catch (EventBuilderAdminServiceException e) {
                    throw new AxisFault(e.getMessage());
                }
                eventBuilderConfigurationInfoDtos[i] = eventBuilderConfigurationDto;
            }
            return eventBuilderConfigurationInfoDtos;
        }
        return new EventBuilderConfigurationInfoDto[0];
    }

    public EventBuilderConfigurationDto[] getAllStreamSpecificActiveEventBuilderConfiguration(String streamId) throws AxisFault {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        EventBuilderService eventBuilderService = EventBuilderAdminServiceValueHolder.getEventBuilderService();
        List eventBuilderConfigurationList = eventBuilderService.getAllStreamSpecificActiveEventBuilderConfigurations(streamId, tenantId);
        if (eventBuilderConfigurationList != null && !eventBuilderConfigurationList.isEmpty()) {
            EventBuilderConfigurationDto[] eventBuilderConfigurationDtos = new EventBuilderConfigurationDto[eventBuilderConfigurationList.size()];
            for (int i = 0; i < eventBuilderConfigurationList.size(); ++i) {
                EventBuilderConfigurationDto eventBuilderConfigurationDto;
                EventBuilderConfiguration eventBuilderConfiguration = (EventBuilderConfiguration)eventBuilderConfigurationList.get(i);
                DtoConverter dtoConverter = this.dtoConverterFactory.getDtoConverter(eventBuilderConfiguration.getInputMapping().getMappingType());
                try {
                    eventBuilderConfigurationDto = dtoConverter.fromEventBuilderConfiguration(eventBuilderConfiguration);
                }
                catch (EventBuilderAdminServiceException e) {
                    throw new AxisFault(e.getMessage());
                }
                eventBuilderConfigurationDtos[i] = eventBuilderConfigurationDto;
            }
            return eventBuilderConfigurationDtos;
        }
        return new EventBuilderConfigurationDto[0];
    }

    public EventBuilderConfigurationFileDto[] getAllInactiveEventBuilderConfigurations() {
        EventBuilderService eventBuilderService = EventBuilderAdminServiceValueHolder.getEventBuilderService();
        List eventBuilderConfigurationFileList = eventBuilderService.getAllInactiveEventBuilderConfigurations(this.getAxisConfig());
        if (eventBuilderConfigurationFileList != null) {
            EventBuilderConfigurationFileDto[] eventBuilderConfigurationFileDtos = new EventBuilderConfigurationFileDto[eventBuilderConfigurationFileList.size()];
            int i = 0;
            for (EventBuilderConfigurationFile eventBuilderConfigurationFile : eventBuilderConfigurationFileList) {
                String statusMsg = eventBuilderConfigurationFile.getDeploymentStatusMessage();
                if (eventBuilderConfigurationFile.getDependency() != null) {
                    statusMsg = statusMsg + " [Dependency: " + eventBuilderConfigurationFile.getDependency() + "]";
                }
                eventBuilderConfigurationFileDtos[i++] = new EventBuilderConfigurationFileDto(eventBuilderConfigurationFile.getFileName(), eventBuilderConfigurationFile.getEventBuilderName(), statusMsg);
            }
            return eventBuilderConfigurationFileDtos;
        }
        return new EventBuilderConfigurationFileDto[0];
    }

    public EventBuilderConfigurationDto getActiveEventBuilderConfiguration(String eventBuilderName) throws AxisFault {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        EventBuilderService eventBuilderService = EventBuilderAdminServiceValueHolder.getEventBuilderService();
        EventBuilderConfiguration eventBuilderConfiguration = eventBuilderService.getActiveEventBuilderConfiguration(eventBuilderName, tenantId);
        DtoConverter dtoConverter = this.dtoConverterFactory.getDtoConverter(eventBuilderConfiguration.getInputMapping().getMappingType());
        try {
            return dtoConverter.fromEventBuilderConfiguration(eventBuilderConfiguration);
        }
        catch (EventBuilderAdminServiceException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
    }

    public String getInactiveEventBuilderConfigurationContent(String filename) throws AxisFault {
        String eventBuilderConfigurationContent;
        EventBuilderService eventBuilderService = EventBuilderAdminServiceValueHolder.getEventBuilderService();
        try {
            eventBuilderConfigurationContent = eventBuilderService.getInactiveEventBuilderConfigurationContent(filename, this.getAxisConfig());
        }
        catch (EventBuilderConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
        return eventBuilderConfigurationContent;
    }

    public String getActiveEventBuilderConfigurationContent(String eventBuilderName) throws AxisFault {
        try {
            EventBuilderService eventBuilderService = EventBuilderAdminServiceValueHolder.getEventBuilderService();
            return eventBuilderService.getActiveEventBuilderConfigurationContent(eventBuilderName, this.getAxisConfig());
        }
        catch (EventBuilderConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
    }

    public EventBuilderMessagePropertyDto[] getEventBuilderMessageProperties(String inputEventAdaptorName) {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        InputEventAdaptorService inputEventAdaptorService = EventBuilderAdminServiceValueHolder.getInputEventAdaptorService();
        InputEventAdaptorManagerService inputEventAdaptorManagerService = EventBuilderAdminServiceValueHolder.getInputEventAdaptorManagerService();
        InputEventAdaptorConfiguration inputEventAdaptorConfiguration = null;
        try {
            inputEventAdaptorConfiguration = inputEventAdaptorManagerService.getActiveInputEventAdaptorConfiguration(inputEventAdaptorName, tenantId);
        }
        catch (InputEventAdaptorManagerConfigurationException e) {
            String errorMsg = "Error retrieving input event adaptor configuration with name '" + inputEventAdaptorName + "' " + e.getMessage();
            log.error((Object)errorMsg, (Throwable)e);
        }
        if (inputEventAdaptorConfiguration != null) {
            MessageDto messageDto = inputEventAdaptorService.getEventMessageDto(inputEventAdaptorConfiguration.getType());
            DtoConverter dtoConverter = this.dtoConverterFactory.getDtoConverter(null);
            return dtoConverter.getEventBuilderPropertiesFrom(messageDto, null);
        }
        return new EventBuilderMessagePropertyDto[0];
    }

    public void deployEventBuilderConfiguration(String eventBuilderConfigXml) throws AxisFault {
        EventBuilderService eventBuilderService = EventBuilderAdminServiceValueHolder.getEventBuilderService();
        if (eventBuilderConfigXml != null && !eventBuilderConfigXml.isEmpty()) {
            try {
                eventBuilderService.deployEventBuilderConfiguration(eventBuilderConfigXml, this.getAxisConfig());
            }
            catch (EventBuilderConfigurationException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new AxisFault(e.getMessage());
            }
        }
    }

    public void deployWso2EventBuilderConfiguration(String eventBuilderName, String streamNameWithVersion, String eventAdaptorName, String eventAdaptorType, EventInputPropertyConfigurationDto[] metaData, EventInputPropertyConfigurationDto[] correlationData, EventInputPropertyConfigurationDto[] payloadData, PropertyDto[] inputPropertyConfiguration, boolean mappingEnabled) throws AxisFault {
        EventBuilderConfiguration eventBuilderConfiguration;
        EventBuilderService eventBuilderService = EventBuilderAdminServiceValueHolder.getEventBuilderService();
        Wso2EventDtoConverter wso2EventDtoConverter = new Wso2EventDtoConverter();
        try {
            eventBuilderConfiguration = wso2EventDtoConverter.toEventBuilderConfiguration(eventBuilderName, streamNameWithVersion, eventAdaptorName, eventAdaptorType, metaData, correlationData, payloadData, inputPropertyConfiguration, mappingEnabled);
        }
        catch (EventBuilderAdminServiceException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
        if (eventBuilderConfiguration != null) {
            try {
                eventBuilderService.deployEventBuilderConfiguration(eventBuilderConfiguration, this.getAxisConfig());
            }
            catch (EventBuilderConfigurationException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new AxisFault(e.getMessage());
            }
        }
    }

    public void deployXmlEventBuilderConfiguration(String eventBuilderName, String streamNameWithVersion, String eventAdaptorName, String eventAdaptorType, EventInputPropertyConfigurationDto[] xpathExpressions, PropertyDto[] inputPropertyConfiguration, PropertyDto[] xpathDefinitions, String parentSelectorXpath, boolean mappingEnabled) throws AxisFault {
        EventBuilderConfiguration eventBuilderConfiguration;
        EventBuilderService eventBuilderService = EventBuilderAdminServiceValueHolder.getEventBuilderService();
        XmlDtoConverter xmlDtoConverter = new XmlDtoConverter();
        try {
            eventBuilderConfiguration = xmlDtoConverter.toEventBuilderConfiguration(eventBuilderName, streamNameWithVersion, eventAdaptorName, eventAdaptorType, xpathExpressions, inputPropertyConfiguration, xpathDefinitions, parentSelectorXpath, mappingEnabled);
        }
        catch (EventBuilderAdminServiceException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
        if (eventBuilderConfiguration != null) {
            try {
                eventBuilderService.deployEventBuilderConfiguration(eventBuilderConfiguration, this.getAxisConfig());
            }
            catch (EventBuilderConfigurationException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new AxisFault(e.getMessage());
            }
        }
    }

    public void deployJsonEventBuilderConfiguration(String eventBuilderName, String streamNameWithVersion, String eventAdaptorName, String eventAdaptorType, EventInputPropertyConfigurationDto[] jsonPathExpressions, PropertyDto[] inputPropertyConfiguration, boolean mappingEnabled) throws AxisFault {
        EventBuilderConfiguration eventBuilderConfiguration;
        EventBuilderService eventBuilderService = EventBuilderAdminServiceValueHolder.getEventBuilderService();
        JsonDtoConverter jsonDtoConverter = new JsonDtoConverter();
        try {
            eventBuilderConfiguration = jsonDtoConverter.toEventBuilderConfiguration(eventBuilderName, streamNameWithVersion, eventAdaptorName, eventAdaptorType, jsonPathExpressions, inputPropertyConfiguration, mappingEnabled);
        }
        catch (EventBuilderAdminServiceException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
        if (eventBuilderConfiguration != null) {
            try {
                eventBuilderService.deployEventBuilderConfiguration(eventBuilderConfiguration, this.getAxisConfig());
            }
            catch (EventBuilderConfigurationException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new AxisFault(e.getMessage());
            }
        }
    }

    public void deployMapEventBuilderConfiguration(String eventBuilderName, String streamNameWithVersion, String eventAdaptorName, String eventAdaptorType, EventInputPropertyConfigurationDto[] mappingProperties, PropertyDto[] inputPropertyConfiguration, boolean mappingEnabled) throws AxisFault {
        EventBuilderConfiguration eventBuilderConfiguration;
        EventBuilderService eventBuilderService = EventBuilderAdminServiceValueHolder.getEventBuilderService();
        MapDtoConverter mapDtoConverter = new MapDtoConverter();
        try {
            eventBuilderConfiguration = mapDtoConverter.toEventBuilderConfiguration(eventBuilderName, streamNameWithVersion, eventAdaptorName, eventAdaptorType, mappingProperties, inputPropertyConfiguration, mappingEnabled);
        }
        catch (EventBuilderAdminServiceException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
        if (eventBuilderConfiguration != null) {
            try {
                eventBuilderService.deployEventBuilderConfiguration(eventBuilderConfiguration, this.getAxisConfig());
            }
            catch (EventBuilderConfigurationException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new AxisFault(e.getMessage());
            }
        }
    }

    public void deployTextEventBuilderConfiguration(String eventBuilderName, String streamNameWithVersion, String eventAdaptorName, String eventAdaptorType, EventInputPropertyConfigurationDto[] textMappingAttributes, PropertyDto[] inputPropertyConfiguration, boolean mappingEnabled) throws AxisFault {
        EventBuilderConfiguration eventBuilderConfiguration;
        EventBuilderService eventBuilderService = EventBuilderAdminServiceValueHolder.getEventBuilderService();
        TextDtoConverter textDtoConverter = new TextDtoConverter();
        try {
            eventBuilderConfiguration = textDtoConverter.toEventBuilderConfiguration(eventBuilderName, streamNameWithVersion, eventAdaptorName, eventAdaptorType, textMappingAttributes, inputPropertyConfiguration, mappingEnabled);
        }
        catch (EventBuilderAdminServiceException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
        if (eventBuilderConfiguration != null) {
            try {
                eventBuilderService.deployEventBuilderConfiguration(eventBuilderConfiguration, this.getAxisConfig());
            }
            catch (EventBuilderConfigurationException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new AxisFault(e.getMessage());
            }
        }
    }

    public void undeployActiveEventBuilderConfiguration(String eventBuilderName) throws AxisFault {
        EventBuilderService eventBuilderService = EventBuilderAdminServiceValueHolder.getEventBuilderService();
        try {
            eventBuilderService.undeployActiveEventBuilderConfiguration(eventBuilderName, this.getAxisConfig());
        }
        catch (EventBuilderConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
    }

    public void undeployInactiveEventBuilderConfiguration(String filename) throws AxisFault {
        EventBuilderService eventBuilderService = EventBuilderAdminServiceValueHolder.getEventBuilderService();
        try {
            eventBuilderService.undeployInactiveEventBuilderConfiguration(filename, this.getAxisConfig());
        }
        catch (EventBuilderConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
    }

    public void editActiveEventBuilderConfiguration(String originalEventBuilderName, String eventBuilderConfigXml) throws AxisFault {
        if (eventBuilderConfigXml != null && !eventBuilderConfigXml.isEmpty() && originalEventBuilderName != null && !originalEventBuilderName.isEmpty()) {
            EventBuilderService eventBuilderService = EventBuilderAdminServiceValueHolder.getEventBuilderService();
            try {
                eventBuilderService.editActiveEventBuilderConfiguration(eventBuilderConfigXml, originalEventBuilderName, this.getAxisConfig());
            }
            catch (EventBuilderConfigurationException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new AxisFault(e.getMessage());
            }
        } else {
            String errMsg = "Some required parameters were null or empty. Cannot proceed with updating.";
            log.error((Object)errMsg);
            throw new AxisFault(errMsg);
        }
    }

    public void editInactiveEventBuilderConfiguration(String filename, String eventBuilderConfigXml) throws AxisFault {
        if (eventBuilderConfigXml != null && !eventBuilderConfigXml.isEmpty() && filename != null && !filename.isEmpty()) {
            EventBuilderService eventBuilderService = EventBuilderAdminServiceValueHolder.getEventBuilderService();
            try {
                eventBuilderService.editInactiveEventBuilderConfiguration(eventBuilderConfigXml, filename, this.getAxisConfig());
            }
            catch (EventBuilderConfigurationException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new AxisFault(e.getMessage());
            }
        } else {
            String errMsg = "Some required parameters were null or empty. Cannot proceed with updating.";
            log.error((Object)errMsg);
            throw new AxisFault(errMsg);
        }
    }

    public void deployDefaultEventReceiver(String streamId) throws AxisFault {
        EventBuilderService eventBuilderService = EventBuilderAdminServiceValueHolder.getEventBuilderService();
        AxisConfiguration axisConfiguration = this.getAxisConfig();
        try {
            eventBuilderService.deployDefaultEventBuilder(streamId, axisConfiguration);
        }
        catch (EventBuilderConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
    }

    public void setTraceEnabled(String eventBuilderName, boolean traceEnabled) throws AxisFault {
        EventBuilderService eventBuilderService = EventBuilderAdminServiceValueHolder.getEventBuilderService();
        try {
            eventBuilderService.setTraceEnabled(eventBuilderName, traceEnabled, this.getAxisConfig());
        }
        catch (EventBuilderConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
    }

    public void setStatisticsEnabled(String eventBuilderName, boolean statisticsEnabled) throws AxisFault {
        EventBuilderService eventBuilderService = EventBuilderAdminServiceValueHolder.getEventBuilderService();
        try {
            eventBuilderService.setStatisticsEnabled(eventBuilderName, statisticsEnabled, this.getAxisConfig());
        }
        catch (EventBuilderConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
    }
}

