/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.builder.admin.internal.util.dto.converter;

import java.util.ArrayList;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.event.builder.admin.exception.EventBuilderAdminServiceException;
import org.wso2.carbon.event.builder.admin.internal.EventBuilderConfigurationDto;
import org.wso2.carbon.event.builder.admin.internal.EventBuilderMessagePropertyDto;
import org.wso2.carbon.event.builder.admin.internal.EventInputPropertyConfigurationDto;
import org.wso2.carbon.event.builder.admin.internal.PropertyDto;
import org.wso2.carbon.event.builder.admin.internal.util.DtoConverter;
import org.wso2.carbon.event.builder.admin.internal.util.EventBuilderAdminConstants;
import org.wso2.carbon.event.builder.core.config.EventBuilderConfiguration;
import org.wso2.carbon.event.builder.core.internal.config.InputMappingAttribute;
import org.wso2.carbon.event.builder.core.internal.type.AbstractInputMapping;
import org.wso2.carbon.event.builder.core.internal.type.json.JsonInputMapping;
import org.wso2.carbon.event.builder.core.internal.util.EventBuilderConstants;
import org.wso2.carbon.event.input.adaptor.core.message.config.InputEventAdaptorMessageConfiguration;

public class JsonDtoConverter
extends DtoConverter {
    public EventBuilderConfiguration toEventBuilderConfiguration(String eventBuilderName, String streamNameWithVersion, String eventAdaptorName, String eventAdaptorType, EventInputPropertyConfigurationDto[] jsonPathExpressions, PropertyDto[] inputPropertyConfiguration, boolean mappingEnabled) throws EventBuilderAdminServiceException {
        EventBuilderConfiguration eventBuilderConfiguration = new EventBuilderConfiguration();
        JsonInputMapping jsonInputMapping = new JsonInputMapping();
        InputEventAdaptorMessageConfiguration inputEventAdaptorMessageConfiguration = new InputEventAdaptorMessageConfiguration();
        for (PropertyDto propertyDto : inputPropertyConfiguration) {
            inputEventAdaptorMessageConfiguration.addInputMessageProperty(propertyDto.getKey(), propertyDto.getValue());
        }
        for (EventInputPropertyConfigurationDto eventInputPropertyConfigurationDto : jsonPathExpressions) {
            String attribTypeName = eventInputPropertyConfigurationDto.getType();
            AttributeType attributeType = (AttributeType)EventBuilderConstants.STRING_ATTRIBUTE_TYPE_MAP.get(attribTypeName.toLowerCase());
            if (attributeType == null) {
                throw new EventBuilderAdminServiceException(attribTypeName.toLowerCase() + " is not a supported attribute type, only the following are supported: " + EventBuilderConstants.STRING_ATTRIBUTE_TYPE_MAP.keySet());
            }
            InputMappingAttribute jsonMappingAttribute = new InputMappingAttribute(eventInputPropertyConfigurationDto.getValueOf(), eventInputPropertyConfigurationDto.getName(), attributeType);
            jsonMappingAttribute.setDefaultValue(eventInputPropertyConfigurationDto.getDefaultValue());
            jsonInputMapping.addInputMappingAttribute(jsonMappingAttribute);
        }
        this.setCommonPropertiesToEventBuilderConfig(eventBuilderConfiguration, inputEventAdaptorMessageConfiguration, eventBuilderName, streamNameWithVersion, eventAdaptorName, eventAdaptorType, mappingEnabled, (AbstractInputMapping)jsonInputMapping);
        return eventBuilderConfiguration;
    }

    @Override
    public EventBuilderConfigurationDto fromEventBuilderConfiguration(EventBuilderConfiguration eventBuilderConfiguration) {
        EventBuilderConfigurationDto eventBuilderConfigurationDto = new EventBuilderConfigurationDto();
        eventBuilderConfigurationDto.setEventBuilderConfigName(eventBuilderConfiguration.getEventBuilderName());
        eventBuilderConfigurationDto.setInputMappingType(eventBuilderConfiguration.getInputMapping().getMappingType());
        eventBuilderConfigurationDto.setInputEventAdaptorName(eventBuilderConfiguration.getInputStreamConfiguration().getInputEventAdaptorName());
        eventBuilderConfigurationDto.setInputEventAdaptorType(eventBuilderConfiguration.getInputStreamConfiguration().getInputEventAdaptorType());
        eventBuilderConfigurationDto.setToStreamName(eventBuilderConfiguration.getToStreamName());
        eventBuilderConfigurationDto.setToStreamVersion(eventBuilderConfiguration.getToStreamVersion());
        eventBuilderConfigurationDto.setTraceEnabled(eventBuilderConfiguration.isTraceEnabled());
        eventBuilderConfigurationDto.setStatisticsEnabled(eventBuilderConfiguration.isStatisticsEnabled());
        eventBuilderConfigurationDto.setCustomMappingEnabled(eventBuilderConfiguration.getInputMapping().isCustomMappingEnabled());
        EventBuilderMessagePropertyDto[] eventBuilderMessagePropertyDtos = this.getEventBuilderMessageProperties(eventBuilderConfiguration);
        eventBuilderConfigurationDto.setEventBuilderMessageProperties(eventBuilderMessagePropertyDtos);
        EventInputPropertyConfigurationDto[] jsonPathExpressions = this.getJsonPathExpressions(eventBuilderConfiguration);
        eventBuilderConfigurationDto.setPayloadEventBuilderProperties(jsonPathExpressions);
        return eventBuilderConfigurationDto;
    }

    private EventInputPropertyConfigurationDto[] getJsonPathExpressions(EventBuilderConfiguration eventBuilderConfiguration) {
        ArrayList<EventInputPropertyConfigurationDto> eventInputPropertyConfigurationDtos = new ArrayList<EventInputPropertyConfigurationDto>();
        JsonInputMapping jsonInputMapping = (JsonInputMapping)eventBuilderConfiguration.getInputMapping();
        for (InputMappingAttribute inputMappingAttribute : jsonInputMapping.getInputMappingAttributes()) {
            EventInputPropertyConfigurationDto eventBuilderMessagePropertyDto = this.getMappingSectionProperty(inputMappingAttribute);
            eventInputPropertyConfigurationDtos.add(eventBuilderMessagePropertyDto);
        }
        return eventInputPropertyConfigurationDtos.toArray(new EventInputPropertyConfigurationDto[eventInputPropertyConfigurationDtos.size()]);
    }

    private EventInputPropertyConfigurationDto getMappingSectionProperty(InputMappingAttribute inputMappingAttribute) {
        EventInputPropertyConfigurationDto eventInputPropertyConfigurationDto = new EventInputPropertyConfigurationDto();
        eventInputPropertyConfigurationDto.setName(inputMappingAttribute.getToElementKey());
        eventInputPropertyConfigurationDto.setValueOf(inputMappingAttribute.getFromElementKey());
        eventInputPropertyConfigurationDto.setType(EventBuilderAdminConstants.ATTRIBUTE_TYPE_STRING_MAP.get(inputMappingAttribute.getToElementType()));
        eventInputPropertyConfigurationDto.setDefaultValue(inputMappingAttribute.getDefaultValue());
        return eventInputPropertyConfigurationDto;
    }
}

