/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.builder.admin.internal.util.dto.converter;

import java.util.ArrayList;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.event.builder.admin.exception.EventBuilderAdminServiceException;
import org.wso2.carbon.event.builder.admin.internal.EventBuilderConfigurationDto;
import org.wso2.carbon.event.builder.admin.internal.EventBuilderMessagePropertyDto;
import org.wso2.carbon.event.builder.admin.internal.EventInputPropertyConfigurationDto;
import org.wso2.carbon.event.builder.admin.internal.PropertyDto;
import org.wso2.carbon.event.builder.admin.internal.util.DtoConverter;
import org.wso2.carbon.event.builder.admin.internal.util.EventBuilderAdminConstants;
import org.wso2.carbon.event.builder.core.config.EventBuilderConfiguration;
import org.wso2.carbon.event.builder.core.internal.config.InputMappingAttribute;
import org.wso2.carbon.event.builder.core.internal.type.AbstractInputMapping;
import org.wso2.carbon.event.builder.core.internal.type.wso2event.Wso2EventInputMapping;
import org.wso2.carbon.event.builder.core.internal.util.EventBuilderConstants;
import org.wso2.carbon.event.input.adaptor.core.message.config.InputEventAdaptorMessageConfiguration;

public class Wso2EventDtoConverter
extends DtoConverter {
    public EventBuilderConfiguration toEventBuilderConfiguration(String eventBuilderName, String streamNameWithVersion, String eventAdaptorName, String eventAdaptorType, EventInputPropertyConfigurationDto[] metaData, EventInputPropertyConfigurationDto[] correlationData, EventInputPropertyConfigurationDto[] payloadData, PropertyDto[] inputPropertyConfiguration, boolean mappingEnabled) throws EventBuilderAdminServiceException {
        EventBuilderConfiguration eventBuilderConfiguration = new EventBuilderConfiguration();
        Wso2EventInputMapping wso2EventInputMapping = new Wso2EventInputMapping();
        InputEventAdaptorMessageConfiguration inputEventAdaptorMessageConfiguration = new InputEventAdaptorMessageConfiguration();
        this.populateMappingAttributesFromDto(metaData, correlationData, payloadData, inputPropertyConfiguration, (AbstractInputMapping)wso2EventInputMapping, inputEventAdaptorMessageConfiguration);
        this.setCommonPropertiesToEventBuilderConfig(eventBuilderConfiguration, inputEventAdaptorMessageConfiguration, eventBuilderName, streamNameWithVersion, eventAdaptorName, eventAdaptorType, mappingEnabled, (AbstractInputMapping)wso2EventInputMapping);
        return eventBuilderConfiguration;
    }

    private void populateMappingAttributesFromDto(EventInputPropertyConfigurationDto[] metaData, EventInputPropertyConfigurationDto[] correlationData, EventInputPropertyConfigurationDto[] payloadData, PropertyDto[] inputPropertyConfiguration, AbstractInputMapping inputMapping, InputEventAdaptorMessageConfiguration inputEventAdaptorMessageConfiguration) throws EventBuilderAdminServiceException {
        AttributeType attributeType;
        String attribTypeName;
        for (PropertyDto propertyDto : inputPropertyConfiguration) {
            inputEventAdaptorMessageConfiguration.addInputMessageProperty(propertyDto.getKey(), propertyDto.getValue());
        }
        int mappingPropertyPos = 0;
        for (EventInputPropertyConfigurationDto metaAttribute : metaData) {
            attribTypeName = metaAttribute.getType();
            attributeType = (AttributeType)EventBuilderConstants.STRING_ATTRIBUTE_TYPE_MAP.get(attribTypeName.toLowerCase());
            if (attributeType == null) {
                throw new EventBuilderAdminServiceException(attribTypeName.toLowerCase() + " is not a supported attribute type, only the following are supported: " + EventBuilderConstants.STRING_ATTRIBUTE_TYPE_MAP.keySet());
            }
            InputMappingAttribute metaInputMappingAttribute = new InputMappingAttribute(metaAttribute.getName(), metaAttribute.getValueOf(), attributeType, "meta");
            metaInputMappingAttribute.setToStreamPosition(Integer.valueOf(mappingPropertyPos++));
            inputMapping.addInputMappingAttribute(metaInputMappingAttribute);
        }
        for (EventInputPropertyConfigurationDto correlationAttribute : correlationData) {
            attribTypeName = correlationAttribute.getType();
            attributeType = (AttributeType)EventBuilderConstants.STRING_ATTRIBUTE_TYPE_MAP.get(attribTypeName.toLowerCase());
            if (attributeType == null) {
                throw new EventBuilderAdminServiceException(attribTypeName.toLowerCase() + " is not a supported attribute type, only the following are supported: " + EventBuilderConstants.STRING_ATTRIBUTE_TYPE_MAP.keySet());
            }
            InputMappingAttribute correlationInputMappingAttribute = new InputMappingAttribute(correlationAttribute.getName(), correlationAttribute.getValueOf(), attributeType, "correlation");
            correlationInputMappingAttribute.setToStreamPosition(Integer.valueOf(mappingPropertyPos++));
            inputMapping.addInputMappingAttribute(correlationInputMappingAttribute);
        }
        for (EventInputPropertyConfigurationDto payloadAttribute : payloadData) {
            attribTypeName = payloadAttribute.getType();
            attributeType = (AttributeType)EventBuilderConstants.STRING_ATTRIBUTE_TYPE_MAP.get(attribTypeName.toLowerCase());
            if (attributeType == null) {
                throw new EventBuilderAdminServiceException(attribTypeName.toLowerCase() + " is not a supported attribute type, only the following are supported: " + EventBuilderConstants.STRING_ATTRIBUTE_TYPE_MAP.keySet());
            }
            InputMappingAttribute payloadInputMappingAttribute = new InputMappingAttribute(payloadAttribute.getName(), payloadAttribute.getValueOf(), attributeType, "payload");
            payloadInputMappingAttribute.setToStreamPosition(Integer.valueOf(mappingPropertyPos++));
            inputMapping.addInputMappingAttribute(payloadInputMappingAttribute);
        }
    }

    @Override
    public EventBuilderConfigurationDto fromEventBuilderConfiguration(EventBuilderConfiguration eventBuilderConfiguration) {
        EventBuilderConfigurationDto eventBuilderConfigurationDto = new EventBuilderConfigurationDto();
        eventBuilderConfigurationDto.setEventBuilderConfigName(eventBuilderConfiguration.getEventBuilderName());
        eventBuilderConfigurationDto.setInputMappingType(eventBuilderConfiguration.getInputMapping().getMappingType());
        eventBuilderConfigurationDto.setInputEventAdaptorName(eventBuilderConfiguration.getInputStreamConfiguration().getInputEventAdaptorName());
        eventBuilderConfigurationDto.setInputEventAdaptorType(eventBuilderConfiguration.getInputStreamConfiguration().getInputEventAdaptorType());
        eventBuilderConfigurationDto.setToStreamName(eventBuilderConfiguration.getToStreamName());
        eventBuilderConfigurationDto.setToStreamVersion(eventBuilderConfiguration.getToStreamVersion());
        eventBuilderConfigurationDto.setTraceEnabled(eventBuilderConfiguration.isTraceEnabled());
        eventBuilderConfigurationDto.setStatisticsEnabled(eventBuilderConfiguration.isStatisticsEnabled());
        eventBuilderConfigurationDto.setCustomMappingEnabled(eventBuilderConfiguration.getInputMapping().isCustomMappingEnabled());
        EventBuilderMessagePropertyDto[] eventBuilderMessagePropertyDtos = this.getEventBuilderMessageProperties(eventBuilderConfiguration);
        eventBuilderConfigurationDto.setEventBuilderMessageProperties(eventBuilderMessagePropertyDtos);
        EventInputPropertyConfigurationDto[] metaEventBuilderProperties = this.getMetaEventBuilderProperties(eventBuilderConfiguration);
        EventInputPropertyConfigurationDto[] correlationEventBuilderProperties = this.getCorrelationEventBuilderProperties(eventBuilderConfiguration);
        EventInputPropertyConfigurationDto[] payloadEventBuilderProperties = this.getPayloadEventBuilderProperties(eventBuilderConfiguration);
        eventBuilderConfigurationDto.setMetaEventBuilderProperties(metaEventBuilderProperties);
        eventBuilderConfigurationDto.setCorrelationEventBuilderProperties(correlationEventBuilderProperties);
        eventBuilderConfigurationDto.setPayloadEventBuilderProperties(payloadEventBuilderProperties);
        return eventBuilderConfigurationDto;
    }

    private EventInputPropertyConfigurationDto[] getMetaEventBuilderProperties(EventBuilderConfiguration eventBuilderConfiguration) {
        ArrayList<EventInputPropertyConfigurationDto> eventInputPropertyConfigurationDtos = new ArrayList<EventInputPropertyConfigurationDto>();
        Wso2EventInputMapping wso2EventInputMapping = (Wso2EventInputMapping)eventBuilderConfiguration.getInputMapping();
        for (InputMappingAttribute inputMappingAttribute : wso2EventInputMapping.getInputMappingAttributes()) {
            if (!inputMappingAttribute.getFromElementType().equals("meta")) continue;
            EventInputPropertyConfigurationDto eventBuilderMessagePropertyDto = this.getMappingSectionProperty(inputMappingAttribute);
            eventInputPropertyConfigurationDtos.add(eventBuilderMessagePropertyDto);
        }
        return eventInputPropertyConfigurationDtos.toArray(new EventInputPropertyConfigurationDto[eventInputPropertyConfigurationDtos.size()]);
    }

    private EventInputPropertyConfigurationDto[] getCorrelationEventBuilderProperties(EventBuilderConfiguration eventBuilderConfiguration) {
        ArrayList<EventInputPropertyConfigurationDto> eventInputPropertyConfigurationDtos = new ArrayList<EventInputPropertyConfigurationDto>();
        Wso2EventInputMapping wso2EventInputMapping = (Wso2EventInputMapping)eventBuilderConfiguration.getInputMapping();
        for (InputMappingAttribute inputMappingAttribute : wso2EventInputMapping.getInputMappingAttributes()) {
            if (!inputMappingAttribute.getFromElementType().equals("correlation")) continue;
            EventInputPropertyConfigurationDto eventBuilderMessagePropertyDto = this.getMappingSectionProperty(inputMappingAttribute);
            eventInputPropertyConfigurationDtos.add(eventBuilderMessagePropertyDto);
        }
        return eventInputPropertyConfigurationDtos.toArray(new EventInputPropertyConfigurationDto[eventInputPropertyConfigurationDtos.size()]);
    }

    private EventInputPropertyConfigurationDto[] getPayloadEventBuilderProperties(EventBuilderConfiguration eventBuilderConfiguration) {
        ArrayList<EventInputPropertyConfigurationDto> eventInputPropertyConfigurationDtos = new ArrayList<EventInputPropertyConfigurationDto>();
        Wso2EventInputMapping wso2EventInputMapping = (Wso2EventInputMapping)eventBuilderConfiguration.getInputMapping();
        for (InputMappingAttribute inputMappingAttribute : wso2EventInputMapping.getInputMappingAttributes()) {
            if (!inputMappingAttribute.getFromElementType().equals("payload")) continue;
            EventInputPropertyConfigurationDto eventBuilderMessagePropertyDto = this.getMappingSectionProperty(inputMappingAttribute);
            eventInputPropertyConfigurationDtos.add(eventBuilderMessagePropertyDto);
        }
        return eventInputPropertyConfigurationDtos.toArray(new EventInputPropertyConfigurationDto[eventInputPropertyConfigurationDtos.size()]);
    }

    private EventInputPropertyConfigurationDto getMappingSectionProperty(InputMappingAttribute inputMappingAttribute) {
        EventInputPropertyConfigurationDto eventInputPropertyConfigurationDto = new EventInputPropertyConfigurationDto();
        eventInputPropertyConfigurationDto.setName(inputMappingAttribute.getFromElementKey());
        eventInputPropertyConfigurationDto.setValueOf(inputMappingAttribute.getToElementKey());
        eventInputPropertyConfigurationDto.setType(EventBuilderAdminConstants.ATTRIBUTE_TYPE_STRING_MAP.get(inputMappingAttribute.getToElementType()));
        eventInputPropertyConfigurationDto.setDefaultValue(inputMappingAttribute.getDefaultValue());
        return eventInputPropertyConfigurationDto;
    }
}

