/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.builder.admin.internal.util;

import java.util.List;
import java.util.Map;
import org.wso2.carbon.event.builder.admin.exception.EventBuilderAdminServiceException;
import org.wso2.carbon.event.builder.admin.internal.EventBuilderConfigurationDto;
import org.wso2.carbon.event.builder.admin.internal.EventBuilderConfigurationInfoDto;
import org.wso2.carbon.event.builder.admin.internal.EventBuilderMessagePropertyDto;
import org.wso2.carbon.event.builder.admin.internal.ds.EventBuilderAdminServiceValueHolder;
import org.wso2.carbon.event.builder.core.config.EventBuilderConfiguration;
import org.wso2.carbon.event.builder.core.config.InputMapping;
import org.wso2.carbon.event.builder.core.config.InputStreamConfiguration;
import org.wso2.carbon.event.input.adaptor.core.InputEventAdaptorService;
import org.wso2.carbon.event.input.adaptor.core.Property;
import org.wso2.carbon.event.input.adaptor.core.message.MessageDto;
import org.wso2.carbon.event.input.adaptor.core.message.config.InputEventAdaptorMessageConfiguration;

public abstract class DtoConverter {
    public EventBuilderMessagePropertyDto[] getEventBuilderPropertiesFrom(MessageDto messageDto, EventBuilderConfiguration eventBuilderConfiguration) {
        List messageDtoPropertyList = messageDto.getMessageInPropertyList();
        if (messageDtoPropertyList != null) {
            EventBuilderMessagePropertyDto[] eventBuilderMessagePropertyDtos = new EventBuilderMessagePropertyDto[messageDtoPropertyList.size()];
            int i = 0;
            if (eventBuilderConfiguration != null) {
                Map propertyValueMap = eventBuilderConfiguration.getInputStreamConfiguration().getInputEventAdaptorMessageConfiguration().getInputMessageProperties();
                for (Property property : messageDtoPropertyList) {
                    String value = (String)propertyValueMap.get(property.getPropertyName());
                    EventBuilderMessagePropertyDto eventBuilderMessagePropertyDto = this.getEventBuilderPropertyFrom(property, value);
                    eventBuilderMessagePropertyDtos[i++] = eventBuilderMessagePropertyDto;
                }
            } else {
                for (Property property : messageDtoPropertyList) {
                    EventBuilderMessagePropertyDto eventBuilderMessagePropertyDto = this.getEventBuilderPropertyFrom(property, null);
                    eventBuilderMessagePropertyDtos[i++] = eventBuilderMessagePropertyDto;
                }
            }
            return eventBuilderMessagePropertyDtos;
        }
        return new EventBuilderMessagePropertyDto[0];
    }

    public abstract EventBuilderConfigurationDto fromEventBuilderConfiguration(EventBuilderConfiguration var1) throws EventBuilderAdminServiceException;

    public EventBuilderConfigurationInfoDto getEventBuilderConfigurationInfoDto(EventBuilderConfiguration eventBuilderConfiguration) throws EventBuilderAdminServiceException {
        EventBuilderConfigurationInfoDto eventBuilderConfigurationDto = new EventBuilderConfigurationInfoDto();
        eventBuilderConfigurationDto.setEventBuilderName(eventBuilderConfiguration.getEventBuilderName());
        eventBuilderConfigurationDto.setInputMappingType(eventBuilderConfiguration.getInputMapping().getMappingType());
        eventBuilderConfigurationDto.setInputEventAdaptorName(eventBuilderConfiguration.getInputStreamConfiguration().getInputEventAdaptorName());
        eventBuilderConfigurationDto.setInputEventAdaptorType(eventBuilderConfiguration.getInputStreamConfiguration().getInputEventAdaptorType());
        eventBuilderConfigurationDto.setToStreamId(eventBuilderConfiguration.getToStreamName() + ":" + eventBuilderConfiguration.getToStreamVersion());
        eventBuilderConfigurationDto.setEnableTracing(eventBuilderConfiguration.isTraceEnabled());
        eventBuilderConfigurationDto.setEnableStats(eventBuilderConfiguration.isStatisticsEnabled());
        eventBuilderConfigurationDto.setEditable(eventBuilderConfiguration.isEditable());
        return eventBuilderConfigurationDto;
    }

    private EventBuilderMessagePropertyDto getEventBuilderPropertyFrom(Property msgDtoProperty, String value) {
        String key = msgDtoProperty.getPropertyName();
        EventBuilderMessagePropertyDto eventBuilderMessagePropertyDto = new EventBuilderMessagePropertyDto();
        eventBuilderMessagePropertyDto.setKey(key);
        eventBuilderMessagePropertyDto.setDefaultValue(msgDtoProperty.getDefaultValue());
        eventBuilderMessagePropertyDto.setDisplayName(msgDtoProperty.getDisplayName());
        eventBuilderMessagePropertyDto.setHint(msgDtoProperty.getHint());
        eventBuilderMessagePropertyDto.setRequired(msgDtoProperty.isRequired());
        eventBuilderMessagePropertyDto.setSecured(msgDtoProperty.isSecured());
        if (value != null) {
            eventBuilderMessagePropertyDto.setValue(value);
        } else {
            eventBuilderMessagePropertyDto.setValue(msgDtoProperty.getDefaultValue());
        }
        eventBuilderMessagePropertyDto.setOptions(msgDtoProperty.getOptions());
        return eventBuilderMessagePropertyDto;
    }

    protected void setCommonPropertiesToEventBuilderConfig(EventBuilderConfiguration eventBuilderConfiguration, InputEventAdaptorMessageConfiguration inputEventAdaptorMessageConfiguration, String eventBuilderName, String streamNameWithVersion, String eventAdaptorName, String eventAdaptorType, boolean mappingEnabled, InputMapping inputMapping) {
        inputMapping.setCustomMappingEnabled(mappingEnabled);
        eventBuilderConfiguration.setEventBuilderName(eventBuilderName);
        eventBuilderConfiguration.setInputMapping(inputMapping);
        String[] toStreamProperties = streamNameWithVersion.split(":");
        eventBuilderConfiguration.setToStreamName(toStreamProperties[0]);
        eventBuilderConfiguration.setToStreamVersion(toStreamProperties[1]);
        InputStreamConfiguration inputStreamConfiguration = new InputStreamConfiguration();
        inputStreamConfiguration.setInputEventAdaptorMessageConfiguration(inputEventAdaptorMessageConfiguration);
        inputStreamConfiguration.setInputEventAdaptorName(eventAdaptorName);
        inputStreamConfiguration.setInputEventAdaptorType(eventAdaptorType);
        eventBuilderConfiguration.setInputStreamConfiguration(inputStreamConfiguration);
    }

    protected EventBuilderMessagePropertyDto[] getEventBuilderMessageProperties(EventBuilderConfiguration eventBuilderConfiguration) {
        String inputEventAdaptorType = eventBuilderConfiguration.getInputStreamConfiguration().getInputEventAdaptorType();
        InputEventAdaptorService inputEventAdaptorService = EventBuilderAdminServiceValueHolder.getInputEventAdaptorService();
        if (inputEventAdaptorType != null) {
            MessageDto messageDto = inputEventAdaptorService.getEventMessageDto(inputEventAdaptorType);
            return this.getEventBuilderPropertiesFrom(messageDto, eventBuilderConfiguration);
        }
        return new EventBuilderMessagePropertyDto[0];
    }
}

