/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.siddhi.tryit.ui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.core.CarbonDataSource;
import org.wso2.carbon.ndatasource.core.DataSourceManager;
import org.wso2.carbon.siddhi.tryit.ui.internal.ds.SiddhiTryItValueHolder;
import org.wso2.siddhi.core.ExecutionPlanRuntime;
import org.wso2.siddhi.core.SiddhiManager;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.query.output.callback.QueryCallback;
import org.wso2.siddhi.core.stream.input.InputHandler;
import org.wso2.siddhi.core.stream.output.StreamCallback;
import org.wso2.siddhi.query.api.ExecutionPlan;
import org.wso2.siddhi.query.api.annotation.Element;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.execution.ExecutionElement;
import org.wso2.siddhi.query.api.execution.query.Query;
import org.wso2.siddhi.query.api.util.AnnotationHelper;
import org.wso2.siddhi.query.compiler.SiddhiCompiler;

public class SiddhiTryItClient {
    private static Log log = LogFactory.getLog(SiddhiTryItClient.class);
    private static Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private String errMsg = "";

    public Map<String, StringBuilder> processData(String executionPlan, String eventStream, String dateTime) throws Exception {
        LinkedHashMap<String, StringBuilder> map = new LinkedHashMap<String, StringBuilder>();
        LinkedHashMap<String, InputHandler> inputHandlerMap = new LinkedHashMap<String, InputHandler>();
        long startSetTime = this.createTimeStamp(dateTime);
        long startSystemTime = System.currentTimeMillis();
        SiddhiManager siddhiManager = new SiddhiManager();
        SiddhiTryItClient.loadDataSourceConfiguration(siddhiManager);
        ExecutionPlan newExecutionPlan = SiddhiCompiler.parse((String)executionPlan);
        ExecutionPlanRuntime executionPlanRuntime = siddhiManager.createExecutionPlanRuntime(executionPlan);
        for (int i = 0; i < newExecutionPlan.getExecutionElementList().size(); ++i) {
            Query query;
            Element element;
            ExecutionElement executionElement = (ExecutionElement)newExecutionPlan.getExecutionElementList().get(i);
            if (!(executionElement instanceof Query) || (element = AnnotationHelper.getAnnotationElement((String)"info", (String)"name", (List)(query = (Query)executionElement).getAnnotations())) == null) continue;
            String queryName = element.getValue();
            final StringBuilder stringBuilder = new StringBuilder();
            map.put(":".concat(queryName), stringBuilder);
            executionPlanRuntime.addCallback(queryName, new QueryCallback(){

                public void receive(long timeStamp, Event[] inEvents, Event[] removeEvents) {
                    if (inEvents != null) {
                        stringBuilder.append(gson.toJson((Object)inEvents));
                    }
                }
            });
        }
        for (AbstractDefinition abstractDefinition : executionPlanRuntime.getStreamDefinitionMap().values()) {
            String streamId = abstractDefinition.getId();
            InputHandler inputHandler = executionPlanRuntime.getInputHandler(streamId);
            if (!inputHandlerMap.containsKey(streamId)) {
                inputHandlerMap.put(streamId, inputHandler);
            }
            final StringBuilder stringBuilder = new StringBuilder();
            map.put(streamId, stringBuilder);
            executionPlanRuntime.addCallback(streamId, new StreamCallback(){

                public void receive(Event[] events) {
                    stringBuilder.append(gson.toJson((Object)events));
                }
            });
        }
        try {
            Pattern eventPattern = Pattern.compile("(\\S+)=\\[(.*)\\]");
            Pattern delayPattern = Pattern.compile("(delay\\()(\\d+)+");
            String[] inputStreamEventArray = eventStream.split("\\r?\\n");
            executionPlanRuntime.start();
            for (int i = 0; i < inputStreamEventArray.length; ++i) {
                Matcher eventPatternMatcher = eventPattern.matcher(inputStreamEventArray[i].trim());
                Matcher delayPatternMatcher = delayPattern.matcher(inputStreamEventArray[i]);
                if (eventPatternMatcher.find()) {
                    String inputStreamId = eventPatternMatcher.group(1);
                    String[] eventStreamAttributeArray = eventPatternMatcher.group(2).split(",");
                    int eventStreamAttributeListSize = eventStreamAttributeArray.length;
                    Object[] object = new Object[eventStreamAttributeListSize];
                    block17: for (int j = 0; j < eventStreamAttributeListSize; ++j) {
                        Attribute.Type attributeType = ((Attribute)((AbstractDefinition)executionPlanRuntime.getStreamDefinitionMap().get(inputStreamId)).getAttributeList().get(j)).getType();
                        switch (attributeType) {
                            case STRING: {
                                object[j] = eventStreamAttributeArray[j];
                                continue block17;
                            }
                            case INT: {
                                object[j] = Integer.parseInt(eventStreamAttributeArray[j]);
                                continue block17;
                            }
                            case LONG: {
                                object[j] = Long.parseLong(eventStreamAttributeArray[j]);
                                continue block17;
                            }
                            case FLOAT: {
                                object[j] = Float.valueOf(Float.parseFloat(eventStreamAttributeArray[j]));
                                continue block17;
                            }
                            case DOUBLE: {
                                object[j] = Double.parseDouble(eventStreamAttributeArray[j]);
                                continue block17;
                            }
                            case BOOL: {
                                object[j] = Boolean.parseBoolean(eventStreamAttributeArray[j]);
                                continue block17;
                            }
                            case OBJECT: {
                                object[j] = eventStreamAttributeArray[j];
                            }
                        }
                    }
                    for (String key : inputHandlerMap.keySet()) {
                        if (!key.equals(inputStreamId)) continue;
                        ((InputHandler)inputHandlerMap.get(key)).send(startSetTime + (System.currentTimeMillis() - startSystemTime), object);
                    }
                    continue;
                }
                if (delayPatternMatcher.find()) {
                    Thread.sleep(Long.parseLong(delayPatternMatcher.group(2)));
                    continue;
                }
                if (inputStreamEventArray[i].equals("")) continue;
                this.errMsg = "Error in event \"  " + inputStreamEventArray[i] + "\n\"." + " Expected format: &lt;eventStreamName&gt;=[&lt;attribute1&gt;,&lt;attribute2&gt;]";
                throw new Exception(this.errMsg);
            }
            Thread.sleep(500L);
            LinkedHashMap<String, StringBuilder> linkedHashMap = map;
            return linkedHashMap;
        }
        catch (Throwable e) {
            this.errMsg = "Error occurred while processing. " + e.getMessage();
            log.error((Object)this.errMsg, e);
            throw new Exception(this.errMsg, e);
        }
        finally {
            if (!executionPlanRuntime.equals(null)) {
                executionPlanRuntime.shutdown();
            }
        }
    }

    private long createTimeStamp(String dateTime) throws Exception {
        Date date;
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        try {
            date = dateFormatter.parse(dateTime);
        }
        catch (Exception e) {
            this.errMsg = "Error occurred while parsing date " + e.getMessage();
            log.error((Object)this.errMsg, (Throwable)e);
            throw new Exception(this.errMsg, e);
        }
        long timeStamp = date.getTime();
        return timeStamp;
    }

    public static void loadDataSourceConfiguration(SiddhiManager siddhiManager) {
        try {
            int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
            if (tenantId > -1) {
                DataSourceManager.getInstance().initTenant(tenantId);
            }
            List dataSources = SiddhiTryItValueHolder.getDataSourceService().getAllDataSources();
            for (CarbonDataSource cds : dataSources) {
                try {
                    if (!(cds.getDSObject() instanceof DataSource)) continue;
                    siddhiManager.setDataSource(cds.getDSMInfo().getName(), (DataSource)cds.getDSObject());
                }
                catch (Exception e) {
                    log.error((Object)("Unable to add the datasource" + cds.getDSMInfo().getName()), (Throwable)e);
                }
            }
        }
        catch (DataSourceException e) {
            log.error((Object)"Unable to populate the data sources in Siddhi engine.", (Throwable)e);
        }
    }
}

