/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheConfiguration;
import javax.cache.CacheEntryInfo;
import javax.cache.CacheInvalidationRequestSender;
import javax.cache.CacheLoader;
import javax.cache.CacheManager;
import javax.cache.CacheStatistics;
import javax.cache.Status;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryReadListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.mbeans.CacheMXBean;
import javax.cache.transaction.IsolationLevel;
import javax.cache.transaction.Mode;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.caching.impl.CacheConfigurationImpl;
import org.wso2.carbon.caching.impl.CacheEntry;
import org.wso2.carbon.caching.impl.CacheEntryEventImpl;
import org.wso2.carbon.caching.impl.CacheMXBeanImpl;
import org.wso2.carbon.caching.impl.CacheManagerFactoryImpl;
import org.wso2.carbon.caching.impl.CacheStatisticsImpl;
import org.wso2.carbon.caching.impl.CachingConstants;
import org.wso2.carbon.caching.impl.DataHolder;
import org.wso2.carbon.caching.impl.DistributedMapProvider;
import org.wso2.carbon.caching.impl.MapEntryListener;
import org.wso2.carbon.caching.impl.Util;
import org.wso2.carbon.caching.impl.eviction.EvictionAlgorithm;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;

public class CacheImpl<K, V>
implements Cache<K, V> {
    private static final Log log = LogFactory.getLog(CacheImpl.class);
    private static final long MAX_CLEANUP_TIME = 60000L;
    private static final int CACHE_LOADER_THREADS = 2;
    private static final float CACHE_OVERCAPACITY_FACTOR = 0.75f;
    private static final float CACHE_EVICTION_FACTOR = 0.25f;
    private String cacheName;
    private CacheManager cacheManager;
    private boolean isLocalCache;
    private Map<K, CacheEntry<K, V>> distributedCache;
    private Map<K, Long> distributedTimestampMap;
    private Map<K, Long> localTimestampMap = new ConcurrentHashMap<K, Long>();
    private long capacity = 10000L;
    private int initialCapacity = 1000;
    private final Map<K, CacheEntry<K, V>> localCache = new ConcurrentHashMap<K, CacheEntry<K, V>>(this.initialCapacity, 0.75f, 50);
    private CacheConfiguration<K, V> cacheConfiguration;
    private List<CacheEntryListener> cacheEntryListeners = new ArrayList<CacheEntryListener>();
    private Status status;
    private CacheStatisticsImpl cacheStatistics;
    private ObjectName cacheMXBeanObjName;
    private final ExecutorService cacheLoadExecService = Executors.newFixedThreadPool(2);
    private String ownerTenantDomain;
    private int ownerTenantId;
    private long lastAccessed = System.currentTimeMillis();
    private EvictionAlgorithm evictionAlgorithm = CachingConstants.DEFAULT_EVICTION_ALGORITHM;
    private boolean forceLocalCache;

    public CacheImpl(String cacheName, CacheManager cacheManager) {
        CarbonContext carbonContext = CarbonContext.getThreadLocalCarbonContext();
        if (carbonContext == null) {
            throw new IllegalStateException("CarbonContext cannot be null");
        }
        this.ownerTenantDomain = carbonContext.getTenantDomain();
        if (this.ownerTenantDomain == null) {
            throw new IllegalStateException("Tenant domain cannot be null");
        }
        this.ownerTenantId = carbonContext.getTenantId();
        if (this.ownerTenantId == -1) {
            throw new IllegalStateException("Tenant ID cannot be " + this.ownerTenantId);
        }
        this.cacheName = cacheName;
        this.cacheManager = cacheManager;
        DistributedMapProvider distributedMapProvider = DataHolder.getInstance().getDistributedMapProvider();
        if (ServerConfiguration.getInstance().getFirstProperty("Cache.ForceLocalCache") != null && ServerConfiguration.getInstance().getFirstProperty("Cache.ForceLocalCache").equals("true")) {
            this.isLocalCache = true;
            this.forceLocalCache = true;
            this.cacheName = cacheName.startsWith("$__local__$.") ? cacheName : "$__local__$." + cacheName;
            this.cacheEntryListeners.addAll(DataHolder.getInstance().getCacheEntryListeners());
        } else if (this.isLocalCache(cacheName, distributedMapProvider)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Using local cache");
            }
            this.isLocalCache = true;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Using Hazelcast based distributed cache");
            }
            this.distributedCache = distributedMapProvider.getMap(Util.getDistributedMapNameOfCache(cacheName, this.ownerTenantDomain, cacheManager.getName()), new MapEntryListenerImpl());
            this.distributedTimestampMap = distributedMapProvider.getMap(Util.getDistributedMapNameOfCache("$_timestamp_$" + cacheName, this.ownerTenantDomain, cacheManager.getName()), new TimestampMapEntryListenerImpl());
        }
        this.cacheStatistics = new CacheStatisticsImpl();
        this.registerMBean();
        CacheManagerFactoryImpl.addCacheForMonitoring(this);
        this.status = Status.STARTED;
    }

    private boolean isLocalCache(String cacheName, DistributedMapProvider distributedMapProvider) {
        return cacheName.contains("$__local__$.") || distributedMapProvider == null;
    }

    void switchToDistributedMode() {
        DistributedMapProvider distributedMapProvider = DataHolder.getInstance().getDistributedMapProvider();
        if (this.isLocalCache(this.cacheName, distributedMapProvider)) {
            return;
        }
        this.distributedCache = distributedMapProvider.getMap(Util.getDistributedMapNameOfCache(this.cacheName, this.ownerTenantDomain, this.cacheManager.getName()), new MapEntryListenerImpl());
        this.distributedTimestampMap = distributedMapProvider.getMap(Util.getDistributedMapNameOfCache("$_timestamp_$" + this.cacheName, this.ownerTenantDomain, this.cacheManager.getName()), new TimestampMapEntryListenerImpl());
        this.isLocalCache = false;
        for (Map.Entry<K, CacheEntry<K, V>> entry : this.localCache.entrySet()) {
            this.distributedCache.put(entry.getKey(), entry.getValue());
        }
    }

    private MBeanServer getMBeanServer() {
        MBeanServer mserver = MBeanServerFactory.findMBeanServer(null).size() > 0 ? MBeanServerFactory.findMBeanServer(null).get(0) : MBeanServerFactory.createMBeanServer();
        return mserver;
    }

    private void registerMBean() {
        String serverPackage = "org.wso2.carbon";
        try {
            String objectName = serverPackage + ":type=Cache,tenant=" + this.ownerTenantDomain + ",manager=" + this.cacheManager.getName() + ",name=" + this.cacheName;
            MBeanServer mserver = this.getMBeanServer();
            this.cacheMXBeanObjName = new ObjectName(objectName);
            Set<ObjectName> set = mserver.queryNames(new ObjectName(objectName), null);
            if (set.isEmpty()) {
                CacheMXBeanImpl cacheMXBean = new CacheMXBeanImpl(this, this.ownerTenantDomain, this.ownerTenantId);
                mserver.registerMBean(cacheMXBean, this.cacheMXBeanObjName);
            }
        }
        catch (Exception e) {
            String msg = "Could not register CacheMXBeanImpl MBean";
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    @Override
    public V get(K key) {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.checkStatusStarted();
        this.lastAccessed = System.currentTimeMillis();
        CacheEntry<K, V> entry = this.localCache.get(key);
        V value = null;
        if (entry != null) {
            value = entry.getValue();
            if (!this.isLocalCache) {
                this.localTimestampMap.put(key, this.lastAccessed);
            }
            this.notifyCacheEntryRead(key, value);
        } else if (!this.isLocalCache && (entry = this.distributedCache.get(key)) != null) {
            entry.setLastAccessed(this.lastAccessed);
            this.localCache.put(key, entry);
            value = entry.getValue();
            this.localTimestampMap.put(key, this.lastAccessed);
            this.notifyCacheEntryRead(key, value);
        }
        return value;
    }

    @Override
    public Map<K, V> getAll(Set<? extends K> keys) {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.checkStatusStarted();
        this.lastAccessed = System.currentTimeMillis();
        Map<K, CacheEntry<K, V>> source = this.localCache;
        HashMap<K, V> destination = new HashMap<K, V>(keys.size());
        for (K key : keys) {
            destination.put(key, source.get(key).getValue());
        }
        return destination;
    }

    public void syncCaches() {
        if (!this.isLocalCache) {
            for (Map.Entry<K, CacheEntry<K, V>> entry : this.distributedCache.entrySet()) {
                K key = entry.getKey();
                CacheEntry<K, V> value = entry.getValue();
                if (this.localCache.containsKey(key) && value.getLastModified() <= this.localCache.get(key).getLastModified()) continue;
                this.localCache.put(key, value);
                this.distributedTimestampMap.put(key, value.getLastAccessed());
            }
        }
    }

    public Collection<CacheEntry<K, V>> getAll() {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.checkStatusStarted();
        return this.localCache.values();
    }

    @Override
    public boolean containsKey(K key) {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.checkStatusStarted();
        this.lastAccessed = System.currentTimeMillis();
        boolean containsKey = this.localCache.containsKey(key);
        if (!containsKey && !this.isLocalCache && (containsKey = this.distributedCache.containsKey(key))) {
            CacheEntry<K, V> value = this.distributedCache.get(key);
            if (value != null) {
                if (this.distributedTimestampMap.containsKey(key)) {
                    Long distributedLastAccessed = this.distributedTimestampMap.get(key);
                    this.setLastAccessed(value, distributedLastAccessed);
                }
                this.localCache.put(key, value);
            } else {
                if (this.distributedCache.containsKey(key)) {
                    // empty if block
                }
                containsKey = false;
            }
        }
        return containsKey;
    }

    private void setLastAccessed(CacheEntry<K, V> value, Long distributedLastAccessed) {
        if (distributedLastAccessed != null && distributedLastAccessed > value.getLastAccessed()) {
            value.setLastAccessed(distributedLastAccessed);
        } else {
            value.setLastAccessed(System.currentTimeMillis());
        }
    }

    @Override
    public Future<V> load(K key) {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.checkStatusStarted();
        this.lastAccessed = System.currentTimeMillis();
        CacheLoader<K, V> cacheLoader = this.cacheConfiguration.getCacheLoader();
        if (cacheLoader == null) {
            return null;
        }
        if (this.containsKey(key)) {
            return null;
        }
        CarbonContext carbonContext = CarbonContext.getThreadLocalCarbonContext();
        FutureTask task = new FutureTask(new CacheLoaderLoadCallable<K, V>(this, cacheLoader, key, carbonContext.getTenantDomain(), carbonContext.getTenantId()));
        this.cacheLoadExecService.submit(task);
        return task;
    }

    private void checkStatusStarted() {
        if (!this.status.equals((Object)Status.STARTED)) {
            throw new IllegalStateException("The cache status is not STARTED");
        }
    }

    @Override
    public Future<Map<K, ? extends V>> loadAll(Set<? extends K> keys) {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.checkStatusStarted();
        this.lastAccessed = System.currentTimeMillis();
        if (keys == null) {
            throw new NullPointerException("keys");
        }
        CacheLoader<K, V> cacheLoader = this.cacheConfiguration.getCacheLoader();
        if (cacheLoader == null) {
            return null;
        }
        if (keys.contains(null)) {
            throw new NullPointerException("key");
        }
        CarbonContext carbonContext = CarbonContext.getThreadLocalCarbonContext();
        CacheLoaderLoadAllCallable<? extends K, V> callable = new CacheLoaderLoadAllCallable<K, V>(this, cacheLoader, keys, carbonContext.getTenantDomain(), carbonContext.getTenantId());
        FutureTask<Map<K, ? extends V>> task = new FutureTask<Map<K, ? extends V>>(callable);
        this.cacheLoadExecService.submit(task);
        return task;
    }

    @Override
    public CacheStatistics getStatistics() {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.checkStatusStarted();
        this.lastAccessed = System.currentTimeMillis();
        return this.cacheStatistics;
    }

    private void internalPut(K key, V value) {
        if ((float)this.localCache.size() >= (float)this.capacity * 1.75f) {
            return;
        }
        this.localCache.put(key, new CacheEntry<K, V>(key, value));
        if (!this.isLocalCache) {
            this.distributedCache.put(key, new CacheEntry<K, V>(key, value));
        }
    }

    @Override
    public void put(K key, V value) {
        Object oldValue;
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.checkStatusStarted();
        this.lastAccessed = System.currentTimeMillis();
        CacheEntry<K, V> entry = this.localCache.get(key);
        Object v0 = oldValue = entry != null ? entry.getValue() : null;
        if (oldValue == null) {
            this.internalPut(key, value);
            this.notifyCacheEntryCreated(key, value);
        } else {
            entry.setValue(value);
            this.internalPut(key, value);
            this.notifyCacheEntryUpdated(key, value);
        }
    }

    private void notifyCacheEntryCreated(K key, V value) {
        CacheEntryEvent event = this.createCacheEntryEvent(key, value);
        for (CacheEntryListener cacheEntryListener : this.cacheEntryListeners) {
            if (!(cacheEntryListener instanceof CacheEntryCreatedListener)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Notification event trigger for cache entry create : " + cacheEntryListener.getClass()));
            }
            ((CacheEntryCreatedListener)cacheEntryListener).entryCreated(event);
        }
    }

    private void notifyCacheEntryUpdated(K key, V value) {
        CacheEntryEvent event = this.createCacheEntryEvent(key, value);
        for (CacheEntryListener cacheEntryListener : this.cacheEntryListeners) {
            if (!(cacheEntryListener instanceof CacheEntryUpdatedListener)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Notification event trigger for cache entry update : " + cacheEntryListener.getClass()));
            }
            ((CacheEntryUpdatedListener)cacheEntryListener).entryUpdated(event);
        }
    }

    private void notifyCacheEntryRead(K key, V value) {
        CacheEntryEvent event = this.createCacheEntryEvent(key, value);
        for (CacheEntryListener cacheEntryListener : this.cacheEntryListeners) {
            if (!(cacheEntryListener instanceof CacheEntryReadListener)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Notification event trigger for cache entry read : " + cacheEntryListener.getClass()));
            }
            ((CacheEntryReadListener)cacheEntryListener).entryRead(event);
        }
    }

    private void notifyCacheEntryRemoved(K key, V value) {
        CacheEntryEvent event = this.createCacheEntryEvent(key, value);
        for (CacheEntryListener cacheEntryListener : this.cacheEntryListeners) {
            if (!(cacheEntryListener instanceof CacheEntryRemovedListener) || cacheEntryListener instanceof CacheInvalidationRequestSender) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Notification event trigger for cache entry remove : " + cacheEntryListener.getClass()));
            }
            ((CacheEntryRemovedListener)cacheEntryListener).entryRemoved(event);
        }
    }

    private void notifyCacheEntryExpired(K key, V value) {
        CacheEntryEvent event = this.createCacheEntryEvent(key, value);
        for (CacheEntryListener cacheEntryListener : this.cacheEntryListeners) {
            if (!(cacheEntryListener instanceof CacheEntryExpiredListener)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Notification event trigger for cache entry expired : " + cacheEntryListener.getClass()));
            }
            ((CacheEntryExpiredListener)cacheEntryListener).entryExpired(event);
        }
    }

    private CacheEntryEvent createCacheEntryEvent(K key, V value) {
        CacheEntryEventImpl event = new CacheEntryEventImpl(this);
        event.setKey(key);
        event.setValue(value);
        return event;
    }

    @Override
    public V getAndPut(K key, V value) {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.checkStatusStarted();
        this.lastAccessed = System.currentTimeMillis();
        V oldValue = this.localCache.get(key).getValue();
        this.put(key, value);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.checkStatusStarted();
        this.lastAccessed = System.currentTimeMillis();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            boolean entryExists = false;
            if (this.localCache.containsKey(key)) {
                entryExists = true;
            }
            V value = entry.getValue();
            this.internalPut(key, value);
            if (entryExists) {
                this.notifyCacheEntryUpdated(key, value);
                continue;
            }
            this.notifyCacheEntryCreated(key, value);
        }
    }

    @Override
    public boolean putIfAbsent(K key, V value) {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.checkStatusStarted();
        this.lastAccessed = System.currentTimeMillis();
        if (!this.localCache.containsKey(key)) {
            this.internalPut(key, value);
            this.notifyCacheEntryCreated(key, value);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object key) {
        boolean removed = this.removeLocal(key);
        if (this.cacheName.startsWith("$__local__$.") && this.forceLocalCache) {
            CacheEntryEvent cacheEntryEvent = this.createCacheEntryEvent(key, null);
            CacheEntryInfo cacheInfo = Util.createCacheInfo(cacheEntryEvent);
            DataHolder.getInstance().getConfiguredCacheInvalidationSender().send(cacheInfo);
        }
        return removed;
    }

    public boolean removeLocal(Object key) {
        boolean removed;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Initiating to remove local cache with key : " + key));
        }
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.checkStatusStarted();
        this.lastAccessed = System.currentTimeMillis();
        CacheEntry<K, V> entry = this.localCache.remove(key);
        if (!this.isLocalCache) {
            this.distributedCache.remove(key);
            this.distributedTimestampMap.remove(key);
            this.localTimestampMap.remove(key);
        }
        boolean bl = removed = entry != null;
        if (removed) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Initiating cache entry removal for cache with key : " + key + "and tenant domain: " + this.ownerTenantDomain));
            }
            this.notifyCacheEntryRemoved(key, entry.getValue());
        }
        return this.localCache.get(key) == null;
    }

    @Override
    public boolean remove(K key, V oldValue) {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.checkStatusStarted();
        this.lastAccessed = System.currentTimeMillis();
        CacheEntry<K, V> cacheEntry = this.localCache.remove(key);
        if (!this.isLocalCache) {
            this.distributedCache.remove(key);
            this.distributedTimestampMap.remove(key);
            this.localTimestampMap.remove(key);
        }
        this.notifyCacheEntryRemoved(key, oldValue);
        return this.localCache.get(key) == null;
    }

    @Override
    public V getAndRemove(K key) {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.checkStatusStarted();
        this.lastAccessed = System.currentTimeMillis();
        CacheEntry<K, V> entry = this.localCache.remove(key);
        if (!this.isLocalCache) {
            this.distributedCache.remove(key);
            this.distributedTimestampMap.remove(key);
            this.localTimestampMap.remove(key);
        }
        if (entry != null) {
            V value = entry.getValue();
            this.notifyCacheEntryRemoved(key, value);
            return value;
        }
        return null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.checkStatusStarted();
        this.lastAccessed = System.currentTimeMillis();
        Map<K, CacheEntry<K, V>> map = this.localCache;
        if (map.containsKey(key) && map.get(key).equals(new CacheEntry<K, V>(key, oldValue))) {
            this.internalPut(key, newValue);
            this.notifyCacheEntryUpdated(key, newValue);
            return true;
        }
        return false;
    }

    @Override
    public boolean replace(K key, V value) {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.checkStatusStarted();
        this.lastAccessed = System.currentTimeMillis();
        Map<K, CacheEntry<K, V>> map = this.localCache;
        if (map.containsKey(key)) {
            this.internalPut(key, value);
            this.notifyCacheEntryUpdated(key, value);
            return true;
        }
        return false;
    }

    @Override
    public V getAndReplace(K key, V value) {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.checkStatusStarted();
        this.lastAccessed = System.currentTimeMillis();
        Map<K, CacheEntry<K, V>> map = this.localCache;
        CacheEntry<K, V> oldValue = map.get(key);
        if (oldValue != null) {
            this.internalPut(key, value);
            this.notifyCacheEntryUpdated(key, value);
            return oldValue.getValue();
        }
        return null;
    }

    @Override
    public void removeAll(Set<? extends K> keys) {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.checkStatusStarted();
        this.lastAccessed = System.currentTimeMillis();
        Map<K, CacheEntry<K, V>> map = this.localCache;
        for (K key : keys) {
            CacheEntry<K, V> entry = map.remove(key);
            if (!this.isLocalCache) {
                this.distributedCache.remove(key);
                this.distributedTimestampMap.remove(key);
            }
            this.notifyCacheEntryRemoved(key, entry.getValue());
        }
    }

    @Override
    public void removeAll() {
        this.removeAllLocal();
        if (this.cacheName.startsWith("$__local__$.") && this.forceLocalCache) {
            CacheEntryEvent cacheEntryEvent = this.createCacheEntryEvent("$__clear__all__$.", null);
            CacheEntryInfo cacheInfo = Util.createCacheInfo(cacheEntryEvent);
            DataHolder.getInstance().getConfiguredCacheInvalidationSender().send(cacheInfo);
        }
    }

    public void removeAllLocal() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initiating to remove all local cache");
        }
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.checkStatusStarted();
        this.lastAccessed = System.currentTimeMillis();
        Map<K, CacheEntry<K, V>> map = this.localCache;
        for (Map.Entry<K, CacheEntry<K, V>> entry : map.entrySet()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing all cache entries from the cache : " + this.cacheName));
            }
            this.notifyCacheEntryRemoved(entry.getKey(), entry.getValue().getValue());
        }
        map.clear();
        if (!this.isLocalCache) {
            this.distributedCache.clear();
            this.distributedTimestampMap.clear();
        }
    }

    @Override
    public CacheConfiguration<K, V> getConfiguration() {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        if (this.cacheConfiguration == null) {
            this.cacheConfiguration = this.getDefaultCacheConfiguration();
        }
        return this.cacheConfiguration;
    }

    private CacheConfiguration<K, V> getDefaultCacheConfiguration() {
        return new CacheConfigurationImpl(true, true, true, true, IsolationLevel.NONE, Mode.NONE, new CacheConfiguration.Duration[]{new CacheConfiguration.Duration(TimeUnit.MINUTES, Util.getDefaultCacheTimeout()), new CacheConfiguration.Duration(TimeUnit.MINUTES, Util.getDefaultCacheTimeout())});
    }

    @Override
    public boolean registerCacheEntryListener(CacheEntryListener<? super K, ? super V> cacheEntryListener) {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.lastAccessed = System.currentTimeMillis();
        return this.cacheEntryListeners.add(cacheEntryListener);
    }

    @Override
    public boolean unregisterCacheEntryListener(CacheEntryListener<?, ?> cacheEntryListener) {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.lastAccessed = System.currentTimeMillis();
        return this.cacheEntryListeners.remove(cacheEntryListener);
    }

    @Override
    public Object invokeEntryProcessor(K key, Cache.EntryProcessor<K, V> entryProcessor) {
        this.lastAccessed = System.currentTimeMillis();
        return entryProcessor.process(new Cache.MutableEntry<K, V>(){

            @Override
            public boolean exists() {
                return false;
            }

            @Override
            public void remove() {
            }

            @Override
            public void setValue(V value) {
            }

            @Override
            public K getKey() {
                return null;
            }

            @Override
            public V getValue() {
                return null;
            }
        });
    }

    @Override
    public String getName() {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        return this.cacheName;
    }

    @Override
    public CacheManager getCacheManager() {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.lastAccessed = System.currentTimeMillis();
        return this.cacheManager;
    }

    @Override
    public <T> T unwrap(Class<T> cls) {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.lastAccessed = System.currentTimeMillis();
        if (cls.isAssignableFrom(this.getClass())) {
            return cls.cast(this);
        }
        throw new IllegalArgumentException("Unwrapping to " + cls + " is not a supported by this implementation");
    }

    @Override
    public Iterator<K> keys() {
        return this.localCache.keySet().iterator();
    }

    @Override
    public Iterator<Cache.Entry<K, V>> iterator() {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.lastAccessed = System.currentTimeMillis();
        return new CacheEntryIterator<K, V>(this.localCache.values().iterator());
    }

    @Override
    public CacheMXBean getMBean() {
        throw new UnsupportedOperationException("getMBean is an ambiguous method which is not supported");
    }

    @Override
    public void start() {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.lastAccessed = System.currentTimeMillis();
        if (this.status == Status.STARTED) {
            throw new IllegalStateException();
        }
        this.status = Status.STARTED;
    }

    @Override
    public void stop() {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.checkStatusStarted();
        this.lastAccessed = System.currentTimeMillis();
        this.localCache.clear();
        if (!this.isLocalCache) {
            this.distributedCache.clear();
            this.distributedTimestampMap.clear();
        }
        MBeanServer mserver = this.getMBeanServer();
        try {
            mserver.unregisterMBean(this.cacheMXBeanObjName);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (MBeanRegistrationException e) {
            log.error((Object)"Cannot unregister CacheMXBean", (Throwable)e);
        }
        this.status = Status.STOPPED;
        this.cacheManager.removeCache(this.cacheName);
    }

    @Override
    public Status getStatus() {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        return this.status;
    }

    public void expire(K key) {
        String discardEmptyCachesProp;
        boolean discardEmptyCaches;
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        CacheEntry<K, V> entry = this.localCache.remove(key);
        if (!this.isLocalCache) {
            try {
                this.distributedCache.remove(key);
                this.distributedTimestampMap.remove(key);
                this.localTimestampMap.remove(key);
            }
            catch (Exception e) {
                log.warn((Object)("Exception occurred while expiring item from distributed cache. " + e.getMessage()));
            }
        }
        boolean bl = discardEmptyCaches = (discardEmptyCachesProp = ServerConfiguration.getInstance().getFirstProperty("Cache.DiscardEmptyCaches")) == null || Boolean.parseBoolean(discardEmptyCachesProp);
        if (discardEmptyCaches && this.isIdle()) {
            this.cacheManager.removeCache(this.cacheName);
        }
        if (entry != null) {
            this.notifyCacheEntryExpired(key, entry.getValue());
        }
    }

    public void evict(K key) {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.checkStatusStarted();
        this.localCache.remove(key);
        if (!this.isLocalCache) {
            try {
                this.distributedCache.remove(key);
                this.distributedTimestampMap.remove(key);
                this.localTimestampMap.remove(key);
            }
            catch (Exception e) {
                log.warn((Object)("Exception occurred while evicting item from distributed cache. " + e.getMessage()));
            }
        }
    }

    public void setCacheConfiguration(CacheConfigurationImpl cacheConfiguration) {
        Util.checkAccess(this.ownerTenantDomain, this.ownerTenantId);
        this.cacheConfiguration = cacheConfiguration;
    }

    public void setCapacity(long capacity) {
        this.capacity = capacity;
    }

    public void setEvictionAlgorithm(EvictionAlgorithm evictionAlgorithm) {
        this.evictionAlgorithm = evictionAlgorithm;
    }

    private boolean isIdle() {
        long timeDiff = System.currentTimeMillis() - this.lastAccessed;
        return this.localCache.isEmpty() && timeDiff >= 900000L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheImpl cache = (CacheImpl)o;
        if (this.ownerTenantId != cache.ownerTenantId) {
            return false;
        }
        if (this.cacheManager != null ? !this.cacheManager.equals(cache.cacheManager) : cache.cacheManager != null) {
            return false;
        }
        if (this.cacheName != null ? !this.cacheName.equals(cache.cacheName) : cache.cacheName != null) {
            return false;
        }
        return !(this.ownerTenantDomain != null ? !this.ownerTenantDomain.equals(cache.ownerTenantDomain) : cache.ownerTenantDomain != null);
    }

    public int hashCode() {
        int result = this.cacheName != null ? this.cacheName.hashCode() : 0;
        result = 31 * result + (this.cacheManager != null ? this.cacheManager.hashCode() : 0);
        result = 31 * result + (this.ownerTenantDomain != null ? this.ownerTenantDomain.hashCode() : 0);
        result = 31 * result + this.ownerTenantId;
        return result;
    }

    void runCacheExpiry() {
        CacheConfiguration<K, V> cacheConfiguration = this.getConfiguration();
        CacheConfiguration.Duration modifiedExpiry = cacheConfiguration.getExpiry(CacheConfiguration.ExpiryType.MODIFIED);
        long modifiedExpiryDuration = modifiedExpiry == null ? Util.getDefaultCacheTimeout() * 60L * 1000L : modifiedExpiry.getTimeUnit().toMillis(modifiedExpiry.getDurationAmount());
        CacheConfiguration.Duration accessedExpiry = cacheConfiguration.getExpiry(CacheConfiguration.ExpiryType.ACCESSED);
        long accessedExpiryDuration = accessedExpiry == null ? Util.getDefaultCacheTimeout() * 60L * 1000L : accessedExpiry.getTimeUnit().toMillis(accessedExpiry.getDurationAmount());
        Collection<CacheEntry<K, V>> cacheEntries = this.getAll();
        long evictionListSize = 0L;
        if ((long)this.localCache.size() > this.capacity) {
            evictionListSize = (long)this.localCache.size() - this.capacity;
            evictionListSize += (long)((double)this.capacity * 0.25);
        }
        TreeSet<CacheEntry> evictionList = new TreeSet<CacheEntry>(new Comparator<CacheEntry>(){

            @Override
            public int compare(CacheEntry o1, CacheEntry o2) {
                if (o1.getLastAccessed() == o2.getLastAccessed()) {
                    if (o1.getKey().equals(o2.getKey())) {
                        return 0;
                    }
                    return -1;
                }
                return (int)(o1.getLastAccessed() - o2.getLastAccessed());
            }
        });
        long start = System.currentTimeMillis();
        for (CacheEntry<K, V> cacheEntry : cacheEntries) {
            K key = cacheEntry.getKey();
            if ((long)this.localCache.size() >= this.capacity) {
                evictionList.add(cacheEntry);
            }
            long lastAccessed = cacheEntry.getLastAccessed();
            long lastModified = cacheEntry.getLastModified();
            long now = System.currentTimeMillis();
            if (now - lastAccessed < accessedExpiryDuration && now - lastModified < modifiedExpiryDuration) continue;
            this.expire(key);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Expired: Cache:" + this.cacheName + ", entry:" + key));
            }
            if (System.currentTimeMillis() - start <= 60000L) continue;
            break;
        }
        if ((long)this.localCache.size() >= this.capacity) {
            start = System.currentTimeMillis();
            int i = 0;
            while ((long)i < evictionListSize) {
                CacheEntry cacheEntry = this.evictionAlgorithm.getEntryForEviction(evictionList);
                if (cacheEntry != null) {
                    this.evict(cacheEntry.getKey());
                }
                if (System.currentTimeMillis() - start > 60000L) break;
                ++i;
            }
            log.info((Object)("Evicted " + evictionListSize + " entries from cache " + this.cacheName));
        }
        if (!this.isLocalCache) {
            for (Map.Entry entry : this.localTimestampMap.entrySet()) {
                Long oldValue = (Long)entry.getValue();
                this.distributedTimestampMap.put(entry.getKey(), oldValue);
                Long newValue = (Long)entry.getValue();
                if (!newValue.equals(oldValue)) continue;
                this.localTimestampMap.remove(entry.getKey());
            }
        }
    }

    private class TimestampMapEntryListenerImpl
    implements MapEntryListener {
        private TimestampMapEntryListenerImpl() {
        }

        @Override
        public <X> void entryAdded(X key) {
            if (!CacheImpl.this.localCache.containsKey(key) || CacheImpl.this.distributedTimestampMap == null) {
                return;
            }
            CacheEntry value = (CacheEntry)CacheImpl.this.localCache.get(key);
            if (value != null) {
                Long timeStamp = (Long)CacheImpl.this.distributedTimestampMap.get(key);
                if (timeStamp != null) {
                    value.setLastAccessed(timeStamp);
                } else {
                    value.setLastAccessed(new Date().getTime());
                }
            }
        }

        @Override
        public <X> void entryRemoved(X key) {
        }

        @Override
        public <X> void entryUpdated(X key) {
            if (!CacheImpl.this.localCache.containsKey(key) || CacheImpl.this.distributedTimestampMap == null) {
                return;
            }
            CacheEntry value = (CacheEntry)CacheImpl.this.localCache.get(key);
            if (value != null) {
                Long timeStamp = (Long)CacheImpl.this.distributedTimestampMap.get(key);
                if (timeStamp != null) {
                    value.setLastAccessed(timeStamp);
                } else {
                    value.setLastAccessed(new Date().getTime());
                }
            }
        }

        @Override
        public void mapCleared() {
            CacheImpl.this.localCache.clear();
        }
    }

    private class MapEntryListenerImpl
    implements MapEntryListener {
        private MapEntryListenerImpl() {
        }

        @Override
        public <X> void entryAdded(X key) {
            if (CacheImpl.this.distributedCache == null) {
                return;
            }
            CacheEntry value = (CacheEntry)CacheImpl.this.distributedCache.get(key);
            if (value != null) {
                CacheImpl.this.notifyCacheEntryCreated(value.getKey(), value.getValue());
            }
            if (!CacheImpl.this.localCache.containsKey(key)) {
                return;
            }
            if (value != null) {
                if (CacheImpl.this.distributedTimestampMap.containsKey(key)) {
                    Long distributedLastAccessed = (Long)CacheImpl.this.distributedTimestampMap.get(key);
                    CacheImpl.this.setLastAccessed(value, distributedLastAccessed);
                } else {
                    CacheImpl.this.distributedTimestampMap.put(key, value.getLastAccessed());
                }
                CacheImpl.this.localCache.put(key, value);
            }
        }

        @Override
        public void mapCleared() {
            CacheImpl.this.localCache.clear();
        }

        @Override
        public <X> void entryRemoved(X key) {
            if (CacheImpl.this.distributedCache == null) {
                return;
            }
            CacheEntry value = (CacheEntry)CacheImpl.this.distributedCache.get(key);
            if (value != null) {
                CacheImpl.this.notifyCacheEntryRemoved(value.getKey(), value.getValue());
            }
            CacheImpl.this.localCache.remove(key);
        }

        @Override
        public <X> void entryUpdated(X key) {
            if (CacheImpl.this.distributedCache == null) {
                return;
            }
            CacheEntry value = (CacheEntry)CacheImpl.this.distributedCache.get(key);
            if (value != null) {
                CacheImpl.this.notifyCacheEntryUpdated(value.getKey(), value.getValue());
            }
            if (!CacheImpl.this.localCache.containsKey(key)) {
                return;
            }
            if (value != null) {
                if (CacheImpl.this.distributedTimestampMap.containsKey(key)) {
                    Long distributedLastAccessed = (Long)CacheImpl.this.distributedTimestampMap.get(key);
                    CacheImpl.this.setLastAccessed(value, distributedLastAccessed);
                } else {
                    CacheImpl.this.distributedTimestampMap.put(key, value.getLastAccessed());
                }
                CacheImpl.this.localCache.put(key, value);
            }
        }
    }

    private static class CacheLoaderLoadAllCallable<K, V>
    implements Callable<Map<K, ? extends V>> {
        private final CacheImpl<K, V> cache;
        private final CacheLoader<K, ? extends V> cacheLoader;
        private final Collection<? extends K> keys;
        private final String tenantDomain;
        private final int tenantId;

        CacheLoaderLoadAllCallable(CacheImpl<K, V> cache, CacheLoader<K, ? extends V> cacheLoader, Collection<? extends K> keys, String tenantDomain, int tenantId) {
            this.cache = cache;
            this.cacheLoader = cacheLoader;
            this.keys = keys;
            this.tenantDomain = tenantDomain;
            this.tenantId = tenantId;
        }

        @Override
        public Map<K, ? extends V> call() throws Exception {
            Map<K, ? extends V> value;
            try {
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                carbonContext.setTenantDomain(this.tenantDomain);
                carbonContext.setTenantId(this.tenantId);
                ArrayList<K> keysNotInStore = new ArrayList<K>();
                for (K key : this.keys) {
                    if (this.cache.containsKey(key)) continue;
                    keysNotInStore.add(key);
                }
                value = this.cacheLoader.loadAll(keysNotInStore);
                this.cache.putAll(value);
            }
            catch (Exception e) {
                log.error((Object)("Could not load all cache items into cache " + this.cache.getName() + " owned by tenant "), (Throwable)e);
                throw e;
            }
            return value;
        }
    }

    private class TimestampReplicateTask
    implements Runnable {
        private TimestampReplicateTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!CacheImpl.this.isLocalCache && CacheImpl.this.localTimestampMap != null && CacheImpl.this.localTimestampMap.size() > 0) {
                Iterator iterator = CacheImpl.this.localTimestampMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Object k = entry.getKey();
                    synchronized (k) {
                        CacheImpl.this.distributedTimestampMap.put(entry.getKey(), (Long)entry.getValue());
                        iterator.remove();
                    }
                }
            }
        }
    }

    private static class CacheLoaderLoadCallable<K, V>
    implements Callable<V> {
        private final CacheImpl<K, V> cache;
        private final CacheLoader<K, ? extends V> cacheLoader;
        private final K key;
        private final String tenantDomain;
        private final int tenantId;

        CacheLoaderLoadCallable(CacheImpl<K, V> cache, CacheLoader<K, ? extends V> cacheLoader, K key, String tenantDomain, int tenantId) {
            this.cache = cache;
            this.cacheLoader = cacheLoader;
            this.key = key;
            this.tenantDomain = tenantDomain;
            this.tenantId = tenantId;
        }

        @Override
        public V call() throws Exception {
            Cache.Entry<K, V> entry;
            try {
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                carbonContext.setTenantDomain(this.tenantDomain);
                carbonContext.setTenantId(this.tenantId);
                entry = this.cacheLoader.load(this.key);
                this.cache.put(entry.getKey(), entry.getValue());
            }
            catch (Exception e) {
                log.error((Object)("Could not load cache item with key " + this.key + " into cache " + this.cache.getName() + " owned by tenant "), (Throwable)e);
                throw e;
            }
            return entry.getValue();
        }
    }

    private static final class CacheEntryIterator<K, V>
    implements Iterator<Cache.Entry<K, V>> {
        private Iterator<CacheEntry<K, V>> iterator;

        public CacheEntryIterator(Iterator<CacheEntry<K, V>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Cache.Entry<K, V> next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

