/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.impl;

import javax.cache.Cache;
import javax.cache.CacheBuilder;
import javax.cache.CacheConfiguration;
import javax.cache.CacheLoader;
import javax.cache.CacheWriter;
import javax.cache.Caching;
import javax.cache.InvalidConfigurationException;
import javax.cache.OptionalFeature;
import javax.cache.event.CacheEntryListener;
import javax.cache.transaction.IsolationLevel;
import javax.cache.transaction.Mode;
import org.wso2.carbon.caching.impl.CacheConfigurationImpl;
import org.wso2.carbon.caching.impl.CacheImpl;
import org.wso2.carbon.caching.impl.CarbonCacheManager;

public class CacheBuilderImpl<K, V>
implements CacheBuilder<K, V> {
    private CacheConfigurationImpl cacheConfiguration = new CacheConfigurationImpl();
    private String cacheName;
    private CarbonCacheManager cacheManager;
    private CacheImpl<K, V> cache;

    public CacheBuilderImpl(String cacheName, CarbonCacheManager cacheManager) {
        this.cacheName = cacheName;
        this.cacheManager = cacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cache<K, V> build() {
        this.cache = (CacheImpl)this.cacheManager.getExistingCache(this.cacheName);
        if (this.cache == null) {
            String string = this.cacheName.intern();
            synchronized (string) {
                this.cache = (CacheImpl)this.cacheManager.getExistingCache(this.cacheName);
                if (this.cache == null) {
                    this.cache = new CacheImpl(this.cacheName, this.cacheManager);
                    this.cache.setCacheConfiguration(this.cacheConfiguration);
                    this.cacheManager.addCache(this.cache);
                }
            }
        }
        return this.cache;
    }

    @Override
    public CacheBuilder<K, V> setCacheLoader(CacheLoader<K, ? extends V> cacheLoader) {
        this.cacheConfiguration.setCacheLoader(cacheLoader);
        return this;
    }

    @Override
    public CacheBuilder<K, V> setCacheWriter(CacheWriter<? super K, ? super V> cacheWriter) {
        this.cacheConfiguration.setCacheWriter(cacheWriter);
        return this;
    }

    @Override
    public CacheBuilder<K, V> registerCacheEntryListener(CacheEntryListener<K, V> cacheEntryListener) {
        this.cache.registerCacheEntryListener(cacheEntryListener);
        return this;
    }

    @Override
    public CacheBuilder<K, V> setStoreByValue(boolean storeByValue) {
        if (!storeByValue && !Caching.isSupported(OptionalFeature.STORE_BY_REFERENCE)) {
            throw new InvalidConfigurationException("storeByValue");
        }
        this.cacheConfiguration.setStoreByValue(storeByValue);
        return this;
    }

    @Override
    public CacheBuilder<K, V> setTransactionEnabled(IsolationLevel isolationLevel, Mode mode) {
        if (!Caching.isSupported(OptionalFeature.TRANSACTIONS)) {
            throw new InvalidConfigurationException("transactionsEnabled");
        }
        this.cacheConfiguration.setTransactionMode(mode);
        this.cacheConfiguration.setIsolationLevel(isolationLevel);
        return this;
    }

    @Override
    public CacheBuilder<K, V> setStatisticsEnabled(boolean enableStatistics) {
        this.cacheConfiguration.setStatisticsEnabled(enableStatistics);
        return this;
    }

    @Override
    public CacheBuilder<K, V> setReadThrough(boolean readThrough) {
        this.cacheConfiguration.setReadThrough(readThrough);
        return this;
    }

    @Override
    public CacheBuilder<K, V> setWriteThrough(boolean writeThrough) {
        this.cacheConfiguration.setWriteThrough(writeThrough);
        return this;
    }

    @Override
    public CacheBuilder<K, V> setExpiry(CacheConfiguration.ExpiryType type, CacheConfiguration.Duration duration) {
        if (type == null) {
            throw new NullPointerException("ExpiryType cannot be null");
        }
        if (duration == null) {
            throw new NullPointerException("Duration cannot be null");
        }
        this.cacheConfiguration.setExpiry(duration.getDurationAmount(), duration.getTimeUnit(), type);
        return this;
    }
}

