/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.membership.scheme.kubernetes.api;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.membership.scheme.kubernetes.api.KubernetesApiEndpoint;
import org.wso2.carbon.utils.xml.StringUtils;

public class KubernetesHttpsApiEndpoint
extends KubernetesApiEndpoint {
    private static final Log log = LogFactory.getLog(KubernetesHttpsApiEndpoint.class);

    public KubernetesHttpsApiEndpoint(URL url, boolean skipMasterSSLVerification) {
        super(url);
        if (skipMasterSSLVerification) {
            KubernetesHttpsApiEndpoint.disableCertificateValidation();
        }
    }

    @Override
    public void createConnection() throws IOException {
        log.debug((Object)"Connecting to Kubernetes API server...");
        this.connection = (HttpsURLConnection)this.url.openConnection();
        this.connection.addRequestProperty("Authorization", "Bearer " + this.getServiceAccountToken());
        log.debug((Object)"Connected successfully");
    }

    @Override
    public void createConnection(String username, String password) throws IOException {
        log.debug((Object)"Connecting to Kubernetes API server with basic auth...");
        this.connection = (HttpsURLConnection)this.url.openConnection();
        this.createBasicAuthenticationHeader(username, password);
        log.debug((Object)"Connected successfully");
    }

    @Override
    public void disconnect() {
        log.debug((Object)"Disconnecting from Kubernetes API server...");
        this.connection.disconnect();
        log.debug((Object)"Disconnected successfully");
    }

    private static void disableCertificateValidation() {
        TrustManager[] dummyTrustMgr = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        HostnameVerifier dummyHostVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, dummyTrustMgr, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(dummyHostVerifier);
        }
        catch (KeyManagementException | NoSuchAlgorithmException generalSecurityException) {
            // empty catch block
        }
    }

    private String getServiceAccountToken() throws IOException {
        String bearerTokenFileLocation = System.getenv("BEARER_TOKEN_FILE_LOCATION");
        if (StringUtils.isEmpty((String)bearerTokenFileLocation)) {
            bearerTokenFileLocation = "/var/run/secrets/kubernetes.io/serviceaccount/token";
        }
        return new String(Files.readAllBytes(Paths.get(bearerTokenFileLocation, new String[0])), StandardCharsets.UTF_8);
    }
}

