/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.membership.scheme.kubernetes.resolver;

import java.util.Map;
import java.util.Set;
import org.apache.axis2.description.Parameter;
import org.wso2.carbon.membership.scheme.kubernetes.exceptions.KubernetesMembershipSchemeException;
import org.wso2.carbon.utils.xml.StringUtils;

public abstract class AddressResolver {
    private final Map<String, Parameter> parameters;
    private String kubernetesNamespace;
    private String kubernetesServices;
    private String[] kubernetesServicesArray;

    AddressResolver(Map<String, Parameter> parameters) throws KubernetesMembershipSchemeException {
        this.parameters = parameters;
        this.initialize();
    }

    private void initialize() throws KubernetesMembershipSchemeException {
        this.kubernetesNamespace = System.getenv("KUBERNETES_NAMESPACE");
        this.kubernetesServices = System.getenv("KUBERNETES_SERVICES");
        if (StringUtils.isEmpty((String)this.kubernetesNamespace)) {
            this.kubernetesNamespace = this.getParameterValue("KUBERNETES_NAMESPACE", "default");
        }
        if (StringUtils.isEmpty((String)this.kubernetesServices)) {
            this.kubernetesServices = this.getParameterValue("KUBERNETES_SERVICES", null);
            if (StringUtils.isEmpty((String)this.kubernetesServices)) {
                throw new KubernetesMembershipSchemeException("Kubernetes services parameter not found");
            }
        }
        this.kubernetesServicesArray = this.kubernetesServices.split(",");
    }

    public abstract Set<String> resolveAddresses() throws KubernetesMembershipSchemeException;

    String getParameterValue(String parameterName, String defaultValue) throws KubernetesMembershipSchemeException {
        Parameter kubernetesServicesParam = this.parameters.get(parameterName);
        if (kubernetesServicesParam == null) {
            if (defaultValue == null) {
                throw new KubernetesMembershipSchemeException(parameterName + " parameter not found");
            }
            return defaultValue;
        }
        return (String)kubernetesServicesParam.getValue();
    }

    public Map<String, Parameter> getParameters() {
        return this.parameters;
    }

    public String getKubernetesNamespace() {
        return this.kubernetesNamespace;
    }

    public String getKubernetesServices() {
        return this.kubernetesServices;
    }

    public String[] getKubernetesServicesArray() {
        return this.kubernetesServicesArray;
    }
}

