/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.membership.scheme.kubernetes.resolver;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.membership.scheme.kubernetes.api.KubernetesApiEndpoint;
import org.wso2.carbon.membership.scheme.kubernetes.api.KubernetesHttpApiEndpoint;
import org.wso2.carbon.membership.scheme.kubernetes.api.KubernetesHttpsApiEndpoint;
import org.wso2.carbon.membership.scheme.kubernetes.domain.Address;
import org.wso2.carbon.membership.scheme.kubernetes.domain.Endpoints;
import org.wso2.carbon.membership.scheme.kubernetes.domain.Subset;
import org.wso2.carbon.membership.scheme.kubernetes.exceptions.KubernetesMembershipSchemeException;
import org.wso2.carbon.membership.scheme.kubernetes.resolver.AddressResolver;
import org.wso2.carbon.utils.xml.StringUtils;

public class ApiBasedPodIpResolver
extends AddressResolver {
    private static final Log log = LogFactory.getLog(ApiBasedPodIpResolver.class);
    private String kubernetesApiServerUrl;
    private String kubernetesMasterUsername;
    private String kubernetesMasterPassword;
    private String kubernatesMasterToken;
    private boolean skipMasterSSLVerification = false;

    public ApiBasedPodIpResolver(Map<String, Parameter> parameters) throws KubernetesMembershipSchemeException {
        super(parameters);
        this.initialize();
    }

    private void initialize() throws KubernetesMembershipSchemeException {
        this.kubernetesApiServerUrl = System.getenv("KUBERNETES_API_SERVER");
        this.kubernetesMasterUsername = System.getenv("KUBERNETES_API_SERVER_USERNAME");
        this.kubernetesMasterPassword = System.getenv("KUBERNETES_API_SERVER_PASSWORD");
        this.kubernatesMasterToken = System.getenv("KUBERNETES_API_SERVER_TOKEN");
        String skipMasterVerificationValue = System.getenv("KUBERNETES_MASTER_SKIP_SSL_VERIFICATION");
        if (StringUtils.isEmpty((String)this.kubernetesApiServerUrl)) {
            this.kubernetesApiServerUrl = this.getParameterValue("KUBERNETES_API_SERVER", "");
            if (StringUtils.isEmpty((String)this.kubernetesApiServerUrl)) {
                log.info((Object)String.format("Parameter %s not found, checking %s & %s", "KUBERNETES_API_SERVER", "KUBERNETES_SERVICE_HOST", "KUBERNETES_SERVICE_PORT_HTTPS"));
                String kubernetesServiceHost = System.getenv("KUBERNETES_SERVICE_HOST");
                if (StringUtils.isEmpty((String)kubernetesServiceHost)) {
                    throw new KubernetesMembershipSchemeException(String.format("Environment variable %s not found", "KUBERNETES_SERVICE_HOST"));
                }
                String kubernetesServiceHttpsPortStr = System.getenv("KUBERNETES_SERVICE_PORT_HTTPS");
                if (StringUtils.isEmpty((String)kubernetesServiceHttpsPortStr)) {
                    throw new KubernetesMembershipSchemeException(String.format("Environment variable %s not found", "KUBERNETES_SERVICE_PORT_HTTPS"));
                }
                int kubernetesServiceHttpsPort = Integer.parseInt(kubernetesServiceHttpsPortStr);
                try {
                    this.kubernetesApiServerUrl = new URL("https", kubernetesServiceHost, kubernetesServiceHttpsPort, "").toString();
                }
                catch (MalformedURLException e) {
                    throw new KubernetesMembershipSchemeException("Kuberneretes master API url: " + this.kubernetesApiServerUrl + " is malformed", e);
                }
            }
        }
        if (StringUtils.isEmpty((String)this.kubernetesMasterUsername)) {
            this.kubernetesMasterUsername = this.getParameterValue("KUBERNETES_API_SERVER_USERNAME", "");
        }
        if (StringUtils.isEmpty((String)this.kubernetesMasterPassword)) {
            this.kubernetesMasterPassword = this.getParameterValue("KUBERNETES_API_SERVER_PASSWORD", "");
        }
        if (StringUtils.isEmpty((String)this.kubernatesMasterToken)) {
            this.kubernatesMasterToken = this.getParameterValue("KUBERNETES_API_SERVER_TOKEN", "");
        }
        if (StringUtils.isEmpty((String)skipMasterVerificationValue)) {
            skipMasterVerificationValue = this.getParameterValue("KUBERNETES_MASTER_SKIP_SSL_VERIFICATION", "false");
        }
        this.skipMasterSSLVerification = Boolean.parseBoolean(skipMasterVerificationValue);
        log.info((Object)String.format("Kubernetes clustering configuration: [api-server] %s [namespace] %s [services] %s [skip-master-ssl-verification] %s", this.kubernetesApiServerUrl, this.getKubernetesNamespace(), this.getKubernetesServices(), this.skipMasterSSLVerification));
    }

    @Override
    public Set<String> resolveAddresses() throws KubernetesMembershipSchemeException {
        String apiContext = String.format("/api/v1/namespaces/%s/endpoints/", this.getKubernetesNamespace());
        HashSet<String> containerIPs = new HashSet<String>();
        for (String kubernetesService : this.getKubernetesServicesArray()) {
            Endpoints endpoints;
            URL apiEndpointUrl = this.createUrl(this.kubernetesApiServerUrl, apiContext + kubernetesService.trim());
            KubernetesApiEndpoint apiEndpoint = this.createAPIEndpoint(apiEndpointUrl);
            try {
                endpoints = this.getEndpoints(this.connectAndRead(apiEndpoint, this.kubernetesMasterUsername, this.kubernetesMasterPassword, this.kubernatesMasterToken));
            }
            catch (IOException e) {
                throw new KubernetesMembershipSchemeException("Could not get the Endpoints", e);
            }
            finally {
                apiEndpoint.disconnect();
            }
            if (endpoints != null) {
                if (endpoints.getSubsets() == null || endpoints.getSubsets().isEmpty()) continue;
                log.info((Object)"Reading IP addresses from endpoints");
                for (Subset subset : endpoints.getSubsets()) {
                    if (subset.getAddresses() != null) {
                        for (Address address : subset.getAddresses()) {
                            containerIPs.add(address.getIp());
                        }
                    }
                    if (subset.getNotReadyAddresses() == null) continue;
                    for (Address address : subset.getNotReadyAddresses()) {
                        containerIPs.add(address.getIp());
                    }
                }
                continue;
            }
            throw new KubernetesMembershipSchemeException("No endpoints found at " + apiEndpointUrl.toString());
        }
        return containerIPs;
    }

    private URL createUrl(String master, String context) throws KubernetesMembershipSchemeException {
        URL apiEndpointUrl;
        if (master.endsWith("/")) {
            master = master.substring(0, master.length() - 1);
        }
        try {
            apiEndpointUrl = new URL(master + context);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource location: " + master + context));
            }
        }
        catch (IOException e) {
            throw new KubernetesMembershipSchemeException("Could not construct Kubernetes API endpoint URL", e);
        }
        return apiEndpointUrl;
    }

    private KubernetesApiEndpoint createAPIEndpoint(URL url) throws KubernetesMembershipSchemeException {
        KubernetesApiEndpoint apiEndpoint;
        if (url.getProtocol().equalsIgnoreCase("https")) {
            apiEndpoint = new KubernetesHttpsApiEndpoint(url, this.skipMasterSSLVerification);
        } else if (url.getProtocol().equalsIgnoreCase("http")) {
            apiEndpoint = new KubernetesHttpApiEndpoint(url);
        } else {
            throw new KubernetesMembershipSchemeException("K8s master API endpoint is neither HTTP or HTTPS");
        }
        return apiEndpoint;
    }

    private InputStream connectAndRead(KubernetesApiEndpoint endpoint, String username, String password, String token) throws KubernetesMembershipSchemeException {
        try {
            if (!StringUtils.isEmpty((String)token)) {
                endpoint.createConnection(token);
            } else if (!StringUtils.isEmpty((String)username) && !StringUtils.isEmpty((String)password)) {
                endpoint.createConnection(username, password);
            } else {
                endpoint.createConnection();
            }
        }
        catch (IOException e) {
            throw new KubernetesMembershipSchemeException("Could not connect to Kubernetes API", e);
        }
        try {
            return endpoint.read();
        }
        catch (IOException e) {
            throw new KubernetesMembershipSchemeException("Could not connect to Kubernetes API", e);
        }
    }

    private Endpoints getEndpoints(InputStream inputStream) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (Endpoints)mapper.readValue(inputStream, Endpoints.class);
    }

    public String getKubernetesApiServerUrl() {
        return this.kubernetesApiServerUrl;
    }

    public String getKubernetesMasterUsername() {
        return this.kubernetesMasterUsername;
    }

    public String getKubernetesMasterPassword() {
        return this.kubernetesMasterPassword;
    }

    public boolean isSkipMasterSSLVerification() {
        return this.skipMasterSSLVerification;
    }
}

