/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.membership.scheme.kubernetes.resolver;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.membership.scheme.kubernetes.exceptions.KubernetesMembershipSchemeException;
import org.wso2.carbon.membership.scheme.kubernetes.resolver.AddressResolver;
import org.wso2.carbon.utils.xml.StringUtils;
import org.xbill.DNS.Address;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.TextParseException;

public class DNSBasedPodIpResolver
extends AddressResolver {
    private static final Log log = LogFactory.getLog(DNSBasedPodIpResolver.class);
    private int dnsLookupTimeout;

    public DNSBasedPodIpResolver(Map<String, Parameter> parameters) throws KubernetesMembershipSchemeException {
        super(parameters);
        this.initialize();
    }

    private void initialize() throws KubernetesMembershipSchemeException {
        String dnsLookupTimeoutValue = System.getenv("DNS_LOOKUP_TIMEOUT");
        if (StringUtils.isEmpty((String)dnsLookupTimeoutValue)) {
            dnsLookupTimeoutValue = this.getParameterValue("DNS_LOOKUP_TIMEOUT", "10");
        }
        this.dnsLookupTimeout = Integer.parseInt(dnsLookupTimeoutValue);
    }

    @Override
    public Set<String> resolveAddresses() throws KubernetesMembershipSchemeException {
        HashSet<String> containerIPs = new HashSet<String>();
        for (String kubernetesService : this.getKubernetesServicesArray()) {
            String dnsLookupName = kubernetesService.trim() + "." + this.getKubernetesNamespace() + "." + "svc.cluster.local";
            log.info((Object)("Going to perform a DNS lookup for: " + dnsLookupName));
            Lookup lookup = this.buildLookup(dnsLookupName);
            Record[] records = lookup.run();
            if (lookup.getResult() == 0 && records != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Number of DNS records found for lookup address: " + dnsLookupName + ": " + records.length));
                }
                for (Record record : records) {
                    InetAddress[] inetAddresses;
                    SRVRecord srv = (SRVRecord)record;
                    for (InetAddress inetAddress : inetAddresses = this.getAddresses(srv)) {
                        log.info((Object)("Found IP address " + inetAddress.getHostAddress() + "  for DNS lookup: " + dnsLookupName + ", SRV Record name: " + srv.getName().toString()));
                        containerIPs.add(inetAddress.getHostAddress());
                    }
                }
                continue;
            }
            log.warn((Object)("DNS lookup for name '" + dnsLookupName + "' failed"));
        }
        return containerIPs;
    }

    private Lookup buildLookup(String dnsLookupName) throws KubernetesMembershipSchemeException {
        ExtendedResolver resolver = null;
        try {
            resolver = new ExtendedResolver();
        }
        catch (UnknownHostException e) {
            throw new KubernetesMembershipSchemeException("Lookup creation error - unknown hostname", e);
        }
        resolver.setTimeout(this.dnsLookupTimeout);
        Lookup lookup = null;
        try {
            lookup = new Lookup(dnsLookupName, 33);
        }
        catch (TextParseException e) {
            throw new KubernetesMembershipSchemeException("Lookup creation error", e);
        }
        lookup.setResolver((Resolver)resolver);
        lookup.setCache(null);
        return lookup;
    }

    private InetAddress[] getAddresses(SRVRecord srv) throws KubernetesMembershipSchemeException {
        try {
            return Address.getAllByName((String)srv.getTarget().canonicalize().toString(true));
        }
        catch (UnknownHostException e) {
            throw new KubernetesMembershipSchemeException("Parsing DNS records failed", e);
        }
    }

    public int getDnsLookupTimeout() {
        return this.dnsLookupTimeout;
    }
}

