/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.membership.scheme.kubernetes;

import com.hazelcast.config.Config;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import java.net.Inet4Address;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.clustering.api.CarbonCluster;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastCarbonClusterImpl;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastMembershipScheme;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastUtil;
import org.wso2.carbon.membership.scheme.kubernetes.exceptions.KubernetesMembershipSchemeException;
import org.wso2.carbon.membership.scheme.kubernetes.resolver.AddressResolver;
import org.wso2.carbon.membership.scheme.kubernetes.resolver.ApiBasedPodIpResolver;
import org.wso2.carbon.membership.scheme.kubernetes.resolver.DNSBasedPodIpResolver;
import org.wso2.carbon.utils.xml.StringUtils;

public class KubernetesMembershipScheme
implements HazelcastMembershipScheme {
    private static final Log log = LogFactory.getLog(KubernetesMembershipScheme.class);
    private final Map<String, Parameter> parameters;
    private final NetworkConfig nwConfig;
    private final List<ClusteringMessage> messageBuffer;
    private HazelcastInstance primaryHazelcastInstance;
    private HazelcastCarbonClusterImpl carbonCluster;
    private AddressResolver podIpResolver;

    public KubernetesMembershipScheme(Map<String, Parameter> parameters, String primaryDomain, Config config, HazelcastInstance primaryHazelcastInstance, List<ClusteringMessage> messageBuffer) {
        this.parameters = parameters;
        this.primaryHazelcastInstance = primaryHazelcastInstance;
        this.messageBuffer = messageBuffer;
        this.nwConfig = config.getNetworkConfig();
    }

    public void setPrimaryHazelcastInstance(HazelcastInstance primaryHazelcastInstance) {
        this.primaryHazelcastInstance = primaryHazelcastInstance;
    }

    public void setLocalMember(Member localMember) {
    }

    public void setCarbonCluster(HazelcastCarbonClusterImpl hazelcastCarbonCluster) {
        this.carbonCluster = hazelcastCarbonCluster;
    }

    private Set<String> getK8sPodIpAddresses() throws KubernetesMembershipSchemeException {
        Set<String> containerIps = this.podIpResolver.resolveAddresses();
        if (containerIps != null) {
            return containerIps;
        }
        return Collections.emptySet();
    }

    private void initPodIpResolver() throws KubernetesMembershipSchemeException {
        String useDns = System.getenv("USE_DNS");
        if (StringUtils.isEmpty((String)useDns)) {
            useDns = this.getParameterValue("USE_DNS", "true");
        }
        if (Boolean.parseBoolean(useDns)) {
            log.debug((Object)"Using DNS based pod ip resolving method");
            this.podIpResolver = new DNSBasedPodIpResolver(this.parameters);
        } else {
            log.debug((Object)"Using API based pod ip resolving method");
            this.podIpResolver = new ApiBasedPodIpResolver(this.parameters);
        }
    }

    public void init() throws ClusteringFault {
        try {
            log.info((Object)"Initializing kubernetes membership scheme...");
            this.nwConfig.getJoin().getMulticastConfig().setEnabled(false);
            this.nwConfig.getJoin().getAwsConfig().setEnabled(false);
            TcpIpConfig tcpIpConfig = this.nwConfig.getJoin().getTcpIpConfig();
            tcpIpConfig.setEnabled(true);
            this.initPodIpResolver();
            Set<String> containerIPs = this.getK8sPodIpAddresses();
            if (containerIPs.isEmpty()) {
                throw new KubernetesMembershipSchemeException("No members found, unable to initialize the Kubernetes membership scheme");
            }
            for (String containerIP : containerIPs) {
                if (containerIP.equals(Inet4Address.getLocalHost().getHostAddress())) continue;
                tcpIpConfig.addMember(containerIP);
                log.info((Object)("Member added to cluster configuration: [container-ip] " + containerIP));
            }
            log.info((Object)"Kubernetes membership scheme initialized successfully");
        }
        catch (Exception e) {
            String errorMsg = "Kubernetes membership initialization failed";
            log.error((Object)errorMsg, (Throwable)e);
            throw new ClusteringFault(errorMsg, e);
        }
    }

    private String getParameterValue(String parameterName, String defaultValue) throws KubernetesMembershipSchemeException {
        Parameter kubernetesServicesParam = this.getParameter(parameterName);
        if (kubernetesServicesParam == null) {
            if (defaultValue == null) {
                throw new KubernetesMembershipSchemeException(parameterName + " parameter not found");
            }
            return defaultValue;
        }
        return (String)kubernetesServicesParam.getValue();
    }

    public void joinGroup() {
        this.primaryHazelcastInstance.getCluster().addMembershipListener((MembershipListener)new KubernetesMembershipSchemeListener());
    }

    private Parameter getParameter(String name) {
        return this.parameters.get(name);
    }

    private class KubernetesMembershipSchemeListener
    implements MembershipListener {
        private KubernetesMembershipSchemeListener() {
        }

        public void memberAdded(MembershipEvent membershipEvent) {
            Member member = membershipEvent.getMember();
            TcpIpConfig tcpIpConfig = KubernetesMembershipScheme.this.nwConfig.getJoin().getTcpIpConfig();
            List memberList = tcpIpConfig.getMembers();
            if (!memberList.contains(member.getSocketAddress().getAddress().getHostAddress())) {
                tcpIpConfig.addMember(String.valueOf(member.getSocketAddress().getAddress().getHostAddress()));
            }
            KubernetesMembershipScheme.this.carbonCluster.memberAdded(member);
            log.info((Object)String.format("Member joined: [UUID] %s, [Address] %s", member.getUuid(), member.getSocketAddress().toString()));
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            HazelcastUtil.sendMessagesToMember((List)KubernetesMembershipScheme.this.messageBuffer, (Member)member, (CarbonCluster)KubernetesMembershipScheme.this.carbonCluster);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Current member list: %s", tcpIpConfig.getMembers()));
            }
        }

        public void memberRemoved(MembershipEvent membershipEvent) {
            Member member = membershipEvent.getMember();
            KubernetesMembershipScheme.this.carbonCluster.memberRemoved(member);
            TcpIpConfig tcpIpConfig = KubernetesMembershipScheme.this.nwConfig.getJoin().getTcpIpConfig();
            String memberIp = member.getSocketAddress().getAddress().getHostAddress();
            try {
                Set containerIPs = KubernetesMembershipScheme.this.getK8sPodIpAddresses();
                if (!containerIPs.contains(memberIp)) {
                    tcpIpConfig.getMembers().remove(String.valueOf(member.getSocketAddress().getAddress().getHostAddress()));
                    log.info((Object)String.format("Member left: [UUID] %s, [Address] %s", member.getUuid(), member.getSocketAddress().toString()));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Current member list: %s", tcpIpConfig.getMembers()));
                    }
                }
            }
            catch (KubernetesMembershipSchemeException e) {
                log.error((Object)("Could not remove member: " + memberIp), (Throwable)e);
            }
        }

        public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Member attribute changed: [Key] %s, [Value] %s", memberAttributeEvent.getKey(), memberAttributeEvent.getValue()));
            }
        }
    }
}

