/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.membership.scheme.kubernetes.api;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class KubernetesApiEndpoint {
    private static final Log log = LogFactory.getLog(KubernetesApiEndpoint.class);
    URL url;
    HttpURLConnection connection;

    KubernetesApiEndpoint(URL url) {
        this.url = url;
    }

    public abstract void createConnection() throws IOException;

    public abstract void createConnection(String var1, String var2) throws IOException;

    public InputStream read() throws IOException {
        return this.connection.getInputStream();
    }

    public abstract void disconnect();

    void createBasicAuthenticationHeader(String username, String password) {
        log.debug((Object)"Generating basic auth header...");
        String userpass = username + ":" + password;
        String basicAuth = "Basic " + DatatypeConverter.printBase64Binary((byte[])userpass.getBytes(StandardCharsets.UTF_8));
        this.connection.setRequestProperty("Authorization", basicAuth);
        log.debug((Object)"Basic auth header generated");
    }
}

