/*
 * Copyright 2004,2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.carbon.andes.event.core.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.andes.event.core.Message;
import org.wso2.carbon.andes.event.core.delivery.DeliveryManager;
import org.wso2.carbon.andes.event.core.exception.EventBrokerException;
import org.wso2.carbon.context.PrivilegedCarbonContext;

/**
 * This class use as the worker for the executor pool which publish the message
 */
public class EventPublisher implements Runnable {

    private static final Log log = LogFactory.getLog(EventPublisher.class);

    private Message message;
    private String topicName;
    private DeliveryManager delivaryManager;
    private int deliveryMode;
    private int tenantID;
    private String username;

    public EventPublisher(Message message,
                          String topicName,
                          DeliveryManager delivaryManager,
                          int deliveryMode,
                          int tenantID,
                          String username) {
        this.message = message;
        this.topicName = topicName;
        this.delivaryManager = delivaryManager;
        this.deliveryMode = deliveryMode;
        this.tenantID = tenantID;
        this.username = username;
    }

    public void run() {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenantID);
            PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain(true);
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername(username);
            this.delivaryManager.publish(this.message, this.topicName, this.deliveryMode);
        } catch (EventBrokerException e) {
            log.error("Can not publish the message ", e);
        } finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }
}
