/*
 * Copyright 2004,2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wso2.carbon.andes.event.core;

/**
 * Keep topic node data
 */
public class TopicNode {

    private String nodeName;
    private String topicName;
    private TopicNode[] children;
    private boolean isLeafNode;

    public TopicNode(String nodeName, String topicName) {
        this.nodeName = nodeName;
        this.topicName = topicName;
        isLeafNode = true;
    }

    public String getNodeName() {
        return nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getTopicName() {
        return topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public TopicNode[] getChildren() {
        return children;
    }

    public void setChildren(TopicNode[] children) {
        this.children = children;
    }

    public boolean getLeafNode() {
        return isLeafNode;
    }

    public void setLeafNode(boolean isLeafNode) {
        this.isLeafNode = isLeafNode;
    }
}
