/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.admin.mqtt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.andes.admin.mqtt.BrokerManagerAdminException;
import org.wso2.carbon.andes.admin.mqtt.internal.AndesBrokerManagerMQTTAdminServiceDSHolder;
import org.wso2.carbon.andes.core.QueueManagerException;
import org.wso2.carbon.andes.core.QueueManagerService;
import org.wso2.carbon.andes.core.SubscriptionManagerException;
import org.wso2.carbon.andes.core.SubscriptionManagerService;
import org.wso2.carbon.andes.core.internal.util.Utils;
import org.wso2.carbon.andes.core.types.MQTTSubscription;
import org.wso2.carbon.andes.core.types.Subscription;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.user.api.UserStoreException;

public class AndesMQTTAdminService
extends AbstractAdmin {
    private static Log log = LogFactory.getLog(AndesMQTTAdminService.class);
    private static final String UI_EXECUTE = "ui.execute";
    private static final String PERMISSION_ADMIN_MANAGE_TOPIC_SUBSCRIPTION_CLOSE = "/permission/admin/manage/subscriptions/topic-close";

    public long getMessageCount(String destinationName, String msgPattern) throws BrokerManagerAdminException {
        try {
            QueueManagerService queueManagerService = AndesBrokerManagerMQTTAdminServiceDSHolder.getInstance().getQueueManagerService();
            long messageCount = queueManagerService.getMessageCount(destinationName, msgPattern);
            return messageCount;
        }
        catch (QueueManagerException e) {
            throw new BrokerManagerAdminException("Error while retrieving message count by queue manager service", (Exception)((Object)e));
        }
    }

    public void deleteTopicFromRegistry(String topicName, String subscriptionId) throws BrokerManagerAdminException {
        try {
            QueueManagerService queueManagerService = AndesBrokerManagerMQTTAdminServiceDSHolder.getInstance().getQueueManagerService();
            queueManagerService.deleteTopicFromRegistry(topicName, subscriptionId);
        }
        catch (QueueManagerException e) {
            throw new BrokerManagerAdminException("Error occurred while deleting topic '" + topicName + "' from the " + "registry", (Exception)((Object)e));
        }
    }

    public void closeSubscription(String subscriptionID, String destination, String protocolType, String destinationType) throws BrokerManagerAdminException {
        try {
            SubscriptionManagerService subscriptionManagerService = AndesBrokerManagerMQTTAdminServiceDSHolder.getInstance().getSubscriptionManagerService();
            subscriptionManagerService.closeSubscription(subscriptionID, destination, protocolType, destinationType);
        }
        catch (SubscriptionManagerException e) {
            throw new BrokerManagerAdminException("Error occurred while closing the subscription '" + destination + "'", (Exception)((Object)e));
        }
    }

    public Subscription[] getSubscriptions(String isDurable, String isActive, String protocolType, String destinationType) throws BrokerManagerAdminException {
        Subscription[] subscriptionsDTO;
        ArrayList<Subscription> allSubscriptions = new ArrayList<Subscription>();
        try {
            SubscriptionManagerService subscriptionManagerService = AndesBrokerManagerMQTTAdminServiceDSHolder.getInstance().getSubscriptionManagerService();
            List subscriptions = subscriptionManagerService.getSubscriptions(isDurable, isActive, protocolType, destinationType);
            subscriptionsDTO = new Subscription[subscriptions.size()];
            for (Subscription sub : subscriptions) {
                Subscription subscriptionDTO = new Subscription();
                subscriptionDTO.setSubscriptionIdentifier(sub.getSubscriptionIdentifier());
                subscriptionDTO.setSubscribedQueueOrTopicName(sub.getSubscribedQueueOrTopicName());
                subscriptionDTO.setSubscriberQueueBoundExchange(sub.getSubscriberQueueBoundExchange());
                subscriptionDTO.setSubscriberQueueName(sub.getSubscriberQueueName());
                subscriptionDTO.setDurable(sub.isDurable());
                subscriptionDTO.setActive(sub.isActive());
                subscriptionDTO.setNumberOfMessagesRemainingForSubscriber(sub.getNumberOfMessagesRemainingForSubscriber());
                subscriptionDTO.setConnectedNodeAddress(sub.getConnectedNodeAddress());
                subscriptionDTO.setProtocolType(sub.getProtocolType());
                subscriptionDTO.setDestinationType(sub.getDestinationType());
                subscriptionDTO.setOriginHostAddress(sub.getOriginHostAddress());
                allSubscriptions.add(subscriptionDTO);
            }
            CustomSubscriptionComparator comparator = new CustomSubscriptionComparator();
            Collections.sort(allSubscriptions, Collections.reverseOrder(comparator));
            allSubscriptions.toArray(subscriptionsDTO);
        }
        catch (SubscriptionManagerException e) {
            throw new BrokerManagerAdminException("Error occurred while retrieving subscriptions", (Exception)((Object)e));
        }
        return subscriptionsDTO;
    }

    public Subscription[] getFilteredSubscriptions(MQTTSubscription subscription, String tenantDomain) throws BrokerManagerAdminException {
        Subscription[] subscriptionsDTO;
        ArrayList<Subscription> allSubscriptions = new ArrayList<Subscription>();
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            privilegedCarbonContext.setTenantDomain(tenantDomain);
            SubscriptionManagerService subscriptionManagerService = AndesBrokerManagerMQTTAdminServiceDSHolder.getInstance().getSubscriptionManagerService();
            List subscriptions = subscriptionManagerService.getFilteredMQTTSubscriptions(subscription, tenantDomain);
            subscriptionsDTO = new Subscription[subscriptions.size()];
            for (Subscription sub : subscriptions) {
                Subscription subscriptionDTO = new Subscription();
                subscriptionDTO.setSubscriptionIdentifier(sub.getSubscriptionIdentifier());
                subscriptionDTO.setSubscribedQueueOrTopicName(sub.getSubscribedQueueOrTopicName());
                subscriptionDTO.setSubscriberQueueBoundExchange(sub.getSubscriberQueueBoundExchange());
                subscriptionDTO.setSubscriberQueueName(sub.getSubscriberQueueName());
                subscriptionDTO.setDurable(sub.isDurable());
                subscriptionDTO.setActive(sub.isActive());
                subscriptionDTO.setNumberOfMessagesRemainingForSubscriber(sub.getNumberOfMessagesRemainingForSubscriber());
                subscriptionDTO.setConnectedNodeAddress(sub.getConnectedNodeAddress());
                subscriptionDTO.setProtocolType(sub.getProtocolType());
                subscriptionDTO.setDestinationType(sub.getDestinationType());
                subscriptionDTO.setOriginHostAddress(sub.getOriginHostAddress());
                allSubscriptions.add(subscriptionDTO);
            }
            CustomSubscriptionComparator comparator = new CustomSubscriptionComparator();
            Collections.sort(allSubscriptions, Collections.reverseOrder(comparator));
            allSubscriptions.toArray(subscriptionsDTO);
        }
        catch (SubscriptionManagerException e) {
            throw new BrokerManagerAdminException("Error occurred while retrieving subscriptions for the tenant '" + tenantDomain + "'", (Exception)((Object)e));
        }
        return subscriptionsDTO;
    }

    public int getTotalSubscriptionCountForSearchResult(MQTTSubscription subscription) throws BrokerManagerAdminException {
        int subscriptionCountForSearchResult = 0;
        try {
            SubscriptionManagerService subscriptionManagerService = AndesBrokerManagerMQTTAdminServiceDSHolder.getInstance().getSubscriptionManagerService();
            subscriptionCountForSearchResult = subscriptionManagerService.getTotalSubscriptionCountForSearchResult(subscription.isDurable(), subscription.isActive(), subscription.getProtocolType(), subscription.getDestinationType(), subscription.getFilteredNamePattern(), subscription.isFilteredNameByExactMatch(), subscription.getIdentifierPattern(), subscription.isIdentifierPatternByExactMatch(), subscription.getOwnNodeId());
        }
        catch (SubscriptionManagerException e) {
            throw new BrokerManagerAdminException("Error occurred while retrieving total count of subscriptions", (Exception)((Object)e));
        }
        return subscriptionCountForSearchResult;
    }

    public boolean checkCurrentUserHasTopicSubscriptionClosePermission() throws BrokerManagerAdminException {
        boolean hasPermission = false;
        String username = this.getCurrentUser();
        try {
            if (Utils.isAdmin((String)username)) {
                hasPermission = true;
            } else if (CarbonContext.getThreadLocalCarbonContext().getUserRealm().getAuthorizationManager().isUserAuthorized(username, PERMISSION_ADMIN_MANAGE_TOPIC_SUBSCRIPTION_CLOSE, UI_EXECUTE)) {
                hasPermission = true;
            }
        }
        catch (QueueManagerException | UserStoreException e) {
            String errorMessage = e.getMessage();
            log.error((Object)errorMessage, e);
            throw new BrokerManagerAdminException(errorMessage, (Exception)e);
        }
        return hasPermission;
    }

    private String getCurrentUser() {
        String userName = CarbonContext.getThreadLocalCarbonContext().getTenantId() > -1 ? CarbonContext.getThreadLocalCarbonContext().getUsername() + "!" + CarbonContext.getThreadLocalCarbonContext().getTenantDomain() : CarbonContext.getThreadLocalCarbonContext().getUsername();
        return userName.trim();
    }

    public class CustomSubscriptionComparator
    implements Comparator<Subscription> {
        @Override
        public int compare(Subscription sub1, Subscription sub2) {
            return sub1.getNumberOfMessagesRemainingForSubscriber() - sub2.getNumberOfMessagesRemainingForSubscriber();
        }
    }
}

