/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Hashtable;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.om.impl.dom.DOMMessageFormatter;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.apache.axiom.om.util.StAXUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public abstract class NodeImpl
implements Node,
NodeList,
OMNodeEx,
Cloneable {
    private Hashtable userData;
    public OMXMLParserWrapper builder;
    protected boolean done = false;
    protected DocumentImpl ownerNode;
    protected final OMFactory factory;
    protected short flags;
    protected static final short OWNED = 2;
    protected static final short FIRSTCHILD = 4;
    protected static final short READONLY = 8;
    protected static final short SPECIFIED = 16;
    protected static final short NORMALIZED = 32;

    protected NodeImpl(DocumentImpl ownerDocument, OMFactory factory) {
        this.factory = factory;
        this.ownerNode = ownerDocument;
    }

    protected NodeImpl(OMFactory factory) {
        this.factory = factory;
    }

    @Override
    public void normalize() {
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public boolean hasChildNodes() {
        return false;
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public String getNodeValue() throws DOMException {
        return null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public void setNodeValue(String arg0) throws DOMException {
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        throw new DOMException(14, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 14, null));
    }

    @Override
    public Document getOwnerDocument() {
        return this.ownerNode;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public Node getFirstChild() {
        return null;
    }

    @Override
    public Node getLastChild() {
        return null;
    }

    @Override
    public Node getNextSibling() {
        return null;
    }

    @Override
    public Node getParentNode() {
        return null;
    }

    NodeImpl parentNode() {
        return null;
    }

    @Override
    public Node getPreviousSibling() {
        return null;
    }

    @Override
    public Node cloneNode(boolean deep) {
        NodeImpl newnode;
        try {
            newnode = (NodeImpl)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("**Internal Error**" + e);
        }
        newnode.ownerNode = this.ownerNode;
        newnode.isOwned(false);
        newnode.isReadonly(false);
        return newnode;
    }

    @Override
    public NodeList getChildNodes() {
        return this;
    }

    @Override
    public boolean isSupported(String feature, String version) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        return this.insertBefore(newChild, null);
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        throw new DOMException(8, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 8, null));
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 3, null));
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 3, null));
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public Node item(int index) {
        return null;
    }

    final boolean isOwned() {
        return (this.flags & 2) != 0;
    }

    final void isOwned(boolean value) {
        this.flags = (short)(value ? this.flags | 2 : this.flags & 0xFFFFFFFD);
    }

    final boolean isFirstChild() {
        return (this.flags & 4) != 0;
    }

    final void isFirstChild(boolean value) {
        this.flags = (short)(value ? this.flags | 4 : this.flags & 0xFFFFFFFB);
    }

    final boolean isReadonly() {
        return (this.flags & 8) != 0;
    }

    final void isReadonly(boolean value) {
        this.flags = (short)(value ? this.flags | 8 : this.flags & 0xFFFFFFF7);
    }

    final boolean isSpecified() {
        return (this.flags & 0x10) != 0;
    }

    final void isSpecified(boolean value) {
        this.flags = (short)(value ? this.flags | 0x10 : this.flags & 0xFFFFFFEF);
    }

    final boolean isNormalized() {
        return (this.flags & 0x20) != 0;
    }

    final void isNormalized(boolean value) {
        if (!value && this.isNormalized() && this.ownerNode != null) {
            this.ownerNode.isNormalized(false);
        }
        this.flags = (short)(value ? this.flags | 0x20 : this.flags & 0xFFFFFFDF);
    }

    @Override
    public OMContainer getParent() throws OMException {
        return null;
    }

    @Override
    public boolean isComplete() {
        return this.done;
    }

    @Override
    public void setComplete(boolean state) {
        this.done = state;
    }

    @Override
    public void insertSiblingAfter(OMNode sibling) throws OMException {
        throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 3, null));
    }

    @Override
    public void insertSiblingBefore(OMNode sibling) throws OMException {
        throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 3, null));
    }

    @Override
    public OMNode getPreviousOMSibling() {
        return null;
    }

    @Override
    public OMNode getNextOMSibling() {
        return null;
    }

    @Override
    public OMNode getNextOMSiblingIfAvailable() {
        return null;
    }

    @Override
    public void setPreviousOMSibling(OMNode previousSibling) {
        throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 3, null));
    }

    @Override
    public void setNextOMSibling(OMNode previousSibling) {
        throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 3, null));
    }

    @Override
    public void build() {
        while (!this.done) {
            this.builder.next();
        }
    }

    @Override
    public void buildWithAttachments() {
        if (!this.done) {
            this.build();
        }
    }

    @Override
    public void close(boolean build) {
        if (build) {
            this.build();
        }
        this.done = true;
        if (this.builder instanceof StAXBuilder && !((StAXBuilder)this.builder).isClosed()) {
            ((StAXBuilder)this.builder).releaseParserOnClose(true);
            ((StAXBuilder)this.builder).close();
        }
    }

    protected void setOwnerDocument(DocumentImpl document) {
        this.ownerNode = document;
        this.isOwned(true);
    }

    @Override
    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        this.serialize(xmlWriter, true);
    }

    @Override
    public void serializeAndConsume(XMLStreamWriter xmlWriter) throws XMLStreamException {
        this.serialize(xmlWriter, false);
    }

    @Override
    public void serialize(XMLStreamWriter xmlWriter, boolean cache) throws XMLStreamException {
        MTOMXMLStreamWriter writer = xmlWriter instanceof MTOMXMLStreamWriter ? (MTOMXMLStreamWriter)xmlWriter : new MTOMXMLStreamWriter(xmlWriter);
        this.internalSerialize(writer, cache);
        writer.flush();
    }

    @Override
    public OMNode detach() {
        throw new OMException("Elements that doesn't have a parent can not be detached");
    }

    @Override
    public String getBaseURI() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        throw new DOMException(9, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", 9, null));
    }

    @Override
    public String getTextContent() throws DOMException {
        return this.getNodeValue();
    }

    void getTextContent(StringBuffer buf) throws DOMException {
        String content = this.getNodeValue();
        if (content != null) {
            buf.append(content);
        }
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        this.setNodeValue(textContent);
    }

    @Override
    public boolean isSameNode(Node node) {
        return this == node;
    }

    @Override
    public String lookupPrefix(String arg0) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public boolean isDefaultNamespace(String arg0) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public String lookupNamespaceURI(String arg0) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public boolean isEqualNode(Node node) {
        boolean equal = true;
        boolean notEqual = false;
        if (this.getNodeType() != node.getNodeType()) {
            return false;
        }
        if (this.checkStringAttributeEquality(node)) {
            if (!this.checkNamedNodeMapEquality(node)) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean checkStringAttributeEquality(Node node) {
        boolean equal = true;
        boolean notEqual = false;
        if (node.getNodeName() == null ^ this.getNodeName() == null) {
            return false;
        }
        if (node.getNodeName() != null && !node.getNodeName().equals(this.getNodeName())) {
            return false;
        }
        if (node.getLocalName() == null ^ this.getLocalName() == null) {
            return false;
        }
        if (node.getLocalName() != null && !node.getLocalName().equals(this.getLocalName())) {
            return false;
        }
        if (node.getNamespaceURI() == null ^ this.getNamespaceURI() == null) {
            return false;
        }
        if (node.getNamespaceURI() != null && !node.getNamespaceURI().equals(this.getNamespaceURI())) {
            return false;
        }
        if (node.getPrefix() == null ^ this.getPrefix() == null) {
            return false;
        }
        if (node.getPrefix() != null && !node.getPrefix().equals(this.getPrefix())) {
            return false;
        }
        if (node.getNodeValue() == null ^ this.getNodeValue() == null) {
            return false;
        }
        return node.getNodeValue() == null || node.getNodeValue().equals(this.getNodeValue());
    }

    private boolean checkNamedNodeMapEquality(Node node) {
        NamedNodeMap nodeNamedNodeMap;
        boolean equal = true;
        boolean notEqual = false;
        if (node.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        NamedNodeMap thisNamedNodeMap = this.getAttributes();
        if (thisNamedNodeMap == null ^ (nodeNamedNodeMap = node.getAttributes()) == null) {
            return false;
        }
        if (thisNamedNodeMap != null) {
            if (thisNamedNodeMap.getLength() != nodeNamedNodeMap.getLength()) {
                return false;
            }
            int itemCount = thisNamedNodeMap.getLength();
            for (int a = 0; a < itemCount; ++a) {
                NodeImpl thisNode = (NodeImpl)thisNamedNodeMap.item(a);
                NodeImpl tmpNode = (NodeImpl)nodeNamedNodeMap.getNamedItem(thisNode.getNodeName());
                if (tmpNode == null) {
                    return false;
                }
                if (thisNode.isEqualNode(tmpNode)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Object getFeature(String arg0, String arg1) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Object setUserData(String key, Object value, UserDataHandler userDataHandler) {
        if (this.userData == null) {
            this.userData = new Hashtable();
        }
        return this.userData.put(key, value);
    }

    @Override
    public Object getUserData(String key) {
        if (this.userData != null) {
            return this.userData.get(key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(OutputStream output) throws XMLStreamException {
        try (XMLStreamWriter xmlStreamWriter = StAXUtils.createXMLStreamWriter(output);){
            this.serialize(xmlStreamWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(Writer writer) throws XMLStreamException {
        try (XMLStreamWriter xmlStreamWriter = StAXUtils.createXMLStreamWriter(writer);){
            this.serialize(xmlStreamWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serializeAndConsume(OutputStream output) throws XMLStreamException {
        try (XMLStreamWriter xmlStreamWriter = StAXUtils.createXMLStreamWriter(output);){
            this.serializeAndConsume(xmlStreamWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serializeAndConsume(Writer writer) throws XMLStreamException {
        try (XMLStreamWriter xmlStreamWriter = StAXUtils.createXMLStreamWriter(writer);){
            this.serializeAndConsume(xmlStreamWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        try (MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(output, format);){
            this.internalSerialize(writer, true);
            writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(Writer writer2, OMOutputFormat format) throws XMLStreamException {
        writer.setOutputFormat(format);
        try (MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(StAXUtils.createXMLStreamWriter(writer2));){
            this.internalSerialize(writer, true);
            writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serializeAndConsume(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        try (MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(output, format);){
            this.internalSerialize(writer, false);
            writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serializeAndConsume(Writer writer2, OMOutputFormat format) throws XMLStreamException {
        try (MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(StAXUtils.createXMLStreamWriter(writer2));){
            writer.setOutputFormat(format);
            this.internalSerialize(writer, false);
            writer.flush();
        }
    }

    @Override
    public OMFactory getOMFactory() {
        return this.factory;
    }

    @Override
    public void internalSerialize(XMLStreamWriter writer) throws XMLStreamException {
        this.internalSerialize(writer, true);
    }

    @Override
    public void internalSerializeAndConsume(XMLStreamWriter writer) throws XMLStreamException {
        this.internalSerialize(writer, false);
    }
}

