/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.das.integration.common.ui.page;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.wso2.das.integration.common.ui.page.main.HomePage;
import org.wso2.das.integration.common.ui.page.util.UIElementMapper;

public class LoginPage {
    private static final Log log = LogFactory.getLog(LoginPage.class);
    private WebDriver driver;
    private boolean isCloudEnvironment = false;

    public LoginPage(WebDriver driver) throws IOException {
        this.driver = driver;
        if (!driver.getCurrentUrl().contains("login.jsp")) {
            throw new IllegalStateException("This is not the login page");
        }
    }

    public LoginPage(WebDriver driver, boolean isCloudEnvironment) throws IOException {
        this.driver = driver;
        this.isCloudEnvironment = isCloudEnvironment;
        if (this.isCloudEnvironment) {
            if (!driver.getCurrentUrl().contains("home/index.html")) {
                throw new IllegalStateException("This is not the cloud login page");
            }
            driver.findElement(By.xpath((String)"//*[@id=\"content\"]/div[1]/div/a[2]/img")).click();
        } else if (!driver.getCurrentUrl().contains("login.jsp")) {
            throw new IllegalStateException("This is not the product login page");
        }
    }

    public HomePage loginAs(String userName, String password, boolean isTenant) throws IOException {
        log.info((Object)("login as " + userName + ":Tenant"));
        WebElement userNameField = this.driver.findElement(By.name((String)UIElementMapper.getInstance().getElement("login.username.name")));
        WebElement passwordField = this.driver.findElement(By.name((String)UIElementMapper.getInstance().getElement("login.password")));
        userNameField.sendKeys(new CharSequence[]{userName});
        passwordField.sendKeys(new CharSequence[]{password});
        if (this.isCloudEnvironment) {
            this.driver.findElement(By.xpath((String)"//*[@id=\"loginForm\"]/table/tbody/tr[4]/td[2]/input")).click();
            return new HomePage(isTenant, this.driver);
        }
        this.driver.findElement(By.className((String)UIElementMapper.getInstance().getElement("login.sign.in.button"))).click();
        return new HomePage(isTenant, this.driver);
    }

    public HomePage loginAs(String userName, String password) throws IOException {
        log.info((Object)("login as " + userName));
        WebElement userNameField = this.driver.findElement(By.name((String)UIElementMapper.getInstance().getElement("login.username.name")));
        WebElement passwordField = this.driver.findElement(By.name((String)UIElementMapper.getInstance().getElement("login.password")));
        userNameField.sendKeys(new CharSequence[]{userName});
        passwordField.sendKeys(new CharSequence[]{password});
        if (this.isCloudEnvironment) {
            this.driver.findElement(By.xpath((String)"//*[@id=\"loginForm\"]/table/tbody/tr[4]/td[2]/input")).click();
            return new HomePage(this.driver, this.isCloudEnvironment);
        }
        this.driver.findElement(By.className((String)UIElementMapper.getInstance().getElement("login.sign.in.button"))).click();
        return new HomePage(this.driver);
    }
}

