/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.extensions.axis2server;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.engine.extensions.ExecutionListenerExtension;
import org.wso2.esb.integration.common.extensions.axis2server.Axis2ServerManager;

public class Axis2ServerExtension
extends ExecutionListenerExtension {
    private Axis2ServerManager serverManager;
    private static final Log log = LogFactory.getLog(Axis2ServerExtension.class);

    public void initiate() throws AutomationFrameworkException {
    }

    public void onExecutionStart() throws AutomationFrameworkException {
        this.serverManager = new Axis2ServerManager();
        if (System.getProperty("http.socket.reuseaddr") == null) {
            System.setProperty("http.socket.reuseaddr", "true");
        }
        try {
            this.serverManager.start();
            log.info((Object)".................Deploying services..............");
            this.serverManager.deployService("LBService1");
            this.serverManager.deployService("SimpleStockQuoteService");
            this.serverManager.deployService("SecureStockQuoteService");
            this.serverManager.deployService("Axis2Service");
        }
        catch (IOException e) {
            Axis2ServerExtension.handleException("Error While Deploying services", e);
        }
    }

    public void onExecutionFinish() throws AutomationFrameworkException {
        this.serverManager.stop();
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new RuntimeException(msg, e);
    }
}

