/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.extensions.db.manager;

import com.moandjiezana.toml.Toml;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.engine.extensions.ExecutionListenerExtension;

public class DatabaseManager
extends ExecutionListenerExtension {
    private static final Log logger = LogFactory.getLog(DatabaseManager.class);
    private String dbName;
    private String scriptPath;
    private static String connectionUrl;
    private static String pwd;
    private static String userName;
    private String dbType;
    private String dataSource;
    private String scriptBaseDir;
    private String scriptSuffix;
    private String delimiter;
    private String dbClearScripts;
    private boolean createSecondary = false;
    private static final String ALLOW_MULTIPLE_QUERIES = "allowMultiQueries=true";
    private static final String MY_SQL = "mysql";
    private static final String MS_SQL = "sqlserver";
    private static final String POSTGRES = "postgresql";
    private static final String DB2 = "db2";
    private static final String ORACLE = "oracle";
    private static final String DEFAULT_DB_URL = "jdbc:mysql://localhost:3306/testDb?useSSL=false&allowPublicKeyRetrieval=true";
    private static final String DEFAULT_DB_USER = "root";
    private static final String DEFAULT_DB_PWD = "root";
    private static final String DEFAULT_DRIVER = "com.mysql.jdbc.Driver";
    private static final String SECONDARY_DB = "secondaryDb";

    public void initiate() throws AutomationFrameworkException {
        logger.info((Object)"Initializing database.");
        this.populateParameters();
    }

    public void onExecutionStart() throws AutomationFrameworkException {
        if ("True".equalsIgnoreCase(System.getProperty("dbProvided"))) {
            logger.info((Object)"Skipping database creation ....");
            return;
        }
        logger.info((Object)("Database type : " + this.dbType));
        logger.info((Object)("Database name : " + this.dbName));
        try {
            switch (this.dbType) {
                case "mysql": {
                    this.setUpMysql();
                    break;
                }
                case "sqlserver": {
                    this.setUpMssql();
                    break;
                }
                case "postgresql": {
                    this.setUpPostgres();
                    break;
                }
                case "db2": 
                case "oracle": {
                    this.executeScript(this.dbClearScripts + this.dbType + "/" + this.dbType + "_" + this.scriptSuffix, true);
                    this.executeScript(this.scriptBaseDir + "/" + this.dbType + "/" + this.dbType + "_" + this.scriptSuffix, false);
                    break;
                }
                default: {
                    logger.info((Object)("Db type '" + this.dbType + "' is not supported by the framework, if you have configured the database with respective scripts, the test cases will run smoothly."));
                    break;
                }
            }
        }
        catch (Exception ex) {
            throw new AutomationFrameworkException((Throwable)ex);
        }
        logger.info((Object)"Database configured successfully.");
    }

    private void setUpPostgres() throws Exception {
        String dbUrl = connectionUrl.replace("/" + this.dbName, "/");
        this.executeUpdate(dbUrl, "drop database if exists " + this.dbName + ";");
        this.executeUpdate(dbUrl, "create database " + this.dbName + ";");
        this.scriptPath = this.scriptBaseDir + "/postgres/postgresql_" + this.scriptSuffix;
        this.scriptPath = DatabaseManager.getSystemDependentPath(this.scriptPath);
        File file = new File(this.scriptPath);
        dbUrl = connectionUrl.concat("?allowMultiQueries=true");
        this.executeUpdate(dbUrl, FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8));
    }

    private void setUpMssql() throws Exception {
        String dbUrl = connectionUrl.replace(";databaseName=" + this.dbName, "").concat(";allowMultiQueries=true");
        ArrayList<String> schema = new ArrayList<String>();
        schema.add("USE master;");
        schema.add("IF EXISTS(select * from sys.databases where name='" + this.dbName + "') DROP DATABASE " + this.dbName + ";");
        schema.add("CREATE DATABASE " + this.dbName + ";");
        this.executeUpdate(dbUrl, String.join((CharSequence)"", schema));
        dbUrl = connectionUrl.concat(";allowMultiQueries=true");
        this.scriptPath = this.scriptBaseDir + "/mssql/mssql_" + this.scriptSuffix;
        this.scriptPath = DatabaseManager.getSystemDependentPath(this.scriptPath);
        File file = new File(this.scriptPath);
        this.executeUpdate(dbUrl, FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8));
    }

    private void setUpMysql() throws Exception {
        this.scriptPath = this.scriptBaseDir + "/mysql/mysql_" + this.scriptSuffix;
        String dbUrl = connectionUrl.replace("/" + this.dbName, "").concat("&allowMultiQueries=true");
        this.scriptPath = DatabaseManager.getSystemDependentPath(this.scriptPath);
        File file = new File(this.scriptPath);
        ArrayList<String> schema = new ArrayList<String>();
        schema.add("drop database if exists " + this.dbName + ";");
        schema.add("create database " + this.dbName + " character set latin1;");
        schema.add("use " + this.dbName + ";");
        schema.add(FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8));
        this.executeUpdate(dbUrl, String.join((CharSequence)"", schema));
        if (this.createSecondary) {
            schema = new ArrayList();
            schema.add("drop database if exists secondaryDb;");
            schema.add("create database secondaryDb character set latin1;");
            schema.add("use secondaryDb;");
            schema.add(FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8));
            this.executeUpdate(dbUrl, String.join((CharSequence)"", schema));
        }
    }

    public void onExecutionFinish() {
    }

    private void executeScript(String scriptFilePath, boolean ignoreExceptions) throws Exception {
        String[] queries;
        File file = new File(DatabaseManager.getSystemDependentPath(scriptFilePath));
        for (String query : queries = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8).split(this.delimiter)) {
            if ((query = query.trim()).isEmpty()) continue;
            try {
                this.executeUpdate(connectionUrl, query);
            }
            catch (Exception ex) {
                if (ignoreExceptions) continue;
                throw new AutomationFrameworkException((Throwable)ex);
            }
        }
    }

    private void executeUpdate(String dbUrl, String sql) throws Exception {
        logger.info((Object)("Executing sql : " + sql));
        try (Connection conn = DriverManager.getConnection(dbUrl, userName, pwd);
             Statement statement = conn.createStatement();){
            statement.executeUpdate(sql);
        }
    }

    private static String getSystemDependentPath(String path) {
        return path.replace('/', File.separatorChar);
    }

    private void populateParameters() throws AutomationFrameworkException {
        Map parameters = this.getParameters();
        block18: for (Map.Entry entry : parameters.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            switch (key) {
                case "toml-path": {
                    this.parseToml(value);
                    continue block18;
                }
                case "script-basedir": {
                    this.scriptBaseDir = value;
                    continue block18;
                }
                case "script-suffix": {
                    this.scriptSuffix = value;
                    continue block18;
                }
                case "data-source": {
                    this.dataSource = value;
                    continue block18;
                }
                case "script-delimiter": {
                    this.delimiter = value;
                    continue block18;
                }
                case "db-clear-scripts-base-dir": {
                    this.dbClearScripts = value;
                    continue block18;
                }
                case "create-secondary": {
                    this.createSecondary = Boolean.parseBoolean(value);
                    continue block18;
                }
            }
            logger.error((Object)("Unknown property : " + key));
        }
    }

    private void parseToml(String filePath) throws AutomationFrameworkException {
        File toml = new File(filePath);
        if (!toml.exists()) {
            throw new AutomationFrameworkException("File not found in : " + filePath);
        }
        try {
            Toml parseToml = new Toml().read(toml);
            String datasourceId = parseToml.getString("datasource[0].id");
            if (Objects.nonNull(this.dataSource) && !this.dataSource.equals(datasourceId)) {
                throw new AutomationFrameworkException("Data source " + this.dataSource + " is not defined in toml or not added as first datasource.");
            }
            connectionUrl = this.resolveValue(parseToml.getString("datasource[0].url").replaceAll("amp;", ""), DEFAULT_DB_URL);
            userName = this.resolveValue(parseToml.getString("datasource[0].username"), "root");
            pwd = this.resolveValue(parseToml.getString("datasource[0].password"), "root");
            this.resolveValue(parseToml.getString("datasource[0].driver"), DEFAULT_DRIVER);
            URI uri = URI.create(connectionUrl.substring(5));
            this.dbType = uri.getScheme();
            String path = uri.getPath();
            if (path != null) {
                if (Stream.of(MY_SQL, DB2, POSTGRES).anyMatch(s -> s.equals(this.dbType))) {
                    this.dbName = path.replace("/", "");
                } else if (MS_SQL.equals(this.dbType)) {
                    String[] splits = connectionUrl.split("databaseName=");
                    this.dbName = splits[1].substring(0, splits[1].indexOf(59));
                }
            }
        }
        catch (Exception ex) {
            throw new AutomationFrameworkException((Throwable)ex);
        }
    }

    private String resolveValue(String tomlValue, String defValue) {
        if (tomlValue.startsWith("$sys{")) {
            String value = defValue;
            String envVariableName = StringUtils.substringBetween((String)tomlValue, (String)"$sys{", (String)"}");
            String resolvedEnvValue = System.getProperty(envVariableName);
            if (!StringUtils.isEmpty((CharSequence)resolvedEnvValue)) {
                value = resolvedEnvValue;
            }
            System.setProperty(envVariableName, value);
            return value;
        }
        return tomlValue;
    }

    public static String getConnectionUrl() {
        return connectionUrl;
    }

    public static String getUserName() {
        return userName;
    }

    public static String getPwd() {
        return pwd;
    }
}

