/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.extensions.carbonserver;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.integration.common.utils.FileManager;
import org.wso2.esb.integration.common.extensions.carbonserver.CarbonServerManager;

public class TestServerManager {
    protected CarbonServerManager carbonServer;
    protected String carbonZip;
    protected int portOffset;
    protected Map<String, String> commandMap = new HashMap<String, String>();
    private static final Log log = LogFactory.getLog(TestServerManager.class);
    protected String carbonHome;
    protected String runtimePath;

    public TestServerManager(AutomationContext context) {
        this.carbonServer = new CarbonServerManager(context);
    }

    public TestServerManager(AutomationContext context, String carbonZip) {
        this.carbonServer = new CarbonServerManager(context);
        this.carbonZip = carbonZip;
    }

    public TestServerManager(AutomationContext context, int portOffset) {
        this.carbonServer = new CarbonServerManager(context);
        this.portOffset = portOffset;
        this.commandMap.put("-DportOffset", String.valueOf(portOffset));
    }

    public TestServerManager(AutomationContext context, String carbonZip, Map<String, String> commandMap) {
        this.carbonServer = new CarbonServerManager(context);
        this.carbonZip = carbonZip;
        if (commandMap.get("-DportOffset") == null) {
            throw new IllegalArgumentException("portOffset value must be set in command list");
        }
        this.portOffset = Integer.parseInt(commandMap.get("-DportOffset"));
        this.commandMap = commandMap;
    }

    public String getCarbonZip() {
        return this.carbonZip;
    }

    public String getCarbonHome() {
        return this.carbonHome;
    }

    public int getPortOffset() {
        return this.portOffset;
    }

    public String getRuntimePath() {
        return this.runtimePath;
    }

    public void configureServer() throws AutomationFrameworkException {
    }

    private void copyFileToServer(String sourcePath, String destinationPath) {
        log.info((Object)("Updating " + destinationPath + " for product EI"));
        String catalinaResourcePath = Paths.get(FrameworkPathUtil.getSystemResourceLocation(), sourcePath).toString();
        try {
            FileManager.copyFile((File)Paths.get(catalinaResourcePath, new String[0]).toFile(), (String)Paths.get(this.carbonHome, destinationPath).toString());
        }
        catch (IOException e) {
            log.warn((Object)("IOException while replacing " + destinationPath));
        }
    }

    public Map<String, String> getCommands() {
        return this.commandMap;
    }

    public String startServer() throws AutomationFrameworkException, IOException, XPathExpressionException {
        if (this.carbonHome == null) {
            if (this.carbonZip == null) {
                this.carbonZip = System.getProperty("carbon.zip");
            }
            if (this.carbonZip == null) {
                throw new IllegalArgumentException("carbon zip file cannot find in the given location");
            }
            this.carbonHome = this.carbonServer.setUpCarbonHome(this.carbonZip);
            this.configureServer();
        }
        log.info((Object)("Carbon Home - " + this.carbonHome));
        this.portOffset = this.commandMap.get("-DportOffset") != null ? Integer.parseInt(this.commandMap.get("-DportOffset")) : 0;
        if (this.commandMap.get("runtimePath") != null) {
            this.runtimePath = this.commandMap.get("runtimePath");
        }
        this.carbonServer.startServerUsingCarbonHome(this.carbonHome, this.commandMap);
        return this.carbonHome;
    }

    public void restartGracefully() throws AutomationFrameworkException {
        if (this.carbonHome == null) {
            throw new AutomationFrameworkException("No Running Server found to restart. Please make sure whether server is started");
        }
        this.carbonServer.restartGracefully();
    }

    public void stopServer() throws AutomationFrameworkException {
        this.carbonServer.serverShutdown(this.portOffset);
    }
}

