/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.module.ftp;

import java.util.List;
import org.ballerinalang.compiler.plugins.SupportedResourceParamTypes;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.util.AbstractTransportCompilerPlugin;

@SupportedResourceParamTypes(expectedListenerType=@SupportedResourceParamTypes.Type(orgName="wso2", packageName="ftp", name="Listener"), paramTypes={@SupportedResourceParamTypes.Type(orgName="wso2", packageName="ftp", name="WatchEvent")})
public class ServiceCompilerPlugin
extends AbstractTransportCompilerPlugin {
    private DiagnosticLog dlog = null;
    private static final String FTP_SERVER_EVENT = "WatchEvent";

    public void init(DiagnosticLog diagnosticLog) {
        this.dlog = diagnosticLog;
    }

    public void process(ServiceNode serviceNode, List<AnnotationAttachmentNode> annotations) {
        List resources = serviceNode.getResources();
        if (resources.isEmpty()) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)("No resources define for service: " + serviceNode.getName().getValue()));
        } else if (resources.size() >= 2) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)("Only one resource allows for service: " + serviceNode.getName().getValue()));
        }
        if (resources.size() == 1) {
            BType type;
            List parameters = ((BLangFunction)resources.get(0)).getParameters();
            if (parameters.size() != 1) {
                this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)((BLangFunction)resources.get(0)).getPosition(), (CharSequence)"Invalid resource signature. A single WatchEvent parameter allow in the resource signature.");
            }
            if ((type = ((BLangSimpleVariable)parameters.get((int)0)).getTypeNode().type).getKind().equals((Object)TypeKind.OBJECT) && type instanceof BObjectType) {
                BObjectType event = (BObjectType)type;
                if (!"ftp".equals(event.tsymbol.pkgID.name.value) || !FTP_SERVER_EVENT.equals(event.tsymbol.name.value)) {
                    this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)((BLangSimpleVariable)parameters.get(0)).getPosition(), (CharSequence)"Parameter should be of type - ftp:WatchEvent");
                }
            }
        }
    }
}

