/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.secvault.internal;

import java.nio.file.Path;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.secvault.MasterKeyReader;
import org.wso2.carbon.secvault.SecretRepository;
import org.wso2.carbon.secvault.SecureVault;
import org.wso2.carbon.secvault.SecureVaultFactory;
import org.wso2.carbon.secvault.exception.SecureVaultException;
import org.wso2.carbon.secvault.internal.SecureVaultDataHolder;
import org.wso2.carbon.secvault.model.SecureVaultConfiguration;
import org.wso2.carbon.utils.Utils;

@Component(name="org.wso2.carbon.secvault.internal.SecureVaultComponent", immediate=true)
public class SecureVaultComponent {
    private static final Logger logger = LoggerFactory.getLogger(SecureVaultComponent.class);
    private static final String SECURE_VAULT_CONFIG_ERROR = "Error occurred when obtaining secure vault configuration";

    @Activate
    public void activate() {
        logger.debug("Activating SecureVaultComponent");
    }

    @Deactivate
    public void deactivate() {
        logger.debug("Deactivating SecureVaultComponent");
    }

    @Reference(name="secure.vault.secret.repository", service=SecretRepository.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="unRegisterSecretRepository")
    protected void registerSecretRepository(SecretRepository secretRepository) {
        try {
            SecureVaultConfiguration secureVaultConfiguration = SecureVaultDataHolder.getInstance().getSecureVaultConfiguration().orElseThrow(() -> new SecureVaultException(SECURE_VAULT_CONFIG_ERROR));
            String secretRepositoryType = secureVaultConfiguration.getSecretRepositoryConfig().getType().orElseThrow(() -> new SecureVaultException("Secret repository type is not set"));
            if (secretRepository.getClass().getName().equals(secretRepositoryType)) {
                logger.debug("Registering secret repository : {}", (Object)secretRepositoryType);
                SecureVaultDataHolder.getInstance().setSecretRepository(secretRepository);
                this.initializeSecureVault();
            }
        }
        catch (SecureVaultException e) {
            logger.error("Error occurred when registering secret repository", (Throwable)e);
        }
    }

    protected void unRegisterSecretRepository(SecretRepository secretRepository) {
        try {
            SecureVaultConfiguration secureVaultConfiguration = SecureVaultDataHolder.getInstance().getSecureVaultConfiguration().orElseThrow(() -> new SecureVaultException(SECURE_VAULT_CONFIG_ERROR));
            String secretRepositoryType = secureVaultConfiguration.getSecretRepositoryConfig().getType().orElseThrow(() -> new SecureVaultException("Secret repository type is not set"));
            if (secretRepository.getClass().getName().equals(secretRepositoryType)) {
                logger.debug("Un-registering secret repository : {}", (Object)secretRepositoryType);
                SecureVaultDataHolder.getInstance().setSecretRepository(null);
            }
        }
        catch (SecureVaultException e) {
            logger.error("Error occurred when un-registering secret repository", (Throwable)e);
        }
    }

    @Reference(name="secure.vault.master.key.reader", service=MasterKeyReader.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="unregisterMasterKeyReader")
    protected void registerMasterKeyReader(MasterKeyReader masterKeyReader) {
        try {
            SecureVaultConfiguration secureVaultConfiguration = SecureVaultDataHolder.getInstance().getSecureVaultConfiguration().orElseThrow(() -> new SecureVaultException(SECURE_VAULT_CONFIG_ERROR));
            String masterKeyReaderType = secureVaultConfiguration.getMasterKeyReaderConfig().getType().orElseThrow(() -> new SecureVaultException("Master key reader type is not set"));
            if (masterKeyReader.getClass().getName().equals(masterKeyReaderType)) {
                logger.debug("Registering secret repository : ", (Object)masterKeyReaderType);
                SecureVaultDataHolder.getInstance().setMasterKeyReader(masterKeyReader);
                this.initializeSecureVault();
            }
        }
        catch (SecureVaultException e) {
            logger.error("Error occurred when registering master key reader", (Throwable)e);
        }
    }

    protected void unregisterMasterKeyReader(MasterKeyReader masterKeyReader) {
        try {
            SecureVaultConfiguration secureVaultConfiguration = SecureVaultDataHolder.getInstance().getSecureVaultConfiguration().orElseThrow(() -> new SecureVaultException(SECURE_VAULT_CONFIG_ERROR));
            String masterKeyReaderType = secureVaultConfiguration.getMasterKeyReaderConfig().getType().orElseThrow(() -> new SecureVaultException("Master key reader type is not set"));
            if (masterKeyReader.getClass().getName().equals(masterKeyReaderType)) {
                logger.debug("Un-registering secret repository : ", (Object)masterKeyReaderType);
                SecureVaultDataHolder.getInstance().setMasterKeyReader(null);
            }
        }
        catch (SecureVaultException e) {
            logger.error("Error occurred when un-registering master key reader", (Throwable)e);
        }
    }

    private void initializeSecureVault() throws SecureVaultException {
        if (!(SecureVaultDataHolder.getInstance().getSecretRepository().isPresent() && SecureVaultDataHolder.getInstance().getMasterKeyReader().isPresent() && SecureVaultDataHolder.getInstance().getBundleContext().isPresent())) {
            logger.debug("Waiting for Secure Vault dependencies");
            return;
        }
        Path secureVaultYamlPath = Utils.getRuntimeConfigPath().resolve("deployment.yaml");
        SecureVault secureVault = SecureVaultFactory.getSecureVault(secureVaultYamlPath).orElseThrow(() -> new SecureVaultException("Error occurred when getting secure vault instance"));
        SecureVaultDataHolder.getInstance().getBundleContext().ifPresent(bundleContext -> bundleContext.registerService(SecureVault.class, (Object)secureVault, null));
    }
}

