/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.extensions.touchpoint.actions;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;

public class ChmodAction
extends ProvisioningAction {
    private static final boolean WINDOWS = File.separatorChar == '\\';

    public IStatus execute(Map<String, Object> parameters) {
        String[] filesToProcess;
        String[] stringArray;
        Object absoluteFiles = parameters.get("absoluteFiles");
        String targetDir = (String)parameters.get("targetDir");
        String targetFile = (String)parameters.get("targetFile");
        String profile = parameters.get("profile").toString();
        if (targetFile != null && absoluteFiles != null) {
            return new Status(4, "org.wso2.carbon.p2.touchpoint", "Both Target file and absolute files can't be set");
        }
        if (targetDir != null && targetFile == null) {
            return new Status(4, "org.wso2.carbon.p2.touchpoint", "Target file is not set");
        }
        if (targetDir == null && targetFile != null) {
            return new Status(4, "org.wso2.carbon.p2.touchpoint", "Target directory is not set");
        }
        String permissions = (String)parameters.get("permissions");
        if (permissions == null) {
            return new Status(4, "org.wso2.carbon.p2.touchpoint", "Permission is not set");
        }
        String runtime = profile.substring(profile.indexOf("(") + 1, profile.length() - 1);
        targetDir = targetDir.replaceAll("\\{runtime\\}", runtime);
        targetFile = targetFile.replaceAll("\\{runtime\\}", runtime);
        String optionsString = (String)parameters.get("options");
        if (absoluteFiles != null) {
            if (absoluteFiles instanceof String) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = ((String)absoluteFiles).replaceAll("\\{runtime\\}", runtime);
            } else {
                stringArray = (String[])absoluteFiles;
            }
        } else {
            stringArray = this.makeFilesAbsolute(targetDir, targetFile);
        }
        for (String fileToChmod : filesToProcess = stringArray) {
            File probe = new File(fileToChmod);
            if (!probe.exists()) {
                return new Status(4, "org.wso2.carbon.p2.touchpoint", probe.toString() + " File doesn't exist");
            }
            this.doChmod(fileToChmod, permissions, optionsString);
        }
        return Status.OK_STATUS;
    }

    private String[] makeFilesAbsolute(String targetDir, String targetFile) {
        return new String[]{targetDir + '/' + targetFile};
    }

    private void doChmod(String fileToChmod, String permissions, String optionsString) {
        String[] options = null;
        if (optionsString != null) {
            ArrayList<String> collect = new ArrayList<String>();
            String r = optionsString.trim();
            while (r.length() > 0) {
                int spaceIdx = r.indexOf(32);
                if (spaceIdx < 0) {
                    collect.add(r);
                    r = "";
                    continue;
                }
                collect.add(r.substring(0, spaceIdx));
                r = r.substring(spaceIdx + 1);
                r = r.trim();
            }
            if (collect.size() > 0) {
                options = new String[collect.size()];
                collect.toArray(options);
            }
        }
        this.chmod(fileToChmod, permissions, options);
    }

    public IStatus undo(Map<String, Object> parameters) {
        return Status.OK_STATUS;
    }

    private void chmod(String fileToChmod, String perms, String[] options) {
        if (WINDOWS) {
            return;
        }
        Runtime r = Runtime.getRuntime();
        try {
            String[] args = new String[3 + (options == null ? 0 : options.length)];
            int i = 0;
            args[i++] = "chmod";
            if (options != null) {
                for (String option : options) {
                    args[i++] = option;
                }
            }
            args[i++] = perms;
            args[i] = fileToChmod;
            Process process = r.exec(args);
            this.readOffStream(process.getErrorStream());
            this.readOffStream(process.getInputStream());
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void readOffStream(InputStream inputStream) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, Charset.defaultCharset()));){
            while (reader.skip(Long.MAX_VALUE) == Long.MAX_VALUE) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

