/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.extensions.touchpoint.actions;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;

public class CopyAction
extends ProvisioningAction {
    public IStatus execute(Map<String, Object> parameters) {
        String target = (String)parameters.get("target");
        String source = (String)parameters.get("source");
        String overwrite = parameters.get("overwrite").toString();
        String profile = parameters.get("profile").toString();
        if (target == null) {
            return new Status(4, "org.wso2.carbon.p2.touchpoint", "Target is not defined");
        }
        if (source == null) {
            return new Status(4, "org.wso2.carbon.p2.touchpoint", "Source is not defined");
        }
        if (!Files.exists(Paths.get(source, new String[0]), new LinkOption[0])) {
            return new Status(4, "org.wso2.carbon.p2.touchpoint", "Source: " + source + "does not exists");
        }
        String runtime = profile.substring(profile.indexOf("(") + 1, profile.length() - 1);
        target = target.replaceAll("\\{runtime\\}", runtime);
        try {
            CopyAction.copy(new File(source), new File(target), Boolean.parseBoolean(overwrite));
        }
        catch (IOException e) {
            return new Status(4, "org.wso2.carbon.p2.touchpoint", "Failed to copy from source: " + source + " to target: " + target, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public IStatus undo(Map<String, Object> parameters) {
        return new Status(8, "org.wso2.carbon.p2.touchpoint", "Copy touchpoint does not support 'undo'");
    }

    private static void copy(File source, File target, boolean overwrite) throws IOException {
        if (source.isDirectory()) {
            if (target.exists() && target.isFile()) {
                if (!overwrite) {
                    throw new IOException("Target: " + target + " already exists");
                }
                if (!target.delete()) {
                    throw new IOException("Failed to delete target: " + target.toString());
                }
            }
            if (!target.exists() && !target.mkdirs()) {
                throw new IOException("Unable to create Target: " + target.toString());
            }
            File[] children = source.listFiles();
            if (children == null) {
                throw new IOException("Error while retrieving children of directory: " + source);
            }
            for (File child : children) {
                CopyAction.copy(child, new File(target, child.getName()), overwrite);
            }
            return;
        }
        if (target.exists() && !overwrite) {
            throw new IOException("Target: " + target + " already exists");
        }
        if (!target.getParentFile().exists() && !target.getParentFile().mkdirs()) {
            throw new IOException("Target: Path " + target.getParent() + " could not be created");
        }
        try {
            Files.copy(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new IOException("Error while copying:" + source.getAbsolutePath(), e);
        }
    }
}

