/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.jndi.internal.osgi.factory;

import java.util.Hashtable;
import java.util.Optional;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.NamingManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.ServiceReference;
import org.osgi.service.jndi.JNDIContextManager;
import org.wso2.carbon.jndi.internal.util.LambdaExceptionUtils;

public class DefaultContextFactory
implements InitialContextFactory {
    @Override
    public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
        Optional<BundleContext> bundleContextOptional = this.getCallersBundleContext(environment);
        bundleContextOptional.orElseThrow(NoInitialContextException::new);
        BundleContext callersBC = bundleContextOptional.get();
        Optional<ServiceReference> contextManagerSR = Optional.ofNullable(callersBC.getServiceReference(JNDIContextManager.class));
        return contextManagerSR.map(arg_0 -> ((BundleContext)callersBC).getService(arg_0)).map(LambdaExceptionUtils.rethrowFunction(jndiContextManager -> jndiContextManager.newInitialContext(environment))).orElseThrow(NoInitialContextException::new);
    }

    private Optional<BundleContext> getCallersBundleContext(Hashtable<?, ?> environment) {
        Optional<BundleContext> bundleContextOptional = this.getBundleContextFromEnvironment(environment);
        if (bundleContextOptional.isPresent()) {
            return bundleContextOptional;
        }
        bundleContextOptional = this.getBundleContextFromTCCL();
        if (bundleContextOptional.isPresent()) {
            return bundleContextOptional;
        }
        return this.getBundleContextFromCurrentClassStack();
    }

    private Optional<BundleContext> getBundleContextFromEnvironment(Hashtable<?, ?> environment) {
        Object obj = environment.get("osgi.service.jndi.bundleContext");
        Optional<BundleContext> bundleContextOptional = Optional.ofNullable(obj).filter(o -> o instanceof BundleContext).map(o -> (BundleContext)o);
        return bundleContextOptional;
    }

    private Optional<BundleContext> getBundleContextFromTCCL() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        Optional<BundleContext> bundleContextOptional = this.getCallersBundleContext(Optional.of(tccl));
        return bundleContextOptional;
    }

    private Optional<BundleContext> getBundleContextFromCurrentClassStack() {
        Optional<BundleContext> bundleContextOptional = Optional.empty();
        Class<?>[] currentClassStack = new DummySecurityManager().getClassContext();
        boolean found = false;
        for (int index = 0; index < currentClassStack.length; ++index) {
            Class<?> clazz = currentClassStack[index];
            if (found && (bundleContextOptional = this.getCallersBundleContext(Optional.ofNullable(clazz.getClassLoader()))).isPresent()) break;
            if (found || !NamingManager.class.isAssignableFrom(clazz) && !InitialContext.class.isAssignableFrom(clazz)) continue;
            found = true;
        }
        return bundleContextOptional;
    }

    private Optional<BundleContext> getCallersBundleContext(Optional<ClassLoader> classLoaderOptional) {
        if (!classLoaderOptional.isPresent()) {
            return Optional.empty();
        }
        Optional<BundleContext> bundleContextOptional = classLoaderOptional.filter(classLoader -> classLoader instanceof BundleReference).map(classLoader -> (BundleReference)classLoader).map(bundleReference -> bundleReference.getBundle().getBundleContext());
        if (bundleContextOptional.isPresent()) {
            return bundleContextOptional;
        }
        return this.getCallersBundleContext(Optional.ofNullable(classLoaderOptional.get().getParent()));
    }

    static class DummySecurityManager
    extends SecurityManager {
        DummySecurityManager() {
        }

        @Override
        public Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

