/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.launcher.extensions.model;

import org.wso2.carbon.launcher.extensions.model.BundleLocation;

public class BundleInfo {
    private String bundleSymbolicName;
    private String bundleVersion;
    private String bundlePath;
    private int startLevel;
    private boolean isFragment;
    private BundleLocation isFromOSGiLib;

    public BundleInfo(String bundleSymbolicName, String bundleVersion, String bundlePath, int startLevel, boolean isFragment) {
        this.bundleSymbolicName = bundleSymbolicName;
        this.bundleVersion = bundleVersion;
        this.bundlePath = bundlePath;
        this.startLevel = startLevel;
        this.isFragment = isFragment;
        this.isFromOSGiLib = bundlePath.contains("plugins/") ? BundleLocation.NON_OSGI_LIB_BUNDLE : BundleLocation.OSGI_LIB_BUNDLE;
    }

    public String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    public String getBundleVersion() {
        return this.bundleVersion;
    }

    public BundleLocation isFromOSGiLib() {
        return this.isFromOSGiLib;
    }

    public static BundleInfo getInstance(String bundleInfoLineString) {
        String[] parts = bundleInfoLineString.split(",");
        if (parts.length != 5) {
            throw new RuntimeException("Invalid line in the bundles.info file: " + bundleInfoLineString);
        }
        return new BundleInfo(parts[0].trim(), parts[1].trim(), parts[2].trim(), Integer.parseInt(parts[3].trim()), !Boolean.parseBoolean(parts[4].trim()));
    }

    public String toString() {
        return this.bundleSymbolicName + "," + this.bundleVersion + "," + this.bundlePath + "," + this.startLevel + "," + Boolean.toString(!this.isFragment);
    }

    public boolean equals(Object object) {
        if (object instanceof BundleInfo) {
            BundleInfo other = (BundleInfo)object;
            return this.bundleSymbolicName != null && this.bundleVersion != null && other.bundleSymbolicName != null && other.bundleVersion != null && this.bundleSymbolicName.equals(other.bundleSymbolicName) && this.bundleVersion.equals(other.bundleVersion);
        }
        return false;
    }

    public int hashCode() {
        return this.bundleSymbolicName.hashCode() * this.bundleVersion.hashCode();
    }
}

