/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.config.reader;

import com.github.mustachejava.DefaultMustacheFactory;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class YmlMerger {
    private static final Logger LOG = LoggerFactory.getLogger(YmlMerger.class);
    private static final DefaultMustacheFactory DEFAULT_MUSTACHE_FACTORY = new DefaultMustacheFactory();
    private final Yaml snakeYaml;
    private Map<String, Object> variablesToReplace = new HashMap<String, Object>();

    public YmlMerger() {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        dumperOptions.setPrettyFlow(true);
        dumperOptions.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.snakeYaml = new Yaml(dumperOptions);
    }

    public YmlMerger setVariablesToReplace(Map<String, String> vars) {
        this.variablesToReplace.clear();
        this.variablesToReplace.putAll(vars);
        return this;
    }

    private Map<String, Object> mergeYamlContents(List<String> contents) {
        LinkedHashMap<String, Object> mergedResult = new LinkedHashMap<String, Object>();
        for (String yamlContent : contents) {
            int bufferSize = yamlContent.length() + 100;
            StringWriter writer = new StringWriter(bufferSize);
            DEFAULT_MUSTACHE_FACTORY.compile(new StringReader(yamlContent), "yaml-mergeYamlFiles-" + System.currentTimeMillis()).execute((Writer)writer, this.variablesToReplace);
            String yamlString = writer.toString();
            Map yamlToMerge = (Map)this.snakeYaml.load(yamlString);
            this.mergeStructures(mergedResult, yamlToMerge);
        }
        return mergedResult;
    }

    private void mergeStructures(Map<String, Object> targetTree, Map<String, Object> sourceTree) {
        if (sourceTree == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : sourceTree.entrySet()) {
            Object yamlValue = entry.getValue();
            String key = entry.getKey().toString();
            if (yamlValue == null) {
                YmlMerger.addToMergedResult(targetTree, key, null);
                continue;
            }
            Object existingValue = targetTree.get(key);
            if (existingValue != null) {
                if (yamlValue instanceof Map) {
                    if (existingValue instanceof Map) {
                        this.mergeStructures((Map)existingValue, (Map)yamlValue);
                        continue;
                    }
                    if (existingValue instanceof String) {
                        throw new IllegalArgumentException("Cannot merge Yaml files; complex element into a simple element: " + key);
                    }
                    throw YmlMerger.unknownValueType(key, yamlValue);
                }
                if (yamlValue instanceof List) {
                    YmlMerger.mergeLists(targetTree, key, yamlValue);
                    continue;
                }
                if (yamlValue instanceof String || yamlValue instanceof Boolean || yamlValue instanceof Double || yamlValue instanceof Integer) {
                    LOG.debug("Overriding value of " + key + " with value " + yamlValue);
                    YmlMerger.addToMergedResult(targetTree, key, yamlValue);
                    continue;
                }
                throw YmlMerger.unknownValueType(key, yamlValue);
            }
            if (yamlValue instanceof Map || yamlValue instanceof List || yamlValue instanceof String || yamlValue instanceof Boolean || yamlValue instanceof Integer || yamlValue instanceof Double) {
                LOG.debug("Adding new key->value: " + key + " -> " + yamlValue);
                YmlMerger.addToMergedResult(targetTree, key, yamlValue);
                continue;
            }
            throw YmlMerger.unknownValueType(key, yamlValue);
        }
    }

    private static IllegalArgumentException unknownValueType(String key, Object yamlValue) {
        String msg = "Cannot merge Yaml files; element of unknown type: " + key + ": " + yamlValue.getClass().getName();
        LOG.error(msg);
        return new IllegalArgumentException(msg);
    }

    private static void addToMergedResult(Map<String, Object> mergedResult, String key, Object yamlValue) {
        mergedResult.put(key, yamlValue);
    }

    private static void mergeLists(Map<String, Object> mergedResult, String key, Object yamlValue) {
        if (!(yamlValue instanceof List) || !(mergedResult.get(key) instanceof List)) {
            throw new IllegalArgumentException("Cannot merge Yaml files; list with a non-list: " + key);
        }
        List originalList = (List)mergedResult.get(key);
        originalList.clear();
        originalList.addAll((List)yamlValue);
    }

    String mergeToString(List<String> contentToMerge) {
        Map<String, Object> merged = this.mergeYamlContents(contentToMerge);
        return this.exportToString(merged);
    }

    private String exportToString(Map<String, Object> merged) {
        return this.snakeYaml.dump(merged);
    }
}

