/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.datasource.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.datasource.core.beans.CarbonDataSource;
import org.wso2.carbon.datasource.core.beans.DataSourceMetadata;
import org.wso2.carbon.datasource.core.exception.DataSourceException;

public class DataSourceRepository {
    private static Logger logger = LoggerFactory.getLogger(DataSourceRepository.class);
    private Map<String, CarbonDataSource> dataSources = new HashMap<String, CarbonDataSource>();

    public List<DataSourceMetadata> getMetadata() {
        return this.dataSources.values().stream().map(CarbonDataSource::getMetadata).collect(Collectors.toList());
    }

    public DataSourceMetadata getMetadata(String dataSourceName) {
        CarbonDataSource carbonDataSource = this.getDataSource(dataSourceName);
        if (carbonDataSource != null) {
            return carbonDataSource.getMetadata();
        }
        return null;
    }

    public List<CarbonDataSource> getDataSources() {
        return this.dataSources.values().stream().collect(Collectors.toList());
    }

    public CarbonDataSource getDataSource(String dataSourceName) {
        return this.dataSources.get(dataSourceName);
    }

    public void addDataSource(CarbonDataSource carbonDataSource) throws DataSourceException {
        if (logger.isDebugEnabled()) {
            logger.debug("Adding data source: " + carbonDataSource.getMetadata().getName());
        }
        this.dataSources.put(carbonDataSource.getMetadata().getName(), carbonDataSource);
    }

    public void deleteDataSource(String dataSourceName) throws DataSourceException {
        CarbonDataSource cds;
        if (logger.isDebugEnabled()) {
            logger.debug("Deleting data source: " + dataSourceName);
        }
        if ((cds = this.getDataSource(dataSourceName)) == null) {
            throw new DataSourceException("Data source does not exist: " + dataSourceName);
        }
        this.dataSources.remove(dataSourceName);
    }
}

