/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.datasource.core.internal;

import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.jndi.JNDIContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.carbon.datasource.core.DataSourceManager;
import org.wso2.carbon.datasource.core.api.DataSourceManagementService;
import org.wso2.carbon.datasource.core.api.DataSourceService;
import org.wso2.carbon.datasource.core.exception.DataSourceException;
import org.wso2.carbon.datasource.core.impl.DataSourceManagementServiceImpl;
import org.wso2.carbon.datasource.core.impl.DataSourceServiceImpl;
import org.wso2.carbon.datasource.core.spi.DataSourceReader;
import org.wso2.carbon.kernel.startupresolver.RequiredCapabilityListener;
import org.wso2.carbon.kernel.startupresolver.StartupServiceUtils;

@Component(name="org.wso2.carbon.kernel.datasource.core.internal.DataSourceListenerComponent", immediate=true, property={"componentName=carbon-datasource-service"})
public class DataSourceListenerComponent
implements RequiredCapabilityListener {
    public static final String COMPONENT_NAME = "carbon-datasource-service";
    private static final Logger logger = LoggerFactory.getLogger(DataSourceListenerComponent.class);
    private BundleContext bundleContext;
    private Map<String, DataSourceReader> readers = new HashMap<String, DataSourceReader>();
    private ConfigProvider configProvider;

    @Activate
    protected void start(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Reference(name="org.wso2.carbon.datasource.jndi", service=JNDIContextManager.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unRegisterJNDIContextManager")
    protected void registerJNDIContextManager(JNDIContextManager jndiContextManager) {
    }

    protected void unRegisterJNDIContextManager(JNDIContextManager jndiContextManager) {
    }

    @Reference(name="carbon.datasource.DataSourceReader", service=DataSourceReader.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unregisterReader")
    protected void registerReader(DataSourceReader reader) {
        this.readers.put(reader.getType(), reader);
        StartupServiceUtils.updateServiceCache((String)COMPONENT_NAME, DataSourceReader.class);
    }

    protected void unregisterReader(DataSourceReader reader) {
        this.readers.remove(reader.getType());
    }

    @Reference(name="carbon.config.provider", service=ConfigProvider.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unregisterConfigProvider")
    protected void registerConfigProvider(ConfigProvider configProvider) {
        this.configProvider = configProvider;
    }

    protected void unregisterConfigProvider(ConfigProvider configProvider) {
        this.configProvider = null;
    }

    public void onAllRequiredCapabilitiesAvailable() {
        try {
            DataSourceManager dataSourceManager = DataSourceManager.getInstance();
            dataSourceManager.initDataSources(this.configProvider, this.readers);
            DataSourceServiceImpl dsService = new DataSourceServiceImpl();
            this.bundleContext.registerService(DataSourceService.class, (Object)dsService, null);
            DataSourceManagementServiceImpl dataSourceMgtService = new DataSourceManagementServiceImpl();
            this.bundleContext.registerService(DataSourceManagementService.class, (Object)dataSourceMgtService, null);
        }
        catch (DataSourceException e) {
            logger.error("Error occurred while initializing data sources", (Throwable)e);
        }
    }
}

